
#include <stdarg.h>
#include <ctype.h>
#include "monitor.h"
#include "ConfigFile.h"
#include "SDFileSystem.h"
#include "FATDirHandle.h"

extern SDFileSystem sd;                 // definiert in main
extern Serial pc;                       // definiert in main
extern Buffer <char> buf;               // definiert in main
extern ConfigFile cfg;                  // definiert in main
extern char value[BUFSIZ];              // definiert in main

#define COMMAND_MAX    9
#define COMMAND_LEN    7

const char command[COMMAND_MAX][COMMAND_LEN] = {"DATE","DEL","DIR","DUMP","FILL","HELP","LIST","SET","TIME"};

char buffer[100]; 

// globale Variablen

char com_line[COM_LINE_LEN];        // Aktuelle Eingabezeile 
uint8_t ComLinePtr, ComLineTop;     // Cursor Position und Zeilenlänge

uint8_t cr_flag;

// uint16_t status[8];

//-----------------------------------------------------------------------------
// initialisierung

void mon_init(void)
{

      uint8_t i;
      
      for (i = 0; i < COM_LINE_LEN; com_line[i++] = 0);
      ComLinePtr = ComLineTop = 0;
      cr_flag = false;
      
      // 0 Kanal ist daktiv
      // 1 Rohdaten ausgeben
      // 2 Temperaturwert in Float Darstellung
      
      /*
      status[0] = 2;  // Temperaturwerte ausgeben 
      status[1] = 0;
      status[2] = 0;
      status[3] = 0;
      status[4] = 0;
      status[5] = 0;
      status[6] = 0;
      status[7] = 0;
      */
}

//-----------------------------------------------------------------------------
// destructor

void parser (void)
{
  uint8_t i, ch, tch, top, bottom, len;
  int8_t res;

  // Zuerst wird der erste Buchstabe aus dem Eingabestring mit den ersten 
  // Buchstaben aus der Befehlstabelle verglichen                         

  bottom = 0;                                        // untere Suchgrenze 
  top = COMMAND_MAX;                                 // obere Suchgerenze 
  ch = com_line[0];                            // hole erstes Suchzeichen
  
  do 
  {
        i = (top + bottom) >> 1;    // suche in der Mitte des Feldes beginnen
        tch = command [i][0];                     // Vergleichszeichen laden 
        if (tch == ch) break;                             // Zeichen gefunden 
        if (tch > ch) top = i;                           // nach unten suchen 
        else bottom = i;                                  // nach oben suchen 
        if (bottom != 0 && top == bottom + 1) break;   // kein Buchstabe gef.
  
  } while (i > 0 && i < COMMAND_MAX - 1);

  if (tch != ch)
  {
        pc.printf("\nParser Kommando nicht gefunden\n");
        return;                              // Kommando nicht gefunden wurde 
  }
  
  // das erst Wort soll von den Übergabeparametern isoliert werden        
  
  for (i = 0; com_line[i] != ' ' &&  com_line[i] != 0; i++);
  len = i;

  
  if (i == 0) return;

  // die Übergabparameter ermitteln und in als Indexzeiger in            
  // 'ComLinePtr' abspeichern                                            

  for ( ; com_line[i] == ' ' && com_line[i] != 0; i++);
  ComLinePtr = i;
  
  // die binäre Suche nach den restlichen Zeichen wird hier fortgesetzt 

  do
  {
        i = (top + bottom) >> 1;                 // berechnen des Suchplatzes
        //printf_P (PSTR("\n\rVergleich 1 com_line = [%s] und Länge = [%d]"),com_line,len);
        //strcpy_P (temp, &command[i][0]);
        //printf_P (PSTR("\n\rVergleich 2 command[i] = [%s] und Index = [%d]"),temp,i);
        res = strncmp(com_line, &command[i][0], len);
        //printf_P (PSTR("\n\rVergleich 3 res = [%d]"),res);
        if (res == 0) break;                       // Zeichen gefunden 
        if (res > 0) 
            bottom = i;                            // nach unten suchen
        else 
            top = i;                               // nach oben suchen
        if (bottom != 0 && top == bottom + 1) break;
  
  } while (i > 0 && i < COMMAND_MAX - 1);

  
  if (res) 
  {
        pc.printf("\nParser Kommando nicht gefunden.\n");
  }
  else 
  {
        pc.printf("\nAufruf von Funktion %d",i);
        
        switch(i)                       // Programmaufruf
        {
          case  0: date(); break;
          case  1: del();  break;
          case  2: dir();  break;
          case  3: dump(); break;
          case  4: fill(); break;
          case  5: help(); break;
          case  6: list(); break;
          case  7: set();  break;
          case  8: time(); break;
          
        }                                   
  }
}



//-----------------------------------------------------------------------------
// eine Zeile aus dem Eingangsbuffer lesen 
  
void get_line(void)
{
    char ch;
    uint8_t i;
     
    get_ch();
    if (cr_flag)                            // Neue Eingabezeile  
    {
        if (com_line[0] != 0)
        {
            // uart_puts(com_line);         // zum Testen => später wird der parcer aufgerufen
            // Zeichenkette in Großbuchstaben umwandeln

            // printf_P (PSTR("\n monitor "));
            for (i = 0; com_line[i] != 0; i++)
            {
                ch = com_line[i];
                ch = toupper(ch);                          // Nur Großbuchstaben 
                com_line[i] = ch;
                // pc.printf(("\n[%02x] %c"),ch,ch);                
                if (ch == ' ') i = COM_LINE_LEN;
            }
            // pc.printf(("\n"));
            parser();                                   // Parcer wird aufgerufen
        }
 
        for (i=0; i < COM_LINE_LEN; com_line[i++] = 0);
        ComLinePtr = ComLineTop = 0;                         
        cr_flag = 0;
    }     
}

//-----------------------------------------------------------------------------
// eine Zeichen aus dem Eingangsbuffer lesen 

void get_ch (void)
{
    char ch;
  
    if (!buf.available()) return;               // kein Zeichen vorhanden 
     
    ch = buf.get();                             // hole das Zeichen  
    // printf("mon_line: %c %02x\n",ch,ch);     // nur zum Test
  
    switch(ch) 
    {
        case '\r':     // CARRIAGE RETURN  
            cr_flag = true;
            break;

        case '\n':      // LF empfangen
            cr_flag = true;
            break;

        default:                                 // Normales Zeichen  
            if (~iscntrl(ch)) 
            {
                com_line[ComLinePtr] = ch;       // Zeichen einfuegen 
                ComLinePtr++;
            }
            break;

    }   // Ende SWITCH
    
    if (ComLinePtr >= 80) cr_flag = 1;           // Zeilenüberlauf ?  
    
}

//-----------------------------------------------------------------------------
// monitor Aufruf

void date(void)
{
  pc.printf("\nin date");
}

//-----------------------------------------------------------------------------
// monitor Aufruf

void dump(void)
{
  pc.printf("\nin dump");
}

//-----------------------------------------------------------------------------
// monitor Aufruf

void help(void)
{
  pc.printf("\n -- help ------------------------");
  pc.printf("\n set index [val] Sensor auswaehlen");
  pc.printf("\n");
  pc.printf("\n -- files ------------------------");
  pc.printf("\n dir  >> Dateien anzeigen");  
  pc.printf("\n list name >> den Inhalte einer Datei anzeigen"); 
  pc.printf("\n del name >> eine Datei loeschen"); 
  pc.printf("\n fill name [zeilen] >> eine Datei anlegen und fuellen");        
  pc.printf("\n");
}

//-----------------------------------------------------------------------------
// monitor Aufruf

void set(void)
{
    
    int n;
    char name[20], wert[20];

    n = sscanf(&com_line[ComLinePtr],"%s %s",name,wert);
    
    switch (n)
    {
      case -1: pc.printf("\n list config file");
              
              cfg.read("/sd/input.cfg");
              
              pc.printf("\n Index >> Sonsor 0 bis 7");
              pc.printf("\n wert  >> 0 = inaktiv, 1 = Rohwerte, 2 = errechneter Wert");
              break;
      
      case 1: pc.printf("\n list config value");
              
              cfg.read("/sd/input.cfg");
              
              if (cfg.getValue(name, &value[0], sizeof(value))) 
              {
                pc.printf("\n'%s'='%s'", name, value);
              }
              break;
              
      case 2: pc.printf("\n'%s' = '%s'",name,wert);
               
              cfg.setValue(name, wert);
              cfg.write("/sd/input.cfg");
              
              break;
     } // end switch
    
}

//-----------------------------------------------------------------------------
// monitor Aufruf

void time(void)
{
  pc.printf("\nin timer");
}

//-----------------------------------------------------------------------------
// monitor Aufruf dir
//
// weiter Infos siehe auch
// http://elm-chan.org/fsw/ff/00index_e.html
//
void dir(void)
{
    long size;

    DIR *d;
    struct dirent *p;

    d = opendir("/sd");
    if (d != NULL) 
    {
        while ((p = readdir(d)) != NULL) 
        {
            sprintf(buffer,"/sd/%s",p->d_name);
            pc.printf("\n %s", p->d_name);
            FILE * f = fopen(buffer, "r");
            fseek(f, 0, SEEK_END); // seek to end of file
            size = ftell(f);       // get current file pointer
            pc.printf("    %ld bytes ",size);            

            time_t fattime = get_fattime();
            strftime(buffer, 40, "%a,%d %m %Y.%H:%M:%S", localtime(&fattime));
            pc.printf(" %s ", buffer);

            fclose(f);
        }
        
    }
    else 
    {
        pc.printf("\nCould not open directory!\n");
    }
    closedir(d);
    
 
    FATFS* fs;
    DWORD fre_clust;
    f_getfree("0:",&fre_clust,&fs);
    const float frs = float(fs->csize)*float(fs->free_clust)
    #if _MAX_SS != 512
        *(fs->ssize);
    #else
        *512;
    #endif
    pc.printf("\n\nfree space = %f GB",frs/1073741824.0);

    pc.printf("\ndone\n");
}

//-----------------------------------------------------------------------------
// monitor Aufruf list

void list(void)
{
    char dname[25];
    int ch;
      
    sscanf(&com_line[ComLinePtr],"%s",dname);
    sprintf(buffer,"/sd/%s",dname);
    pc.printf("\nlist, file %s \n",buffer);
    FILE * fp = fopen(buffer, "r");
    if(fp == NULL) 
    {
        pc.printf("\nCould not open file for read\n\r");
        return;
    }
    
    // mit fgets werden die Zeile einzeln gelesen, wenn die Länge < 64 Zeichen ist

    while (1)                     // list src to pc  
    {
        ch = fgetc(fp);           // until src EOF read. 
        if (ch == EOF) break;
        pc.putc(ch);  
    }
    
    fclose(fp);
            
    pc.printf("\ndone\n");
}

//-----------------------------------------------------------------------------
// monitor Aufruf del

void del(void)
{
    char dname[25];
    char buffer[40];
    
    sscanf(&com_line[ComLinePtr],"%s",dname);
    sprintf(buffer,"/sd/%s",dname);
    pc.printf("\ndelete file %s",buffer);
    remove(buffer);
    pc.printf("\ndone");
}

//-----------------------------------------------------------------------------
// monitor Aufruf fill

void fill(void)
{
    char dname[25];
    char buffer[40];
    int n = 20;
    
    sscanf(&com_line[ComLinePtr],"%s %d",dname,&n);
    sprintf(buffer,"/sd/%s",dname);
    pc.printf("\nfill file %s \n",buffer);
    FILE *fp = fopen(buffer, "w");
    if(fp == NULL) 
    {
        pc.printf("Could not open file for write\n");
    }
    for (int i = 0; i<n; i++)
    {
        fprintf(fp, "\nschreibe eine Zeile %d ",i);
    }
    fclose(fp); 
    pc.printf("\ndone\n");
}


