/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_PDB_REGISTERS_H__
#define __HW_PDB_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 PDB
 *
 * Programmable Delay Block
 *
 * Registers defined in this header file:
 * - HW_PDB_SC - Status and Control register
 * - HW_PDB_MOD - Modulus register
 * - HW_PDB_CNT - Counter register
 * - HW_PDB_IDLY - Interrupt Delay register
 * - HW_PDB_CHnC1 - Channel n Control register 1
 * - HW_PDB_CHnS - Channel n Status register
 * - HW_PDB_CHnDLY0 - Channel n Delay 0 register
 * - HW_PDB_CHnDLY1 - Channel n Delay 1 register
 * - HW_PDB_DACINTCn - DAC Interval Trigger n Control register
 * - HW_PDB_DACINTn - DAC Interval n register
 * - HW_PDB_POEN - Pulse-Out n Enable register
 * - HW_PDB_POnDLY - Pulse-Out n Delay register
 *
 * - hw_pdb_t - Struct containing all module registers.
 */

#define HW_PDB_INSTANCE_COUNT (1U) /*!< Number of instances of the PDB module. */

/*******************************************************************************
 * HW_PDB_SC - Status and Control register
 ******************************************************************************/

/*!
 * @brief HW_PDB_SC - Status and Control register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_sc
{
    uint32_t U;
    struct _hw_pdb_sc_bitfields
    {
        uint32_t LDOK : 1;             /*!< [0] Load OK */
        uint32_t CONT : 1;             /*!< [1] Continuous Mode Enable */
        uint32_t MULT : 2;             /*!< [3:2] Multiplication Factor Select for
                                        * Prescaler */
        uint32_t RESERVED0 : 1;        /*!< [4]  */
        uint32_t PDBIE : 1;            /*!< [5] PDB Interrupt Enable */
        uint32_t PDBIF : 1;            /*!< [6] PDB Interrupt Flag */
        uint32_t PDBEN : 1;            /*!< [7] PDB Enable */
        uint32_t TRGSEL : 4;           /*!< [11:8] Trigger Input Source Select */
        uint32_t PRESCALER : 3;        /*!< [14:12] Prescaler Divider Select */
        uint32_t DMAEN : 1;            /*!< [15] DMA Enable */
        uint32_t SWTRIG : 1;           /*!< [16] Software Trigger */
        uint32_t PDBEIE : 1;           /*!< [17] PDB Sequence Error Interrupt Enable */
        uint32_t LDMOD : 2;            /*!< [19:18] Load Mode Select */
        uint32_t RESERVED1 : 12;       /*!< [31:20]  */
    } B;
} hw_pdb_sc_t;

/*!
 * @name Constants and macros for entire PDB_SC register
 */
/*@{*/
#define HW_PDB_SC_ADDR(x)        ((x) + 0x0U)

#define HW_PDB_SC(x)             (*(__IO hw_pdb_sc_t *) HW_PDB_SC_ADDR(x))
#define HW_PDB_SC_RD(x)          (HW_PDB_SC(x).U)
#define HW_PDB_SC_WR(x, v)       (HW_PDB_SC(x).U = (v))
#define HW_PDB_SC_SET(x, v)      (HW_PDB_SC_WR(x, HW_PDB_SC_RD(x) |  (v)))
#define HW_PDB_SC_CLR(x, v)      (HW_PDB_SC_WR(x, HW_PDB_SC_RD(x) & ~(v)))
#define HW_PDB_SC_TOG(x, v)      (HW_PDB_SC_WR(x, HW_PDB_SC_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual PDB_SC bitfields
 */

/*!
 * @name Register PDB_SC, field LDOK[0] (RW)
 *
 * Writing 1 to this bit updates the internal registers of MOD, IDLY, CHnDLYm,
 * DACINTx,and POyDLY with the values written to their buffers. The MOD, IDLY,
 * CHnDLYm, DACINTx, and POyDLY will take effect according to the LDMOD. After 1 is
 * written to the LDOK field, the values in the buffers of above registers are
 * not effective and the buffers cannot be written until the values in buffers are
 * loaded into their internal registers. LDOK can be written only when PDBEN is
 * set or it can be written at the same time with PDBEN being written to 1. It is
 * automatically cleared when the values in buffers are loaded into the internal
 * registers or the PDBEN is cleared. Writing 0 to it has no effect.
 */
/*@{*/
#define BP_PDB_SC_LDOK       (0U)          /*!< Bit position for PDB_SC_LDOK. */
#define BM_PDB_SC_LDOK       (0x00000001U) /*!< Bit mask for PDB_SC_LDOK. */
#define BS_PDB_SC_LDOK       (1U)          /*!< Bit field size in bits for PDB_SC_LDOK. */

/*! @brief Read current value of the PDB_SC_LDOK field. */
#define BR_PDB_SC_LDOK(x)    (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_LDOK))

/*! @brief Format value for bitfield PDB_SC_LDOK. */
#define BF_PDB_SC_LDOK(v)    ((uint32_t)((uint32_t)(v) << BP_PDB_SC_LDOK) & BM_PDB_SC_LDOK)

/*! @brief Set the LDOK field to a new value. */
#define BW_PDB_SC_LDOK(x, v) (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_LDOK) = (v))
/*@}*/

/*!
 * @name Register PDB_SC, field CONT[1] (RW)
 *
 * Enables the PDB operation in Continuous mode.
 *
 * Values:
 * - 0 - PDB operation in One-Shot mode
 * - 1 - PDB operation in Continuous mode
 */
/*@{*/
#define BP_PDB_SC_CONT       (1U)          /*!< Bit position for PDB_SC_CONT. */
#define BM_PDB_SC_CONT       (0x00000002U) /*!< Bit mask for PDB_SC_CONT. */
#define BS_PDB_SC_CONT       (1U)          /*!< Bit field size in bits for PDB_SC_CONT. */

/*! @brief Read current value of the PDB_SC_CONT field. */
#define BR_PDB_SC_CONT(x)    (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_CONT))

/*! @brief Format value for bitfield PDB_SC_CONT. */
#define BF_PDB_SC_CONT(v)    ((uint32_t)((uint32_t)(v) << BP_PDB_SC_CONT) & BM_PDB_SC_CONT)

/*! @brief Set the CONT field to a new value. */
#define BW_PDB_SC_CONT(x, v) (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_CONT) = (v))
/*@}*/

/*!
 * @name Register PDB_SC, field MULT[3:2] (RW)
 *
 * Selects the multiplication factor of the prescaler divider for the counter
 * clock.
 *
 * Values:
 * - 00 - Multiplication factor is 1.
 * - 01 - Multiplication factor is 10.
 * - 10 - Multiplication factor is 20.
 * - 11 - Multiplication factor is 40.
 */
/*@{*/
#define BP_PDB_SC_MULT       (2U)          /*!< Bit position for PDB_SC_MULT. */
#define BM_PDB_SC_MULT       (0x0000000CU) /*!< Bit mask for PDB_SC_MULT. */
#define BS_PDB_SC_MULT       (2U)          /*!< Bit field size in bits for PDB_SC_MULT. */

/*! @brief Read current value of the PDB_SC_MULT field. */
#define BR_PDB_SC_MULT(x)    (HW_PDB_SC(x).B.MULT)

/*! @brief Format value for bitfield PDB_SC_MULT. */
#define BF_PDB_SC_MULT(v)    ((uint32_t)((uint32_t)(v) << BP_PDB_SC_MULT) & BM_PDB_SC_MULT)

/*! @brief Set the MULT field to a new value. */
#define BW_PDB_SC_MULT(x, v) (HW_PDB_SC_WR(x, (HW_PDB_SC_RD(x) & ~BM_PDB_SC_MULT) | BF_PDB_SC_MULT(v)))
/*@}*/

/*!
 * @name Register PDB_SC, field PDBIE[5] (RW)
 *
 * Enables the PDB interrupt. When this field is set and DMAEN is cleared, PDBIF
 * generates a PDB interrupt.
 *
 * Values:
 * - 0 - PDB interrupt disabled.
 * - 1 - PDB interrupt enabled.
 */
/*@{*/
#define BP_PDB_SC_PDBIE      (5U)          /*!< Bit position for PDB_SC_PDBIE. */
#define BM_PDB_SC_PDBIE      (0x00000020U) /*!< Bit mask for PDB_SC_PDBIE. */
#define BS_PDB_SC_PDBIE      (1U)          /*!< Bit field size in bits for PDB_SC_PDBIE. */

/*! @brief Read current value of the PDB_SC_PDBIE field. */
#define BR_PDB_SC_PDBIE(x)   (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_PDBIE))

/*! @brief Format value for bitfield PDB_SC_PDBIE. */
#define BF_PDB_SC_PDBIE(v)   ((uint32_t)((uint32_t)(v) << BP_PDB_SC_PDBIE) & BM_PDB_SC_PDBIE)

/*! @brief Set the PDBIE field to a new value. */
#define BW_PDB_SC_PDBIE(x, v) (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_PDBIE) = (v))
/*@}*/

/*!
 * @name Register PDB_SC, field PDBIF[6] (RW)
 *
 * This field is set when the counter value is equal to the IDLY register.
 * Writing zero clears this field.
 */
/*@{*/
#define BP_PDB_SC_PDBIF      (6U)          /*!< Bit position for PDB_SC_PDBIF. */
#define BM_PDB_SC_PDBIF      (0x00000040U) /*!< Bit mask for PDB_SC_PDBIF. */
#define BS_PDB_SC_PDBIF      (1U)          /*!< Bit field size in bits for PDB_SC_PDBIF. */

/*! @brief Read current value of the PDB_SC_PDBIF field. */
#define BR_PDB_SC_PDBIF(x)   (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_PDBIF))

/*! @brief Format value for bitfield PDB_SC_PDBIF. */
#define BF_PDB_SC_PDBIF(v)   ((uint32_t)((uint32_t)(v) << BP_PDB_SC_PDBIF) & BM_PDB_SC_PDBIF)

/*! @brief Set the PDBIF field to a new value. */
#define BW_PDB_SC_PDBIF(x, v) (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_PDBIF) = (v))
/*@}*/

/*!
 * @name Register PDB_SC, field PDBEN[7] (RW)
 *
 * Values:
 * - 0 - PDB disabled. Counter is off.
 * - 1 - PDB enabled.
 */
/*@{*/
#define BP_PDB_SC_PDBEN      (7U)          /*!< Bit position for PDB_SC_PDBEN. */
#define BM_PDB_SC_PDBEN      (0x00000080U) /*!< Bit mask for PDB_SC_PDBEN. */
#define BS_PDB_SC_PDBEN      (1U)          /*!< Bit field size in bits for PDB_SC_PDBEN. */

/*! @brief Read current value of the PDB_SC_PDBEN field. */
#define BR_PDB_SC_PDBEN(x)   (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_PDBEN))

/*! @brief Format value for bitfield PDB_SC_PDBEN. */
#define BF_PDB_SC_PDBEN(v)   ((uint32_t)((uint32_t)(v) << BP_PDB_SC_PDBEN) & BM_PDB_SC_PDBEN)

/*! @brief Set the PDBEN field to a new value. */
#define BW_PDB_SC_PDBEN(x, v) (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_PDBEN) = (v))
/*@}*/

/*!
 * @name Register PDB_SC, field TRGSEL[11:8] (RW)
 *
 * Selects the trigger input source for the PDB. The trigger input source can be
 * internal or external (EXTRG pin), or the software trigger. Refer to chip
 * configuration details for the actual PDB input trigger connections.
 *
 * Values:
 * - 0000 - Trigger-In 0 is selected.
 * - 0001 - Trigger-In 1 is selected.
 * - 0010 - Trigger-In 2 is selected.
 * - 0011 - Trigger-In 3 is selected.
 * - 0100 - Trigger-In 4 is selected.
 * - 0101 - Trigger-In 5 is selected.
 * - 0110 - Trigger-In 6 is selected.
 * - 0111 - Trigger-In 7 is selected.
 * - 1000 - Trigger-In 8 is selected.
 * - 1001 - Trigger-In 9 is selected.
 * - 1010 - Trigger-In 10 is selected.
 * - 1011 - Trigger-In 11 is selected.
 * - 1100 - Trigger-In 12 is selected.
 * - 1101 - Trigger-In 13 is selected.
 * - 1110 - Trigger-In 14 is selected.
 * - 1111 - Software trigger is selected.
 */
/*@{*/
#define BP_PDB_SC_TRGSEL     (8U)          /*!< Bit position for PDB_SC_TRGSEL. */
#define BM_PDB_SC_TRGSEL     (0x00000F00U) /*!< Bit mask for PDB_SC_TRGSEL. */
#define BS_PDB_SC_TRGSEL     (4U)          /*!< Bit field size in bits for PDB_SC_TRGSEL. */

/*! @brief Read current value of the PDB_SC_TRGSEL field. */
#define BR_PDB_SC_TRGSEL(x)  (HW_PDB_SC(x).B.TRGSEL)

/*! @brief Format value for bitfield PDB_SC_TRGSEL. */
#define BF_PDB_SC_TRGSEL(v)  ((uint32_t)((uint32_t)(v) << BP_PDB_SC_TRGSEL) & BM_PDB_SC_TRGSEL)

/*! @brief Set the TRGSEL field to a new value. */
#define BW_PDB_SC_TRGSEL(x, v) (HW_PDB_SC_WR(x, (HW_PDB_SC_RD(x) & ~BM_PDB_SC_TRGSEL) | BF_PDB_SC_TRGSEL(v)))
/*@}*/

/*!
 * @name Register PDB_SC, field PRESCALER[14:12] (RW)
 *
 * Values:
 * - 000 - Counting uses the peripheral clock divided by multiplication factor
 *     selected by MULT.
 * - 001 - Counting uses the peripheral clock divided by twice of the
 *     multiplication factor selected by MULT.
 * - 010 - Counting uses the peripheral clock divided by four times of the
 *     multiplication factor selected by MULT.
 * - 011 - Counting uses the peripheral clock divided by eight times of the
 *     multiplication factor selected by MULT.
 * - 100 - Counting uses the peripheral clock divided by 16 times of the
 *     multiplication factor selected by MULT.
 * - 101 - Counting uses the peripheral clock divided by 32 times of the
 *     multiplication factor selected by MULT.
 * - 110 - Counting uses the peripheral clock divided by 64 times of the
 *     multiplication factor selected by MULT.
 * - 111 - Counting uses the peripheral clock divided by 128 times of the
 *     multiplication factor selected by MULT.
 */
/*@{*/
#define BP_PDB_SC_PRESCALER  (12U)         /*!< Bit position for PDB_SC_PRESCALER. */
#define BM_PDB_SC_PRESCALER  (0x00007000U) /*!< Bit mask for PDB_SC_PRESCALER. */
#define BS_PDB_SC_PRESCALER  (3U)          /*!< Bit field size in bits for PDB_SC_PRESCALER. */

/*! @brief Read current value of the PDB_SC_PRESCALER field. */
#define BR_PDB_SC_PRESCALER(x) (HW_PDB_SC(x).B.PRESCALER)

/*! @brief Format value for bitfield PDB_SC_PRESCALER. */
#define BF_PDB_SC_PRESCALER(v) ((uint32_t)((uint32_t)(v) << BP_PDB_SC_PRESCALER) & BM_PDB_SC_PRESCALER)

/*! @brief Set the PRESCALER field to a new value. */
#define BW_PDB_SC_PRESCALER(x, v) (HW_PDB_SC_WR(x, (HW_PDB_SC_RD(x) & ~BM_PDB_SC_PRESCALER) | BF_PDB_SC_PRESCALER(v)))
/*@}*/

/*!
 * @name Register PDB_SC, field DMAEN[15] (RW)
 *
 * When DMA is enabled, the PDBIF flag generates a DMA request instead of an
 * interrupt.
 *
 * Values:
 * - 0 - DMA disabled.
 * - 1 - DMA enabled.
 */
/*@{*/
#define BP_PDB_SC_DMAEN      (15U)         /*!< Bit position for PDB_SC_DMAEN. */
#define BM_PDB_SC_DMAEN      (0x00008000U) /*!< Bit mask for PDB_SC_DMAEN. */
#define BS_PDB_SC_DMAEN      (1U)          /*!< Bit field size in bits for PDB_SC_DMAEN. */

/*! @brief Read current value of the PDB_SC_DMAEN field. */
#define BR_PDB_SC_DMAEN(x)   (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_DMAEN))

/*! @brief Format value for bitfield PDB_SC_DMAEN. */
#define BF_PDB_SC_DMAEN(v)   ((uint32_t)((uint32_t)(v) << BP_PDB_SC_DMAEN) & BM_PDB_SC_DMAEN)

/*! @brief Set the DMAEN field to a new value. */
#define BW_PDB_SC_DMAEN(x, v) (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_DMAEN) = (v))
/*@}*/

/*!
 * @name Register PDB_SC, field SWTRIG[16] (WORZ)
 *
 * When PDB is enabled and the software trigger is selected as the trigger input
 * source, writing 1 to this field resets and restarts the counter. Writing 0 to
 * this field has no effect. Reading this field results 0.
 */
/*@{*/
#define BP_PDB_SC_SWTRIG     (16U)         /*!< Bit position for PDB_SC_SWTRIG. */
#define BM_PDB_SC_SWTRIG     (0x00010000U) /*!< Bit mask for PDB_SC_SWTRIG. */
#define BS_PDB_SC_SWTRIG     (1U)          /*!< Bit field size in bits for PDB_SC_SWTRIG. */

/*! @brief Format value for bitfield PDB_SC_SWTRIG. */
#define BF_PDB_SC_SWTRIG(v)  ((uint32_t)((uint32_t)(v) << BP_PDB_SC_SWTRIG) & BM_PDB_SC_SWTRIG)

/*! @brief Set the SWTRIG field to a new value. */
#define BW_PDB_SC_SWTRIG(x, v) (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_SWTRIG) = (v))
/*@}*/

/*!
 * @name Register PDB_SC, field PDBEIE[17] (RW)
 *
 * Enables the PDB sequence error interrupt. When this field is set, any of the
 * PDB channel sequence error flags generates a PDB sequence error interrupt.
 *
 * Values:
 * - 0 - PDB sequence error interrupt disabled.
 * - 1 - PDB sequence error interrupt enabled.
 */
/*@{*/
#define BP_PDB_SC_PDBEIE     (17U)         /*!< Bit position for PDB_SC_PDBEIE. */
#define BM_PDB_SC_PDBEIE     (0x00020000U) /*!< Bit mask for PDB_SC_PDBEIE. */
#define BS_PDB_SC_PDBEIE     (1U)          /*!< Bit field size in bits for PDB_SC_PDBEIE. */

/*! @brief Read current value of the PDB_SC_PDBEIE field. */
#define BR_PDB_SC_PDBEIE(x)  (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_PDBEIE))

/*! @brief Format value for bitfield PDB_SC_PDBEIE. */
#define BF_PDB_SC_PDBEIE(v)  ((uint32_t)((uint32_t)(v) << BP_PDB_SC_PDBEIE) & BM_PDB_SC_PDBEIE)

/*! @brief Set the PDBEIE field to a new value. */
#define BW_PDB_SC_PDBEIE(x, v) (BITBAND_ACCESS32(HW_PDB_SC_ADDR(x), BP_PDB_SC_PDBEIE) = (v))
/*@}*/

/*!
 * @name Register PDB_SC, field LDMOD[19:18] (RW)
 *
 * Selects the mode to load the MOD, IDLY, CHnDLYm, INTx, and POyDLY registers,
 * after 1 is written to LDOK.
 *
 * Values:
 * - 00 - The internal registers are loaded with the values from their buffers
 *     immediately after 1 is written to LDOK.
 * - 01 - The internal registers are loaded with the values from their buffers
 *     when the PDB counter reaches the MOD register value after 1 is written to
 *     LDOK.
 * - 10 - The internal registers are loaded with the values from their buffers
 *     when a trigger input event is detected after 1 is written to LDOK.
 * - 11 - The internal registers are loaded with the values from their buffers
 *     when either the PDB counter reaches the MOD register value or a trigger
 *     input event is detected, after 1 is written to LDOK.
 */
/*@{*/
#define BP_PDB_SC_LDMOD      (18U)         /*!< Bit position for PDB_SC_LDMOD. */
#define BM_PDB_SC_LDMOD      (0x000C0000U) /*!< Bit mask for PDB_SC_LDMOD. */
#define BS_PDB_SC_LDMOD      (2U)          /*!< Bit field size in bits for PDB_SC_LDMOD. */

/*! @brief Read current value of the PDB_SC_LDMOD field. */
#define BR_PDB_SC_LDMOD(x)   (HW_PDB_SC(x).B.LDMOD)

/*! @brief Format value for bitfield PDB_SC_LDMOD. */
#define BF_PDB_SC_LDMOD(v)   ((uint32_t)((uint32_t)(v) << BP_PDB_SC_LDMOD) & BM_PDB_SC_LDMOD)

/*! @brief Set the LDMOD field to a new value. */
#define BW_PDB_SC_LDMOD(x, v) (HW_PDB_SC_WR(x, (HW_PDB_SC_RD(x) & ~BM_PDB_SC_LDMOD) | BF_PDB_SC_LDMOD(v)))
/*@}*/

/*******************************************************************************
 * HW_PDB_MOD - Modulus register
 ******************************************************************************/

/*!
 * @brief HW_PDB_MOD - Modulus register (RW)
 *
 * Reset value: 0x0000FFFFU
 */
typedef union _hw_pdb_mod
{
    uint32_t U;
    struct _hw_pdb_mod_bitfields
    {
        uint32_t MOD : 16;             /*!< [15:0] PDB Modulus */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_pdb_mod_t;

/*!
 * @name Constants and macros for entire PDB_MOD register
 */
/*@{*/
#define HW_PDB_MOD_ADDR(x)       ((x) + 0x4U)

#define HW_PDB_MOD(x)            (*(__IO hw_pdb_mod_t *) HW_PDB_MOD_ADDR(x))
#define HW_PDB_MOD_RD(x)         (HW_PDB_MOD(x).U)
#define HW_PDB_MOD_WR(x, v)      (HW_PDB_MOD(x).U = (v))
#define HW_PDB_MOD_SET(x, v)     (HW_PDB_MOD_WR(x, HW_PDB_MOD_RD(x) |  (v)))
#define HW_PDB_MOD_CLR(x, v)     (HW_PDB_MOD_WR(x, HW_PDB_MOD_RD(x) & ~(v)))
#define HW_PDB_MOD_TOG(x, v)     (HW_PDB_MOD_WR(x, HW_PDB_MOD_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual PDB_MOD bitfields
 */

/*!
 * @name Register PDB_MOD, field MOD[15:0] (RW)
 *
 * Specifies the period of the counter. When the counter reaches this value, it
 * will be reset back to zero. If the PDB is in Continuous mode, the count begins
 * anew. Reading this field returns the value of the internal register that is
 * effective for the current cycle of PDB.
 */
/*@{*/
#define BP_PDB_MOD_MOD       (0U)          /*!< Bit position for PDB_MOD_MOD. */
#define BM_PDB_MOD_MOD       (0x0000FFFFU) /*!< Bit mask for PDB_MOD_MOD. */
#define BS_PDB_MOD_MOD       (16U)         /*!< Bit field size in bits for PDB_MOD_MOD. */

/*! @brief Read current value of the PDB_MOD_MOD field. */
#define BR_PDB_MOD_MOD(x)    (HW_PDB_MOD(x).B.MOD)

/*! @brief Format value for bitfield PDB_MOD_MOD. */
#define BF_PDB_MOD_MOD(v)    ((uint32_t)((uint32_t)(v) << BP_PDB_MOD_MOD) & BM_PDB_MOD_MOD)

/*! @brief Set the MOD field to a new value. */
#define BW_PDB_MOD_MOD(x, v) (HW_PDB_MOD_WR(x, (HW_PDB_MOD_RD(x) & ~BM_PDB_MOD_MOD) | BF_PDB_MOD_MOD(v)))
/*@}*/

/*******************************************************************************
 * HW_PDB_CNT - Counter register
 ******************************************************************************/

/*!
 * @brief HW_PDB_CNT - Counter register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_cnt
{
    uint32_t U;
    struct _hw_pdb_cnt_bitfields
    {
        uint32_t CNT : 16;             /*!< [15:0] PDB Counter */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_pdb_cnt_t;

/*!
 * @name Constants and macros for entire PDB_CNT register
 */
/*@{*/
#define HW_PDB_CNT_ADDR(x)       ((x) + 0x8U)

#define HW_PDB_CNT(x)            (*(__I hw_pdb_cnt_t *) HW_PDB_CNT_ADDR(x))
#define HW_PDB_CNT_RD(x)         (HW_PDB_CNT(x).U)
/*@}*/

/*
 * Constants & macros for individual PDB_CNT bitfields
 */

/*!
 * @name Register PDB_CNT, field CNT[15:0] (RO)
 *
 * Contains the current value of the counter.
 */
/*@{*/
#define BP_PDB_CNT_CNT       (0U)          /*!< Bit position for PDB_CNT_CNT. */
#define BM_PDB_CNT_CNT       (0x0000FFFFU) /*!< Bit mask for PDB_CNT_CNT. */
#define BS_PDB_CNT_CNT       (16U)         /*!< Bit field size in bits for PDB_CNT_CNT. */

/*! @brief Read current value of the PDB_CNT_CNT field. */
#define BR_PDB_CNT_CNT(x)    (HW_PDB_CNT(x).B.CNT)
/*@}*/

/*******************************************************************************
 * HW_PDB_IDLY - Interrupt Delay register
 ******************************************************************************/

/*!
 * @brief HW_PDB_IDLY - Interrupt Delay register (RW)
 *
 * Reset value: 0x0000FFFFU
 */
typedef union _hw_pdb_idly
{
    uint32_t U;
    struct _hw_pdb_idly_bitfields
    {
        uint32_t IDLY : 16;            /*!< [15:0] PDB Interrupt Delay */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_pdb_idly_t;

/*!
 * @name Constants and macros for entire PDB_IDLY register
 */
/*@{*/
#define HW_PDB_IDLY_ADDR(x)      ((x) + 0xCU)

#define HW_PDB_IDLY(x)           (*(__IO hw_pdb_idly_t *) HW_PDB_IDLY_ADDR(x))
#define HW_PDB_IDLY_RD(x)        (HW_PDB_IDLY(x).U)
#define HW_PDB_IDLY_WR(x, v)     (HW_PDB_IDLY(x).U = (v))
#define HW_PDB_IDLY_SET(x, v)    (HW_PDB_IDLY_WR(x, HW_PDB_IDLY_RD(x) |  (v)))
#define HW_PDB_IDLY_CLR(x, v)    (HW_PDB_IDLY_WR(x, HW_PDB_IDLY_RD(x) & ~(v)))
#define HW_PDB_IDLY_TOG(x, v)    (HW_PDB_IDLY_WR(x, HW_PDB_IDLY_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual PDB_IDLY bitfields
 */

/*!
 * @name Register PDB_IDLY, field IDLY[15:0] (RW)
 *
 * Specifies the delay value to schedule the PDB interrupt. It can be used to
 * schedule an independent interrupt at some point in the PDB cycle. If enabled, a
 * PDB interrupt is generated, when the counter is equal to the IDLY. Reading
 * this field returns the value of internal register that is effective for the
 * current cycle of the PDB.
 */
/*@{*/
#define BP_PDB_IDLY_IDLY     (0U)          /*!< Bit position for PDB_IDLY_IDLY. */
#define BM_PDB_IDLY_IDLY     (0x0000FFFFU) /*!< Bit mask for PDB_IDLY_IDLY. */
#define BS_PDB_IDLY_IDLY     (16U)         /*!< Bit field size in bits for PDB_IDLY_IDLY. */

/*! @brief Read current value of the PDB_IDLY_IDLY field. */
#define BR_PDB_IDLY_IDLY(x)  (HW_PDB_IDLY(x).B.IDLY)

/*! @brief Format value for bitfield PDB_IDLY_IDLY. */
#define BF_PDB_IDLY_IDLY(v)  ((uint32_t)((uint32_t)(v) << BP_PDB_IDLY_IDLY) & BM_PDB_IDLY_IDLY)

/*! @brief Set the IDLY field to a new value. */
#define BW_PDB_IDLY_IDLY(x, v) (HW_PDB_IDLY_WR(x, (HW_PDB_IDLY_RD(x) & ~BM_PDB_IDLY_IDLY) | BF_PDB_IDLY_IDLY(v)))
/*@}*/

/*******************************************************************************
 * HW_PDB_CHnC1 - Channel n Control register 1
 ******************************************************************************/

/*!
 * @brief HW_PDB_CHnC1 - Channel n Control register 1 (RW)
 *
 * Reset value: 0x00000000U
 *
 * Each PDB channel has one control register, CHnC1. The bits in this register
 * control the functionality of each PDB channel operation.
 */
typedef union _hw_pdb_chnc1
{
    uint32_t U;
    struct _hw_pdb_chnc1_bitfields
    {
        uint32_t EN : 8;               /*!< [7:0] PDB Channel Pre-Trigger Enable */
        uint32_t TOS : 8;              /*!< [15:8] PDB Channel Pre-Trigger Output Select */
        uint32_t BB : 8;               /*!< [23:16] PDB Channel Pre-Trigger Back-to-Back
                                        * Operation Enable */
        uint32_t RESERVED0 : 8;        /*!< [31:24]  */
    } B;
} hw_pdb_chnc1_t;

/*!
 * @name Constants and macros for entire PDB_CHnC1 register
 */
/*@{*/
#define HW_PDB_CHnC1_COUNT (2U)

#define HW_PDB_CHnC1_ADDR(x, n)  ((x) + 0x10U + (0x28U * (n)))

#define HW_PDB_CHnC1(x, n)       (*(__IO hw_pdb_chnc1_t *) HW_PDB_CHnC1_ADDR(x, n))
#define HW_PDB_CHnC1_RD(x, n)    (HW_PDB_CHnC1(x, n).U)
#define HW_PDB_CHnC1_WR(x, n, v) (HW_PDB_CHnC1(x, n).U = (v))
#define HW_PDB_CHnC1_SET(x, n, v) (HW_PDB_CHnC1_WR(x, n, HW_PDB_CHnC1_RD(x, n) |  (v)))
#define HW_PDB_CHnC1_CLR(x, n, v) (HW_PDB_CHnC1_WR(x, n, HW_PDB_CHnC1_RD(x, n) & ~(v)))
#define HW_PDB_CHnC1_TOG(x, n, v) (HW_PDB_CHnC1_WR(x, n, HW_PDB_CHnC1_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual PDB_CHnC1 bitfields
 */

/*!
 * @name Register PDB_CHnC1, field EN[7:0] (RW)
 *
 * These bits enable the PDB ADC pre-trigger outputs. Only lower M pre-trigger
 * bits are implemented in this MCU.
 *
 * Values:
 * - 0 - PDB channel's corresponding pre-trigger disabled.
 * - 1 - PDB channel's corresponding pre-trigger enabled.
 */
/*@{*/
#define BP_PDB_CHnC1_EN      (0U)          /*!< Bit position for PDB_CHnC1_EN. */
#define BM_PDB_CHnC1_EN      (0x000000FFU) /*!< Bit mask for PDB_CHnC1_EN. */
#define BS_PDB_CHnC1_EN      (8U)          /*!< Bit field size in bits for PDB_CHnC1_EN. */

/*! @brief Read current value of the PDB_CHnC1_EN field. */
#define BR_PDB_CHnC1_EN(x, n) (HW_PDB_CHnC1(x, n).B.EN)

/*! @brief Format value for bitfield PDB_CHnC1_EN. */
#define BF_PDB_CHnC1_EN(v)   ((uint32_t)((uint32_t)(v) << BP_PDB_CHnC1_EN) & BM_PDB_CHnC1_EN)

/*! @brief Set the EN field to a new value. */
#define BW_PDB_CHnC1_EN(x, n, v) (HW_PDB_CHnC1_WR(x, n, (HW_PDB_CHnC1_RD(x, n) & ~BM_PDB_CHnC1_EN) | BF_PDB_CHnC1_EN(v)))
/*@}*/

/*!
 * @name Register PDB_CHnC1, field TOS[15:8] (RW)
 *
 * Selects the PDB ADC pre-trigger outputs. Only lower M pre-trigger fields are
 * implemented in this MCU.
 *
 * Values:
 * - 0 - PDB channel's corresponding pre-trigger is in bypassed mode. The
 *     pre-trigger asserts one peripheral clock cycle after a rising edge is detected
 *     on selected trigger input source or software trigger is selected and SWTRIG
 *     is written with 1.
 * - 1 - PDB channel's corresponding pre-trigger asserts when the counter
 *     reaches the channel delay register and one peripheral clock cycle after a rising
 *     edge is detected on selected trigger input source or software trigger is
 *     selected and SETRIG is written with 1.
 */
/*@{*/
#define BP_PDB_CHnC1_TOS     (8U)          /*!< Bit position for PDB_CHnC1_TOS. */
#define BM_PDB_CHnC1_TOS     (0x0000FF00U) /*!< Bit mask for PDB_CHnC1_TOS. */
#define BS_PDB_CHnC1_TOS     (8U)          /*!< Bit field size in bits for PDB_CHnC1_TOS. */

/*! @brief Read current value of the PDB_CHnC1_TOS field. */
#define BR_PDB_CHnC1_TOS(x, n) (HW_PDB_CHnC1(x, n).B.TOS)

/*! @brief Format value for bitfield PDB_CHnC1_TOS. */
#define BF_PDB_CHnC1_TOS(v)  ((uint32_t)((uint32_t)(v) << BP_PDB_CHnC1_TOS) & BM_PDB_CHnC1_TOS)

/*! @brief Set the TOS field to a new value. */
#define BW_PDB_CHnC1_TOS(x, n, v) (HW_PDB_CHnC1_WR(x, n, (HW_PDB_CHnC1_RD(x, n) & ~BM_PDB_CHnC1_TOS) | BF_PDB_CHnC1_TOS(v)))
/*@}*/

/*!
 * @name Register PDB_CHnC1, field BB[23:16] (RW)
 *
 * These bits enable the PDB ADC pre-trigger operation as back-to-back mode.
 * Only lower M pre-trigger bits are implemented in this MCU. Back-to-back operation
 * enables the ADC conversions complete to trigger the next PDB channel
 * pre-trigger and trigger output, so that the ADC conversions can be triggered on next
 * set of configuration and results registers. Application code must only enable
 * the back-to-back operation of the PDB pre-triggers at the leading of the
 * back-to-back connection chain.
 *
 * Values:
 * - 0 - PDB channel's corresponding pre-trigger back-to-back operation disabled.
 * - 1 - PDB channel's corresponding pre-trigger back-to-back operation enabled.
 */
/*@{*/
#define BP_PDB_CHnC1_BB      (16U)         /*!< Bit position for PDB_CHnC1_BB. */
#define BM_PDB_CHnC1_BB      (0x00FF0000U) /*!< Bit mask for PDB_CHnC1_BB. */
#define BS_PDB_CHnC1_BB      (8U)          /*!< Bit field size in bits for PDB_CHnC1_BB. */

/*! @brief Read current value of the PDB_CHnC1_BB field. */
#define BR_PDB_CHnC1_BB(x, n) (HW_PDB_CHnC1(x, n).B.BB)

/*! @brief Format value for bitfield PDB_CHnC1_BB. */
#define BF_PDB_CHnC1_BB(v)   ((uint32_t)((uint32_t)(v) << BP_PDB_CHnC1_BB) & BM_PDB_CHnC1_BB)

/*! @brief Set the BB field to a new value. */
#define BW_PDB_CHnC1_BB(x, n, v) (HW_PDB_CHnC1_WR(x, n, (HW_PDB_CHnC1_RD(x, n) & ~BM_PDB_CHnC1_BB) | BF_PDB_CHnC1_BB(v)))
/*@}*/
/*******************************************************************************
 * HW_PDB_CHnS - Channel n Status register
 ******************************************************************************/

/*!
 * @brief HW_PDB_CHnS - Channel n Status register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_chns
{
    uint32_t U;
    struct _hw_pdb_chns_bitfields
    {
        uint32_t ERR : 8;              /*!< [7:0] PDB Channel Sequence Error Flags */
        uint32_t RESERVED0 : 8;        /*!< [15:8]  */
        uint32_t CF : 8;               /*!< [23:16] PDB Channel Flags */
        uint32_t RESERVED1 : 8;        /*!< [31:24]  */
    } B;
} hw_pdb_chns_t;

/*!
 * @name Constants and macros for entire PDB_CHnS register
 */
/*@{*/
#define HW_PDB_CHnS_COUNT (2U)

#define HW_PDB_CHnS_ADDR(x, n)   ((x) + 0x14U + (0x28U * (n)))

#define HW_PDB_CHnS(x, n)        (*(__IO hw_pdb_chns_t *) HW_PDB_CHnS_ADDR(x, n))
#define HW_PDB_CHnS_RD(x, n)     (HW_PDB_CHnS(x, n).U)
#define HW_PDB_CHnS_WR(x, n, v)  (HW_PDB_CHnS(x, n).U = (v))
#define HW_PDB_CHnS_SET(x, n, v) (HW_PDB_CHnS_WR(x, n, HW_PDB_CHnS_RD(x, n) |  (v)))
#define HW_PDB_CHnS_CLR(x, n, v) (HW_PDB_CHnS_WR(x, n, HW_PDB_CHnS_RD(x, n) & ~(v)))
#define HW_PDB_CHnS_TOG(x, n, v) (HW_PDB_CHnS_WR(x, n, HW_PDB_CHnS_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual PDB_CHnS bitfields
 */

/*!
 * @name Register PDB_CHnS, field ERR[7:0] (RW)
 *
 * Only the lower M bits are implemented in this MCU.
 *
 * Values:
 * - 0 - Sequence error not detected on PDB channel's corresponding pre-trigger.
 * - 1 - Sequence error detected on PDB channel's corresponding pre-trigger.
 *     ADCn block can be triggered for a conversion by one pre-trigger from PDB
 *     channel n. When one conversion, which is triggered by one of the pre-triggers
 *     from PDB channel n, is in progress, new trigger from PDB channel's
 *     corresponding pre-trigger m cannot be accepted by ADCn, and ERR[m] is set.
 *     Writing 0's to clear the sequence error flags.
 */
/*@{*/
#define BP_PDB_CHnS_ERR      (0U)          /*!< Bit position for PDB_CHnS_ERR. */
#define BM_PDB_CHnS_ERR      (0x000000FFU) /*!< Bit mask for PDB_CHnS_ERR. */
#define BS_PDB_CHnS_ERR      (8U)          /*!< Bit field size in bits for PDB_CHnS_ERR. */

/*! @brief Read current value of the PDB_CHnS_ERR field. */
#define BR_PDB_CHnS_ERR(x, n) (HW_PDB_CHnS(x, n).B.ERR)

/*! @brief Format value for bitfield PDB_CHnS_ERR. */
#define BF_PDB_CHnS_ERR(v)   ((uint32_t)((uint32_t)(v) << BP_PDB_CHnS_ERR) & BM_PDB_CHnS_ERR)

/*! @brief Set the ERR field to a new value. */
#define BW_PDB_CHnS_ERR(x, n, v) (HW_PDB_CHnS_WR(x, n, (HW_PDB_CHnS_RD(x, n) & ~BM_PDB_CHnS_ERR) | BF_PDB_CHnS_ERR(v)))
/*@}*/

/*!
 * @name Register PDB_CHnS, field CF[23:16] (RW)
 *
 * The CF[m] bit is set when the PDB counter matches the CHnDLYm. Write 0 to
 * clear these bits.
 */
/*@{*/
#define BP_PDB_CHnS_CF       (16U)         /*!< Bit position for PDB_CHnS_CF. */
#define BM_PDB_CHnS_CF       (0x00FF0000U) /*!< Bit mask for PDB_CHnS_CF. */
#define BS_PDB_CHnS_CF       (8U)          /*!< Bit field size in bits for PDB_CHnS_CF. */

/*! @brief Read current value of the PDB_CHnS_CF field. */
#define BR_PDB_CHnS_CF(x, n) (HW_PDB_CHnS(x, n).B.CF)

/*! @brief Format value for bitfield PDB_CHnS_CF. */
#define BF_PDB_CHnS_CF(v)    ((uint32_t)((uint32_t)(v) << BP_PDB_CHnS_CF) & BM_PDB_CHnS_CF)

/*! @brief Set the CF field to a new value. */
#define BW_PDB_CHnS_CF(x, n, v) (HW_PDB_CHnS_WR(x, n, (HW_PDB_CHnS_RD(x, n) & ~BM_PDB_CHnS_CF) | BF_PDB_CHnS_CF(v)))
/*@}*/
/*******************************************************************************
 * HW_PDB_CHnDLY0 - Channel n Delay 0 register
 ******************************************************************************/

/*!
 * @brief HW_PDB_CHnDLY0 - Channel n Delay 0 register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_chndly0
{
    uint32_t U;
    struct _hw_pdb_chndly0_bitfields
    {
        uint32_t DLY : 16;             /*!< [15:0] PDB Channel Delay */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_pdb_chndly0_t;

/*!
 * @name Constants and macros for entire PDB_CHnDLY0 register
 */
/*@{*/
#define HW_PDB_CHnDLY0_COUNT (2U)

#define HW_PDB_CHnDLY0_ADDR(x, n) ((x) + 0x18U + (0x28U * (n)))

#define HW_PDB_CHnDLY0(x, n)     (*(__IO hw_pdb_chndly0_t *) HW_PDB_CHnDLY0_ADDR(x, n))
#define HW_PDB_CHnDLY0_RD(x, n)  (HW_PDB_CHnDLY0(x, n).U)
#define HW_PDB_CHnDLY0_WR(x, n, v) (HW_PDB_CHnDLY0(x, n).U = (v))
#define HW_PDB_CHnDLY0_SET(x, n, v) (HW_PDB_CHnDLY0_WR(x, n, HW_PDB_CHnDLY0_RD(x, n) |  (v)))
#define HW_PDB_CHnDLY0_CLR(x, n, v) (HW_PDB_CHnDLY0_WR(x, n, HW_PDB_CHnDLY0_RD(x, n) & ~(v)))
#define HW_PDB_CHnDLY0_TOG(x, n, v) (HW_PDB_CHnDLY0_WR(x, n, HW_PDB_CHnDLY0_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual PDB_CHnDLY0 bitfields
 */

/*!
 * @name Register PDB_CHnDLY0, field DLY[15:0] (RW)
 *
 * Specifies the delay value for the channel's corresponding pre-trigger. The
 * pre-trigger asserts when the counter is equal to DLY. Reading this field returns
 * the value of internal register that is effective for the current PDB cycle.
 */
/*@{*/
#define BP_PDB_CHnDLY0_DLY   (0U)          /*!< Bit position for PDB_CHnDLY0_DLY. */
#define BM_PDB_CHnDLY0_DLY   (0x0000FFFFU) /*!< Bit mask for PDB_CHnDLY0_DLY. */
#define BS_PDB_CHnDLY0_DLY   (16U)         /*!< Bit field size in bits for PDB_CHnDLY0_DLY. */

/*! @brief Read current value of the PDB_CHnDLY0_DLY field. */
#define BR_PDB_CHnDLY0_DLY(x, n) (HW_PDB_CHnDLY0(x, n).B.DLY)

/*! @brief Format value for bitfield PDB_CHnDLY0_DLY. */
#define BF_PDB_CHnDLY0_DLY(v) ((uint32_t)((uint32_t)(v) << BP_PDB_CHnDLY0_DLY) & BM_PDB_CHnDLY0_DLY)

/*! @brief Set the DLY field to a new value. */
#define BW_PDB_CHnDLY0_DLY(x, n, v) (HW_PDB_CHnDLY0_WR(x, n, (HW_PDB_CHnDLY0_RD(x, n) & ~BM_PDB_CHnDLY0_DLY) | BF_PDB_CHnDLY0_DLY(v)))
/*@}*/
/*******************************************************************************
 * HW_PDB_CHnDLY1 - Channel n Delay 1 register
 ******************************************************************************/

/*!
 * @brief HW_PDB_CHnDLY1 - Channel n Delay 1 register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_chndly1
{
    uint32_t U;
    struct _hw_pdb_chndly1_bitfields
    {
        uint32_t DLY : 16;             /*!< [15:0] PDB Channel Delay */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_pdb_chndly1_t;

/*!
 * @name Constants and macros for entire PDB_CHnDLY1 register
 */
/*@{*/
#define HW_PDB_CHnDLY1_COUNT (2U)

#define HW_PDB_CHnDLY1_ADDR(x, n) ((x) + 0x1CU + (0x28U * (n)))

#define HW_PDB_CHnDLY1(x, n)     (*(__IO hw_pdb_chndly1_t *) HW_PDB_CHnDLY1_ADDR(x, n))
#define HW_PDB_CHnDLY1_RD(x, n)  (HW_PDB_CHnDLY1(x, n).U)
#define HW_PDB_CHnDLY1_WR(x, n, v) (HW_PDB_CHnDLY1(x, n).U = (v))
#define HW_PDB_CHnDLY1_SET(x, n, v) (HW_PDB_CHnDLY1_WR(x, n, HW_PDB_CHnDLY1_RD(x, n) |  (v)))
#define HW_PDB_CHnDLY1_CLR(x, n, v) (HW_PDB_CHnDLY1_WR(x, n, HW_PDB_CHnDLY1_RD(x, n) & ~(v)))
#define HW_PDB_CHnDLY1_TOG(x, n, v) (HW_PDB_CHnDLY1_WR(x, n, HW_PDB_CHnDLY1_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual PDB_CHnDLY1 bitfields
 */

/*!
 * @name Register PDB_CHnDLY1, field DLY[15:0] (RW)
 *
 * These bits specify the delay value for the channel's corresponding
 * pre-trigger. The pre-trigger asserts when the counter is equal to DLY. Reading these
 * bits returns the value of internal register that is effective for the current PDB
 * cycle.
 */
/*@{*/
#define BP_PDB_CHnDLY1_DLY   (0U)          /*!< Bit position for PDB_CHnDLY1_DLY. */
#define BM_PDB_CHnDLY1_DLY   (0x0000FFFFU) /*!< Bit mask for PDB_CHnDLY1_DLY. */
#define BS_PDB_CHnDLY1_DLY   (16U)         /*!< Bit field size in bits for PDB_CHnDLY1_DLY. */

/*! @brief Read current value of the PDB_CHnDLY1_DLY field. */
#define BR_PDB_CHnDLY1_DLY(x, n) (HW_PDB_CHnDLY1(x, n).B.DLY)

/*! @brief Format value for bitfield PDB_CHnDLY1_DLY. */
#define BF_PDB_CHnDLY1_DLY(v) ((uint32_t)((uint32_t)(v) << BP_PDB_CHnDLY1_DLY) & BM_PDB_CHnDLY1_DLY)

/*! @brief Set the DLY field to a new value. */
#define BW_PDB_CHnDLY1_DLY(x, n, v) (HW_PDB_CHnDLY1_WR(x, n, (HW_PDB_CHnDLY1_RD(x, n) & ~BM_PDB_CHnDLY1_DLY) | BF_PDB_CHnDLY1_DLY(v)))
/*@}*/

/*******************************************************************************
 * HW_PDB_DACINTCn - DAC Interval Trigger n Control register
 ******************************************************************************/

/*!
 * @brief HW_PDB_DACINTCn - DAC Interval Trigger n Control register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_dacintcn
{
    uint32_t U;
    struct _hw_pdb_dacintcn_bitfields
    {
        uint32_t TOE : 1;              /*!< [0] DAC Interval Trigger Enable */
        uint32_t EXT : 1;              /*!< [1] DAC External Trigger Input Enable */
        uint32_t RESERVED0 : 30;       /*!< [31:2]  */
    } B;
} hw_pdb_dacintcn_t;

/*!
 * @name Constants and macros for entire PDB_DACINTCn register
 */
/*@{*/
#define HW_PDB_DACINTCn_COUNT (2U)

#define HW_PDB_DACINTCn_ADDR(x, n) ((x) + 0x150U + (0x8U * (n)))

#define HW_PDB_DACINTCn(x, n)    (*(__IO hw_pdb_dacintcn_t *) HW_PDB_DACINTCn_ADDR(x, n))
#define HW_PDB_DACINTCn_RD(x, n) (HW_PDB_DACINTCn(x, n).U)
#define HW_PDB_DACINTCn_WR(x, n, v) (HW_PDB_DACINTCn(x, n).U = (v))
#define HW_PDB_DACINTCn_SET(x, n, v) (HW_PDB_DACINTCn_WR(x, n, HW_PDB_DACINTCn_RD(x, n) |  (v)))
#define HW_PDB_DACINTCn_CLR(x, n, v) (HW_PDB_DACINTCn_WR(x, n, HW_PDB_DACINTCn_RD(x, n) & ~(v)))
#define HW_PDB_DACINTCn_TOG(x, n, v) (HW_PDB_DACINTCn_WR(x, n, HW_PDB_DACINTCn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual PDB_DACINTCn bitfields
 */

/*!
 * @name Register PDB_DACINTCn, field TOE[0] (RW)
 *
 * This bit enables the DAC interval trigger.
 *
 * Values:
 * - 0 - DAC interval trigger disabled.
 * - 1 - DAC interval trigger enabled.
 */
/*@{*/
#define BP_PDB_DACINTCn_TOE  (0U)          /*!< Bit position for PDB_DACINTCn_TOE. */
#define BM_PDB_DACINTCn_TOE  (0x00000001U) /*!< Bit mask for PDB_DACINTCn_TOE. */
#define BS_PDB_DACINTCn_TOE  (1U)          /*!< Bit field size in bits for PDB_DACINTCn_TOE. */

/*! @brief Read current value of the PDB_DACINTCn_TOE field. */
#define BR_PDB_DACINTCn_TOE(x, n) (BITBAND_ACCESS32(HW_PDB_DACINTCn_ADDR(x, n), BP_PDB_DACINTCn_TOE))

/*! @brief Format value for bitfield PDB_DACINTCn_TOE. */
#define BF_PDB_DACINTCn_TOE(v) ((uint32_t)((uint32_t)(v) << BP_PDB_DACINTCn_TOE) & BM_PDB_DACINTCn_TOE)

/*! @brief Set the TOE field to a new value. */
#define BW_PDB_DACINTCn_TOE(x, n, v) (BITBAND_ACCESS32(HW_PDB_DACINTCn_ADDR(x, n), BP_PDB_DACINTCn_TOE) = (v))
/*@}*/

/*!
 * @name Register PDB_DACINTCn, field EXT[1] (RW)
 *
 * Enables the external trigger for DAC interval counter.
 *
 * Values:
 * - 0 - DAC external trigger input disabled. DAC interval counter is reset and
 *     counting starts when a rising edge is detected on selected trigger input
 *     source or software trigger is selected and SWTRIG is written with 1.
 * - 1 - DAC external trigger input enabled. DAC interval counter is bypassed
 *     and DAC external trigger input triggers the DAC interval trigger.
 */
/*@{*/
#define BP_PDB_DACINTCn_EXT  (1U)          /*!< Bit position for PDB_DACINTCn_EXT. */
#define BM_PDB_DACINTCn_EXT  (0x00000002U) /*!< Bit mask for PDB_DACINTCn_EXT. */
#define BS_PDB_DACINTCn_EXT  (1U)          /*!< Bit field size in bits for PDB_DACINTCn_EXT. */

/*! @brief Read current value of the PDB_DACINTCn_EXT field. */
#define BR_PDB_DACINTCn_EXT(x, n) (BITBAND_ACCESS32(HW_PDB_DACINTCn_ADDR(x, n), BP_PDB_DACINTCn_EXT))

/*! @brief Format value for bitfield PDB_DACINTCn_EXT. */
#define BF_PDB_DACINTCn_EXT(v) ((uint32_t)((uint32_t)(v) << BP_PDB_DACINTCn_EXT) & BM_PDB_DACINTCn_EXT)

/*! @brief Set the EXT field to a new value. */
#define BW_PDB_DACINTCn_EXT(x, n, v) (BITBAND_ACCESS32(HW_PDB_DACINTCn_ADDR(x, n), BP_PDB_DACINTCn_EXT) = (v))
/*@}*/
/*******************************************************************************
 * HW_PDB_DACINTn - DAC Interval n register
 ******************************************************************************/

/*!
 * @brief HW_PDB_DACINTn - DAC Interval n register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_dacintn
{
    uint32_t U;
    struct _hw_pdb_dacintn_bitfields
    {
        uint32_t INT : 16;             /*!< [15:0] DAC Interval */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_pdb_dacintn_t;

/*!
 * @name Constants and macros for entire PDB_DACINTn register
 */
/*@{*/
#define HW_PDB_DACINTn_COUNT (2U)

#define HW_PDB_DACINTn_ADDR(x, n) ((x) + 0x154U + (0x8U * (n)))

#define HW_PDB_DACINTn(x, n)     (*(__IO hw_pdb_dacintn_t *) HW_PDB_DACINTn_ADDR(x, n))
#define HW_PDB_DACINTn_RD(x, n)  (HW_PDB_DACINTn(x, n).U)
#define HW_PDB_DACINTn_WR(x, n, v) (HW_PDB_DACINTn(x, n).U = (v))
#define HW_PDB_DACINTn_SET(x, n, v) (HW_PDB_DACINTn_WR(x, n, HW_PDB_DACINTn_RD(x, n) |  (v)))
#define HW_PDB_DACINTn_CLR(x, n, v) (HW_PDB_DACINTn_WR(x, n, HW_PDB_DACINTn_RD(x, n) & ~(v)))
#define HW_PDB_DACINTn_TOG(x, n, v) (HW_PDB_DACINTn_WR(x, n, HW_PDB_DACINTn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual PDB_DACINTn bitfields
 */

/*!
 * @name Register PDB_DACINTn, field INT[15:0] (RW)
 *
 * Specifies the interval value for DAC interval trigger. DAC interval trigger
 * triggers DAC[1:0] update when the DAC interval counter is equal to the DACINT.
 * Reading this field returns the value of internal register that is effective
 * for the current PDB cycle.
 */
/*@{*/
#define BP_PDB_DACINTn_INT   (0U)          /*!< Bit position for PDB_DACINTn_INT. */
#define BM_PDB_DACINTn_INT   (0x0000FFFFU) /*!< Bit mask for PDB_DACINTn_INT. */
#define BS_PDB_DACINTn_INT   (16U)         /*!< Bit field size in bits for PDB_DACINTn_INT. */

/*! @brief Read current value of the PDB_DACINTn_INT field. */
#define BR_PDB_DACINTn_INT(x, n) (HW_PDB_DACINTn(x, n).B.INT)

/*! @brief Format value for bitfield PDB_DACINTn_INT. */
#define BF_PDB_DACINTn_INT(v) ((uint32_t)((uint32_t)(v) << BP_PDB_DACINTn_INT) & BM_PDB_DACINTn_INT)

/*! @brief Set the INT field to a new value. */
#define BW_PDB_DACINTn_INT(x, n, v) (HW_PDB_DACINTn_WR(x, n, (HW_PDB_DACINTn_RD(x, n) & ~BM_PDB_DACINTn_INT) | BF_PDB_DACINTn_INT(v)))
/*@}*/

/*******************************************************************************
 * HW_PDB_POEN - Pulse-Out n Enable register
 ******************************************************************************/

/*!
 * @brief HW_PDB_POEN - Pulse-Out n Enable register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_poen
{
    uint32_t U;
    struct _hw_pdb_poen_bitfields
    {
        uint32_t POEN : 8;             /*!< [7:0] PDB Pulse-Out Enable */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_pdb_poen_t;

/*!
 * @name Constants and macros for entire PDB_POEN register
 */
/*@{*/
#define HW_PDB_POEN_ADDR(x)      ((x) + 0x190U)

#define HW_PDB_POEN(x)           (*(__IO hw_pdb_poen_t *) HW_PDB_POEN_ADDR(x))
#define HW_PDB_POEN_RD(x)        (HW_PDB_POEN(x).U)
#define HW_PDB_POEN_WR(x, v)     (HW_PDB_POEN(x).U = (v))
#define HW_PDB_POEN_SET(x, v)    (HW_PDB_POEN_WR(x, HW_PDB_POEN_RD(x) |  (v)))
#define HW_PDB_POEN_CLR(x, v)    (HW_PDB_POEN_WR(x, HW_PDB_POEN_RD(x) & ~(v)))
#define HW_PDB_POEN_TOG(x, v)    (HW_PDB_POEN_WR(x, HW_PDB_POEN_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual PDB_POEN bitfields
 */

/*!
 * @name Register PDB_POEN, field POEN[7:0] (RW)
 *
 * Enables the pulse output. Only lower Y bits are implemented in this MCU.
 *
 * Values:
 * - 0 - PDB Pulse-Out disabled
 * - 1 - PDB Pulse-Out enabled
 */
/*@{*/
#define BP_PDB_POEN_POEN     (0U)          /*!< Bit position for PDB_POEN_POEN. */
#define BM_PDB_POEN_POEN     (0x000000FFU) /*!< Bit mask for PDB_POEN_POEN. */
#define BS_PDB_POEN_POEN     (8U)          /*!< Bit field size in bits for PDB_POEN_POEN. */

/*! @brief Read current value of the PDB_POEN_POEN field. */
#define BR_PDB_POEN_POEN(x)  (HW_PDB_POEN(x).B.POEN)

/*! @brief Format value for bitfield PDB_POEN_POEN. */
#define BF_PDB_POEN_POEN(v)  ((uint32_t)((uint32_t)(v) << BP_PDB_POEN_POEN) & BM_PDB_POEN_POEN)

/*! @brief Set the POEN field to a new value. */
#define BW_PDB_POEN_POEN(x, v) (HW_PDB_POEN_WR(x, (HW_PDB_POEN_RD(x) & ~BM_PDB_POEN_POEN) | BF_PDB_POEN_POEN(v)))
/*@}*/

/*******************************************************************************
 * HW_PDB_POnDLY - Pulse-Out n Delay register
 ******************************************************************************/

/*!
 * @brief HW_PDB_POnDLY - Pulse-Out n Delay register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_pondly
{
    uint32_t U;
    struct _hw_pdb_pondly_bitfields
    {
        uint32_t DLY2 : 16;            /*!< [15:0] PDB Pulse-Out Delay 2 */
        uint32_t DLY1 : 16;            /*!< [31:16] PDB Pulse-Out Delay 1 */
    } B;
} hw_pdb_pondly_t;

/*!
 * @name Constants and macros for entire PDB_POnDLY register
 */
/*@{*/
#define HW_PDB_POnDLY_COUNT (3U)

#define HW_PDB_POnDLY_ADDR(x, n) ((x) + 0x194U + (0x4U * (n)))

#define HW_PDB_POnDLY(x, n)      (*(__IO hw_pdb_pondly_t *) HW_PDB_POnDLY_ADDR(x, n))
#define HW_PDB_POnDLY_RD(x, n)   (HW_PDB_POnDLY(x, n).U)
#define HW_PDB_POnDLY_WR(x, n, v) (HW_PDB_POnDLY(x, n).U = (v))
#define HW_PDB_POnDLY_SET(x, n, v) (HW_PDB_POnDLY_WR(x, n, HW_PDB_POnDLY_RD(x, n) |  (v)))
#define HW_PDB_POnDLY_CLR(x, n, v) (HW_PDB_POnDLY_WR(x, n, HW_PDB_POnDLY_RD(x, n) & ~(v)))
#define HW_PDB_POnDLY_TOG(x, n, v) (HW_PDB_POnDLY_WR(x, n, HW_PDB_POnDLY_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual PDB_POnDLY bitfields
 */

/*!
 * @name Register PDB_POnDLY, field DLY2[15:0] (RW)
 *
 * These bits specify the delay 2 value for the PDB Pulse-Out. Pulse-Out goes
 * low when the PDB counter is equal to the DLY2. Reading these bits returns the
 * value of internal register that is effective for the current PDB cycle.
 */
/*@{*/
#define BP_PDB_POnDLY_DLY2   (0U)          /*!< Bit position for PDB_POnDLY_DLY2. */
#define BM_PDB_POnDLY_DLY2   (0x0000FFFFU) /*!< Bit mask for PDB_POnDLY_DLY2. */
#define BS_PDB_POnDLY_DLY2   (16U)         /*!< Bit field size in bits for PDB_POnDLY_DLY2. */

/*! @brief Read current value of the PDB_POnDLY_DLY2 field. */
#define BR_PDB_POnDLY_DLY2(x, n) (HW_PDB_POnDLY(x, n).B.DLY2)

/*! @brief Format value for bitfield PDB_POnDLY_DLY2. */
#define BF_PDB_POnDLY_DLY2(v) ((uint32_t)((uint32_t)(v) << BP_PDB_POnDLY_DLY2) & BM_PDB_POnDLY_DLY2)

/*! @brief Set the DLY2 field to a new value. */
#define BW_PDB_POnDLY_DLY2(x, n, v) (HW_PDB_POnDLY_WR(x, n, (HW_PDB_POnDLY_RD(x, n) & ~BM_PDB_POnDLY_DLY2) | BF_PDB_POnDLY_DLY2(v)))
/*@}*/

/*!
 * @name Register PDB_POnDLY, field DLY1[31:16] (RW)
 *
 * These bits specify the delay 1 value for the PDB Pulse-Out. Pulse-Out goes
 * high when the PDB counter is equal to the DLY1. Reading these bits returns the
 * value of internal register that is effective for the current PDB cycle.
 */
/*@{*/
#define BP_PDB_POnDLY_DLY1   (16U)         /*!< Bit position for PDB_POnDLY_DLY1. */
#define BM_PDB_POnDLY_DLY1   (0xFFFF0000U) /*!< Bit mask for PDB_POnDLY_DLY1. */
#define BS_PDB_POnDLY_DLY1   (16U)         /*!< Bit field size in bits for PDB_POnDLY_DLY1. */

/*! @brief Read current value of the PDB_POnDLY_DLY1 field. */
#define BR_PDB_POnDLY_DLY1(x, n) (HW_PDB_POnDLY(x, n).B.DLY1)

/*! @brief Format value for bitfield PDB_POnDLY_DLY1. */
#define BF_PDB_POnDLY_DLY1(v) ((uint32_t)((uint32_t)(v) << BP_PDB_POnDLY_DLY1) & BM_PDB_POnDLY_DLY1)

/*! @brief Set the DLY1 field to a new value. */
#define BW_PDB_POnDLY_DLY1(x, n, v) (HW_PDB_POnDLY_WR(x, n, (HW_PDB_POnDLY_RD(x, n) & ~BM_PDB_POnDLY_DLY1) | BF_PDB_POnDLY_DLY1(v)))
/*@}*/

/*******************************************************************************
 * hw_pdb_t - module struct
 ******************************************************************************/
/*!
 * @brief All PDB module registers.
 */
#pragma pack(1)
typedef struct _hw_pdb
{
    __IO hw_pdb_sc_t SC;                   /*!< [0x0] Status and Control register */
    __IO hw_pdb_mod_t MOD;                 /*!< [0x4] Modulus register */
    __I hw_pdb_cnt_t CNT;                  /*!< [0x8] Counter register */
    __IO hw_pdb_idly_t IDLY;               /*!< [0xC] Interrupt Delay register */
    struct {
        __IO hw_pdb_chnc1_t CHnC1;         /*!< [0x10] Channel n Control register 1 */
        __IO hw_pdb_chns_t CHnS;           /*!< [0x14] Channel n Status register */
        __IO hw_pdb_chndly0_t CHnDLY0;     /*!< [0x18] Channel n Delay 0 register */
        __IO hw_pdb_chndly1_t CHnDLY1;     /*!< [0x1C] Channel n Delay 1 register */
        uint8_t _reserved0[24];
    } CH[2];
    uint8_t _reserved0[240];
    struct {
        __IO hw_pdb_dacintcn_t DACINTCn;   /*!< [0x150] DAC Interval Trigger n Control register */
        __IO hw_pdb_dacintn_t DACINTn;     /*!< [0x154] DAC Interval n register */
    } DAC[2];
    uint8_t _reserved1[48];
    __IO hw_pdb_poen_t POEN;               /*!< [0x190] Pulse-Out n Enable register */
    __IO hw_pdb_pondly_t POnDLY[3];        /*!< [0x194] Pulse-Out n Delay register */
} hw_pdb_t;
#pragma pack()

/*! @brief Macro to access all PDB registers. */
/*! @param x PDB module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_PDB(PDB0_BASE)</code>. */
#define HW_PDB(x)      (*(hw_pdb_t *)(x))

#endif /* __HW_PDB_REGISTERS_H__ */
/* EOF */
