#include "tempModule.h"


TempModule::TempModule (PinName pin) : _sensor(pin)
{
    // Constructor code goes here
    // you can ignore initializing _sensor, we've already done that
    roomTemp = 26.0;
    setBaseVx(2.0);
    setBaseVy(2.0);
}

TempModule::TempModule (PinName pin, float vx, float vy) : _sensor(pin)
{
    // Constructor code goes here
    // you can ignore initializing _sensor, we've already done that
    roomTemp = 26.0;
    setBaseVx(vx);
    setBaseVy(vy);
    
}

float TempModule::read()
{
    return ((_sensor.read()*3.3)-0.500)*100.0; //temp in degree C
    }
    
//Set functions
void TempModule::setBaseVx(float vx)
{
    basevx = vx;
    }
void TempModule::setBaseVy(float vy)
{
    basevy = vy;
    }
//Get Functions
float TempModule::getVx()
{
    return ((( roomTemp - read()) / 10) + basevx);
    
    }  
    
float TempModule::getVy()
{
   return (((roomTemp - read()) / 10) + basevy);
   }
float TempModule::getVx (uLCD_4DGL *uLCD) 
{  uLCD->locate(1,14);
   uLCD->printf("%f", read());
   return (((read()-roomTemp) / 10) + basevx);
   
    
    } 
    
