#include "uLCD_4DGL.h"

class Paddle 
{
public:
    // Constructors
    Paddle(int, int);
    Paddle(int, int, int, int);
    // Set Functions
    void setLength(int);
    void setWidth(int);
    void setPaddleMove(int);  
    void setLimits(int, int); // upper and lower limits of the paddle
    // Get Function
    int getScore();
    // Member Functions
    void movePaddle(bool); // moves the paddle locations (does not draw!)
    bool checkHitX(int, int, int, bool); // Using a position and radius, checks to see if something has hit the paddle in the x direction. The bool is to determine if it is the left or right paddle
    bool checkHitY(int, int, int); // Using a position and radius, checks to see if something has hit the paddle in the y direction
    void resetScore(); // sets score to 0
    void initDraw(uLCD_4DGL *uLCD); // draw the paddle initially (draws the whole thing)
    void redraw(uLCD_4DGL *uLCD); // draws the paddle for a move (does NOT draw the whole thing)
    

private:
    // Data members are suggestions, feel free to add/remove
    int score;
    int x;
    int y;
    int oldy;
    int length;
    int width;
    int paddleMove;
    int topLimit;
    int bottomLimit;
};

