#include "uLCD_4DGL.h"

/* Recommendation:
 * This class doesn't need to be declared outside the Ball class,
 * so you can create it inside the Ball class and use it only
 * in the Ball class.
 *
 * If the main function or multiple objects use a piece of hardware
 * or a class object (like uLCD or mySpeaker), you should pass a 
 * pointer into the object rather than creating the object (either
 * in the stack or using new).
 */

class TempModule 
{
public:
    // Constructors
    TempModule(PinName pin);
    TempModule(PinName pin, float vx, float vy);
    // Reading temperature values
    float read();
    // Set Functions
    void setBaseVx(float); // This sets the lowest velocity of vx
    void setBaseVy(float); // This sets the lowest velocity of vy
    // Get Functions/Member Functions
    float getVx();  // Calculates a speed based off of the temp
    float getVy();   
    float getVx(uLCD_4DGL *); // Same thing as getVx(), except it 
                              // also writes the temp to the screen.

private:
    // Data members are suggestions, feel free to add/remove
    AnalogIn _sensor; //_pin
    float roomTemp;
    float holdTemp;
    float basevx;
    float basevy;
    int counter;
};

  
