#include "mbed.h"
#include "BufferedSerial.h"
#include <stdio.h>

/*****************************************************************************/
/* Define                                                                    */
/*****************************************************************************/
#define DEBUG_CONSOLE

/*****************************************************************************/
/* Objects declaration                                                       */
/*****************************************************************************/
//BufferedSerial pc(SERIAL_TX, SERIAL_RX); // Tx, Rx
BufferedSerial pc(PA_9, PA_10); // Tx, Rx

DigitalOut myled(LED1);

InterruptIn mybutton(USER_BUTTON);

/*****************************************************************************/
/* Globals variables                                                         */
/*****************************************************************************/
char rxData[4];
char txData[5] = {'0','1','2','3','4'};
uint8_t seq = 0;

/*****************************************************************************/
/* Private functions prototypes                                              */
/*****************************************************************************/
void send_and_receive_data(void);

/*****************************************************************************/
/* Interrupt Functions                                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Ticker Function                                                           */
/*****************************************************************************/
//Ticker EventEngine;

void send_and_receive_data(void)
{     
    myled = SET;
    if(seq < 4){
        if(pc.writeable()){
            pc.putc(txData[seq]); 
            seq++;     
            if(pc.readable()){
                rxData[0] = pc.getc();}
        }
    }
    else{
        seq = 0;   
    }

    myled = RESET;
    
    return;
}

//void EventFunction(void)
//{
//    send_and_receive_data();
//}

/*****************************************************************************/
/* Main Function                                                           */
/*****************************************************************************/
int main()
{
    pc.baud(9600);
    //EventEngine.attach(&EventFunction, 0.05); // 20 times/s
    mybutton.mode(PullUp);

//    printf("\033[2J\033[1;1HNucleoF401\r\n");

    myled = RESET;

    // Endless loop!
    while(1) {
        // Wait Press and realase Button
        while(mybutton == SET);
        while(mybutton == RESET);
        
        send_and_receive_data();
    }
}
