#include "mbed.h"
#include "MS5607I2C.h"

DigitalOut cutter[] = {(PD8), (PD13)};

int Alt0 ;
int Alt1 ;
MS5607I2C ms5607(PE0, PE1, false);



enum alt_States {Setup, Launchpad, Flight, Deployment};
alt_States current = Setup;

float get_Avg()
{
    float sum_a = 0.0;
    int iterations = 5;
    for(int i = 0; iterations<5; i++) {
        sum_a += ms5607.getAltitude();
        wait_ms(10);
    }
    return sum_a / iterations;
}

int currAlt = get_Avg();


int main()
{

    switch(current) {
        case Setup: {

            wait(600);
            Alt0 = currAlt;
            current = Launchpad;
        }
        break;

        case Launchpad: {

            int Alt1 = currAlt;
            wait(5);
            if(Alt1 >> Alt0+100) {
                current = Flight;
                break;
            }
            Alt0 = Alt1;
        }
        break;

        case Flight: {
            wait(1);
            if(currAlt << Alt1) {
                current = Deployment;
                break;
            }
            Alt1 = currAlt;
        }
        break;

        case Deployment: {
            cutter[1] = 1;
            cutter[2] = 1;
            break;
        }




    }
}

