#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "NokiaLCD.h"
//Mapquest traffic RSS Feed - get web page with XML
// displays Road diversions/closures on LCD  from XML "<fullDesc>.... text...</fullDesc>"
NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
EthernetNetIf eth;
HTTPClient http;
HTTPResult result;
bool completed = false;

void request_callback(HTTPResult r) {
    result = r;
    completed = true;
}

int main() {
    char *tstartXML = "<fullDesc>"; //RSS XML start title
    char *tendXML = "</fullDesc>";  //RSS XML end title
    char *tsptr;                    //Start Pointer
    char *teptr;                    //End Pointer
    int i=0,j=0;
    lcd.cls();                      //Clear LCD Screen
    lcd.locate(0,1);
    lcd.printf("net setup");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd.printf("net error");
        return -1;
    }
    lcd.locate(0,2);
    lcd.printf("net ok");
    wait(1);
    lcd.cls();                      //Clear LCD Screen
    HTTPStream stream;
    char BigBuf[2048 + 1] = {0};
    stream.readNext((byte*)BigBuf, 2048); //Point to buffer for the first read
    //Get web page with XML
    HTTPResult r = http.get("http://www.mapquestapi.com/traffic/v1/incidents?key=Fmjtd%7Cluub2l6z2u%2C75%3Do5-96twuy&callback=handleIncidentsResponse&boundingBox=33.977698,-84.662833,33.520957,-84.113516&filters=construction,incidents&inFormat=kvp&outFormat=xml", &stream, request_callback);
    while (!completed) {
        Net::poll();                // Polls the Networking stack
        if (stream.readable()) {    // check for end of file
            BigBuf[stream.readLen()] = 0; // Transform this buffer in a zero-terminated char* string
            tsptr = BigBuf;
            // displays titles on LCD  from XML "<title>....title text...</title>"
            do {
                tsptr = strstr(tsptr,tstartXML); // find <fullDesc> in string - NULL if not
                teptr = strstr(tsptr,tendXML);   // find <\fullDesc> in string - NULL if not
                if (tsptr!=NULL) tsptr = tsptr + strlen(tstartXML);// move to char after "<fullDesc>"
                if ((tsptr!=NULL)&&(teptr!=NULL)) {
                    i=0;
                    // loop to display lines on LCD
                    for (j=0; (j)<(strlen(tsptr)-strlen(teptr)); j=j+16) {
  //                      lcd.cls(); // clear screen before writing a new line
                        lcd.locate(0,(2+(j/16)));
                        // loop to output a line on the LCD
                        for (i=0; ((i<16)&&(tsptr[i+j] != '<')); i++) {
                            lcd.putc(tsptr[i+j]);
                        }
                    }
                    wait(5);
                    lcd.cls(); //clear LCD between traffic updates
                    lcd.locate(0,2);
                }
            } while (tsptr!=NULL); // No more "<fullDesc>"s in BigBuf to display
            stream.readNext((byte*)BigBuf, 2048); //Buffer read, now we can put more data in it
        }
    }
    lcd.cls();
    if (result == HTTP_OK) {
        lcd.cls();
        lcd.locate(0,1);
        lcd.printf(" Read complete");
    } else {
        lcd.printf(" Error %d\", result");
        return -1;
    }
}
