// WIZ820ioInterface.cpp 2013/4/5
#include "WIZ820ioInterface.h"
#include "DHCPClient.h"

WIZ820ioInterface::WIZ820ioInterface(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName reset) :
    WIZ820io(mosi, miso, sclk, cs, reset)
{
    ip_set = false;
}

WIZ820ioInterface::WIZ820ioInterface(SPI* spi, PinName cs, PinName reset) :
    WIZ820io(spi, cs, reset)
{
    ip_set = false;
}

int WIZ820ioInterface::init()
{
    dhcp = true;
    reset();
    return 0;
}

int WIZ820ioInterface::init(const char* ip, const char* mask, const char* gateway)
{
    dhcp = false;
    this->ip = str_to_ip(ip);
    strcpy(ip_string, ip);
    ip_set = true;
    this->netmask = str_to_ip(mask);
    this->gateway = str_to_ip(gateway);
    reset();
    return 0;
}

int WIZ820ioInterface::connect()
{
    if (dhcp) {
        int r = IPrenew();
        if (r < 0) {
            return r;
        }
    }
    if (WIZ820io::join() == false) return -1;
    return 0;
}

int WIZ820ioInterface::disconnect()
{
    if (WIZ820io::disconnect() == false) return -1;
    return 0;
}

char* WIZ820ioInterface::getIPAddress()
{
    uint32_t ip = reg_rd<uint32_t>(SIPR);
    snprintf(ip_string, sizeof(ip_string), "%d.%d.%d.%d", (ip>>24)&0xff, (ip>>16)&0xff, (ip>>8)&0xff, ip&0xff);
    return ip_string;
}

char* WIZ820ioInterface::getNetworkMask()
{
    uint32_t ip = reg_rd<uint32_t>(SUBR);
    snprintf(mask_string, sizeof(mask_string), "%d.%d.%d.%d", (ip>>24)&0xff, (ip>>16)&0xff, (ip>>8)&0xff, ip&0xff);
    return mask_string;
}

char* WIZ820ioInterface::getGateway()
{
    uint32_t ip = reg_rd<uint32_t>(GAR);
    snprintf(gw_string, sizeof(gw_string), "%d.%d.%d.%d", (ip>>24)&0xff, (ip>>16)&0xff, (ip>>8)&0xff, ip&0xff);
    return gw_string;
}

char* WIZ820ioInterface::getMACAddress()
{
    uint8_t mac[6];
    reg_rd_mac(SHAR, mac);
    snprintf(mac_string, sizeof(mac_string), "%02X:%02X:%02X:%02X:%02X:%02X", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
    return mac_string;
}

int WIZ820ioInterface::IPrenew(int timeout_ms)
{
    printf("DHCP Started, waiting for IP...\n");  
    DHCPClient dhcp;
    int err = dhcp.setup(timeout_ms);
    if (err == (-1)) {
        printf("Timeout.\n");
        return -1;
    }
//    printf("Connected, IP: %d.%d.%d.%d\n", dhcp.yiaddr[0], dhcp.yiaddr[1], dhcp.yiaddr[2], dhcp.yiaddr[3]);
    ip      = (dhcp.yiaddr[0] <<24) | (dhcp.yiaddr[1] <<16) | (dhcp.yiaddr[2] <<8) | dhcp.yiaddr[3];
    gateway = (dhcp.gateway[0]<<24) | (dhcp.gateway[1]<<16) | (dhcp.gateway[2]<<8) | dhcp.gateway[3];
    netmask = (dhcp.netmask[0]<<24) | (dhcp.netmask[1]<<16) | (dhcp.netmask[2]<<8) | dhcp.netmask[3];
    dnsaddr = (dhcp.dnsaddr[0]<<24) | (dhcp.dnsaddr[1]<<16) | (dhcp.dnsaddr[2]<<8) | dhcp.dnsaddr[3];
    return 0;
}
