#include "mbed.h"
#include "EthernetInterface.h"
#include <string>

Serial pc(USBTX,USBRX);

extern "C" void mbed_mac_address(char * mac) {
 
// define your own MAC Address ba:d7:05:47:1f:c6
  mac[0] = 0xba;  
  mac[1] = 0xd7;  
  mac[2] = 0x05;  
  mac[3] = 0x47;  
  mac[4] = 0x1f;  
  mac[5] = 0xc6;           
  
};

int main() {
    pc.baud(9600);
    pc.printf("Running\n");
    EthernetInterface eth;
    eth.init(); //Use DHCP
    wait(15);
    eth.connect();
    wait(15);
    pc.printf("MAC is %s\n", eth.getMACAddress());
    pc.printf("IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketConnection sock;
    sock.connect("192.184.82.3", 5000);
    
    char http_cmd[300] = "GET /create_board?playerNum=1&gameNum=144&board=1111000000000000000000000000000000000000000000000000000000000000 HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    //Instead of printing here, do what you did before to convert the string, and just append buffer to a string (below the break),
    //    replacing pc.printf
    //Then we can do string find to snipe the values we want (have to do math to grab the right amount)
    //Implemented example here, testStr now holds the received text (so you can search it)
    string testStr = "";
    char buffer[600];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server:\n%s\n", ret, buffer);
        string conv(buffer);
        testStr = testStr + conv;
    }
    pc.printf("Stringified %s\n", testStr);
    sock.close();
    wait(0.2);
    sock.connect("192.184.82.3", 5000);
    wait(0.2);
    strcpy(http_cmd, "GET /create_board?playerNum=2&gameNum=144&board=1111000000000000000000000000000000000000000000000000000000000000 HTTP/1.0\n\n");
    pc.printf("Command is %s", http_cmd);
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
    
    sock.close();
    wait(0.2);
    sock.connect("192.184.82.3", 5000);
    wait(0.2);
    strcpy(http_cmd, "GET /polling?gameNum=144&playerNum=1 HTTP/1.0\n\n");
    pc.printf("Command is %s", http_cmd);
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
      
    sock.close();
    wait(0.2);
    sock.connect("192.184.82.3", 5000);
    wait(0.2);
    strcpy(http_cmd, "GET /fire?playerNum=1&gameNum=144&x=1&y=0 HTTP/1.0\n\n");
    pc.printf("Command is %s", http_cmd);
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
    
    sock.close();
    eth.disconnect();
    
    while(1) {}
}
