#include <vector>
#include "mbed.h"

struct vec2 {
    double x;
    double y;  
};

//Class for the asteroids falling from the sky
class Missile{
private:

public:
    bool moved;
    double x_change;
    double y_change;
    vec2 spawn;
    vec2 dest;
    vec2 coord;
    vec2 old_coord;
    vec2 size;
    int steps;
    
    vec2 prev_coord;
  
Missile(vec2 giv_spawn, vec2 giv_dest, int steps_in) :  moved(false)
{

    spawn = giv_spawn;
    dest = giv_dest;
    coord = giv_spawn;
    old_coord = coord;
    size.x = 6;
    size.y = 6;
    steps = steps_in;
    x_change = (dest.x - spawn.x) / steps;
    y_change = (dest.y - spawn.y) / steps;
    
}

//When called, moves the asteroid towards the bottom
void move(){ 
    old_coord = coord;
    moved = true;
    coord.x = coord.x + x_change;
    coord.y = coord.y + y_change;
}
};

//Handles all the fired projectiles
class Projectile{
private:

public:
    bool moved;
    vec2 old_coord;
    vec2 coord;
    vec2 size;
    
Projectile(vec2 coord_in) : moved(false)
{
    coord.x = coord_in.x + 3;
    coord.y = coord_in.y + 6;
    old_coord = coord;
    size.x = 3;
    size.y = 3;
}

void move(){ 
    old_coord = coord;
    moved = true;
    coord.y = coord.y - 4;
}
};

//Handles the object the user controls
class Shooter{
private:

public:
    bool moved;
    vec2 coord;
    vec2 old_coord;
    vec2 size;
    
Shooter() : moved(false)
{
    coord.x = 58;
    coord.y = 125;
    old_coord = coord;
    size.x = 11;
    size.y = 5;
}
};