// uLCD-144-G2 demo program for uLCD-4GL LCD driver library
//
#include "mbed.h"
#include "Speaker.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "mutexlocker.h"

SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card

AnalogOut DACout(p18);

wave_player waver(&DACout);


Mutex myMutex;

uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;
DigitalOut latch(p15);
DigitalOut enable(p16);

//Cycles through different colors on RGB LED
SPI spi(p11, p12, p13);

int red;
int blue;
int green;

void Sound(void const *args) {
    FILE *wave_file;
    printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/sample.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
}

void RGB_LED(int red, int green, int blue) {
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}

void LightControl(void const *args){

    int red=2;
    int green=2;
    int blue=2;
    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;
    wait(2);
    while(red < 90) {
        RGB_LED(red++, green++, blue++);
        wait(10);
    }
    
    
    Thread::wait(1000);
    
    
}

void LCD1(void const *args) {
    myMutex.lock();
    while(true){    
    uLCD.text_width(4); //4X size text
    uLCD.text_height(4);
    uLCD.color(GREEN);
    for (int i=10; i>=0; --i) {
        uLCD.locate(1,2);
        uLCD.printf("%2D",i);
        wait(.5);
    }
    uLCD.cls();
    Thread::wait(1000);
    
    
    
    myMutex.unlock();
    }
    
}

void LCD2(void const *args) {
    myMutex.lock();
    while(true){ 
    uLCD.text_width(3); //4X size text
    uLCD.text_height(3);
    uLCD.color(RED);
    for (int i=10; i>=0; --i) {
        uLCD.locate(1,2);
        uLCD.printf("%2D",i);
        wait(.5);
    }
    myMutex.unlock();
    //uLCD.cls();
    Thread::wait(1000);}
    
}




int main()
{
    Thread thread1(Sound);
    Thread thread2(LightControl);
    Thread thread3(LCD1);
    Thread thread4(LCD2);
    
    //LightControl();
//Thread thread1(Sound);
//Thread thread2(Light);
//Thread thread3(LCD1);
//Thread thread4(LCD2);
    while(true){
    Thread::wait(100);
    }
}



