/** \file main.cpp
 *  \brief mbed Hello World demo for TFT-320QVT module with SSD1289 and XPT2046 touchscreen.
 *   
 *  \copyright GNU Public License, v2. or later
 *  Creates a window, which can be dragged within the screen, and can be closed
 *  with the standard WIndows-style "x"-button.
 *  Window appearance: initial position, size and colors can be changed via defines
 *  Window in this demo can not be moved beyond the screen area except of the right side.
 *  May require a touchscreen calibration procedure using UTouchCD.h
 *
 *  Made by Dmitry Shtatnov, SSSR Labs
 *  http://modularsynth.ru/
 ***************************************************************************************/

#include "mbed.h"
#include "ssd1289.h"
#include "UTouch.h"

#define C_WINDOW_BODY       0xCCCCCC
#define C_WINDOW_HIGHLIGHT  0xDDDDDD
#define C_WINDOW_SHADOW     0xBBBBBB
#define C_WINDOW_TITLE_BAR  0x0066DD
#define C_DESKTOP_BG        0x000000

#define WINDOW_WIDTH 150
#define WINDOW_HEIGHT 100

PortOut LCDPA(PortA,0xFF00);
PortOut LCDPC(PortC,0x00FF);
//                 CS,   REST, RS,   WR,   DATA,      BL, RD
SSD1289_LCD myGLCD(PB_3, PB_4, PB_0, PB_1, &LCDPA, &LCDPC, NC, PB_2);

UTouch  myTouch(PB_9, PB_8, PB_7, PB_6, PB_5);
  long x, y, oldx, oldy, wx, wy;
  float p;
  uint8_t av_cnt;
    int16_t rx, ry, rz1, rz2, pressure;
  char xc[10], yc[10], z1c[10], z2c[10], str[15];
  bool drag = false;
  bool loop = true;
    
bool title(uint16_t xcur, uint16_t ycur, uint16_t xwin, uint16_t ywin) {
    if((xcur>xwin+2)&&(xcur<xwin+WINDOW_WIDTH-18)&&(ycur>ywin+2)&&(ycur<ywin+22)) return true;
    else return false;
}

bool close(uint16_t xcur, uint16_t ycur, uint16_t xwin, uint16_t ywin) {
    if((xcur>xwin+WINDOW_WIDTH-19)&&(xcur<xwin+WINDOW_WIDTH-1)&&(ycur>ywin+2)&&(ycur<ywin+21)) return true;
    else return false;
}

void drawBox(uint16_t xpos, uint16_t ypos, uint16_t xsize, uint16_t ysize) {
    myGLCD.FillRect(xpos,ypos,xpos+xsize-1,ypos+ysize-1,C_WINDOW_BODY);
    myGLCD.DrawHLine(xpos,ypos,xsize,C_WINDOW_HIGHLIGHT);
    myGLCD.DrawHLine(xpos+1,ypos+ysize-1,xsize-1,C_WINDOW_SHADOW);
    myGLCD.DrawVLine(xpos,ypos,ysize,C_WINDOW_HIGHLIGHT);
    myGLCD.DrawVLine(xpos+xsize-1,ypos,ysize-1,C_WINDOW_SHADOW);
}    

void drawWindow(uint16_t xpos, uint16_t ypos, uint16_t xsize, uint16_t ysize) {
    drawBox(xpos, ypos, xsize, ysize);
    myGLCD.FillRect(xpos+2,ypos+2,xpos+xsize-3,ypos+21,C_WINDOW_TITLE_BAR);
    drawBox(xpos+xsize-21,ypos+3,18,18);
    myGLCD.DrawLine(xpos+xsize-18,ypos+6,xpos+xsize-7,ypos+17,COLOR_BLACK);
    myGLCD.DrawLine(xpos+xsize-18,ypos+17,xpos+xsize-7,ypos+6,COLOR_BLACK);
    myGLCD.SetBackground(C_WINDOW_TITLE_BAR);
    myGLCD.SetForeground(COLOR_WHITE);
    myGLCD.Print("Hello World", xpos+6,ypos+6);
}
int main() {
  myGLCD.Initialize();
  myGLCD.SetBackground(COLOR_WHITE);
  myGLCD.SetForeground(COLOR_BLACK);
  myGLCD.FillScreen(C_DESKTOP_BG);
  
while(1==1)
{
  wx = 85;
  wy = 70;
  loop = true;
  myGLCD.SetFont(&TerminusFont);
  myTouch.InitTouch();
  myTouch.SetPrecision(PREC_HI);
  drawWindow(wx,wy,WINDOW_WIDTH,WINDOW_HEIGHT);
  while(loop)
  {
    if (myTouch.DataAvailable() == true)
    {
      if(myTouch.Read()) {
        x = myTouch.GetX();
        y = myTouch.GetY();
        if((oldx!=x)&&(oldy!=y)) {
            if(drag) {
                myGLCD.FillRect(wx, wy, wx+WINDOW_WIDTH-1, wy+WINDOW_HEIGHT-1, C_DESKTOP_BG);
                wx=wx+x-oldx;
                wy=wy+y-oldy;
                drawWindow(wx,wy,WINDOW_WIDTH,WINDOW_HEIGHT);
            }
            if(title(x, y, wx, wy)) {
                drag = true;
                }
            if(close(x, y, wx, wy)) {
                myGLCD.FillRect(wx, wy, wx+WINDOW_WIDTH-1, wy+WINDOW_HEIGHT-1, C_DESKTOP_BG);
                loop = false;
            }
            oldx = x;
            oldy = y;
        }
      }
    }
    else {
      drag = false;
    }
  }
}
}
