#include "mbed.h"
#include "SparkfunAnalogJoystick.h"
#include "uLCD_4DGL.h"
#include "FEmain.h"
#define MapSecA 123
#define MapSecB 123

#include "Motor.h"

Motor m(p21, p24, p25); // pwm, fwd, rev

#define FORTRESS 0
#define HOUSE 1
#define KEEP 2
#define GRASS 3
#define TREES 4
#define COMP 2
#define USER 1


DigitalOut myled(LED1);
uLCD_4DGL uLCD(p9,p10,p11);
DigitalIn pb5(p5);
DigitalIn pb6(p6);
DigitalIn pb7(p7);
DigitalIn pb8(p8);
#define M_PI 3.14159265358979323846
Serial pc(USBTX, USBRX);
SparkfunAnalogJoystick joysttick(p18, p19, p20);
#define x_sector 0x003B
int analog2Keypad(SparkfunAnalogJoystick *joystick);
int player_turn;

struct tiles {
        char v;
        int x;
        int y;
        char passable;} fortress_t,house_t,keep_t,grass_t,trees_t;
        
tiles* tile_array[5] = {&fortress_t,&house_t,&keep_t,&grass_t,&trees_t};


typedef struct units {
        job_t job;
        int v;
        int FoF;//1 = USER // 2= COMP
        int xloc;
        int yloc;
        int xlast;
        int ylast;
        int remain_moves;
        int health;
        int status;
    } person_t;

    
static person_t Mc;
static person_t Ak;
static person_t Ap;
static person_t Healer;
static person_t Brigand;    
static person_t Thief;
static person_t Soldier;
static person_t Wolf;
static person_t Wolfa;
static person_t Wolfb;
static person_t Wolfc;




person_t* person_array[12] = {NULL,&Mc,&Ak,&Ap,&Healer,&Brigand,&Thief,&Soldier,&Wolf,&Wolfa,&Wolfb,&Wolfc};
    
int Map1_1[8][8] = {
    {FORTRESS, FORTRESS, FORTRESS,  GRASS,  GRASS,  GRASS,  HOUSE,  GRASS},
    {FORTRESS, FORTRESS, FORTRESS,  GRASS,  GRASS,  GRASS,  GRASS,  GRASS},
    {FORTRESS, FORTRESS, FORTRESS,  GRASS,  TREES,  GRASS,  GRASS,  GRASS},
    {GRASS,    GRASS,    GRASS,     GRASS,  GRASS,  GRASS,  GRASS,  GRASS},
    {GRASS,    GRASS,    GRASS,     GRASS,  GRASS,  GRASS,  GRASS,  GRASS},
    {GRASS,    GRASS,    GRASS,     GRASS,  TREES,  TREES,  TREES,  GRASS},
    {GRASS,    GRASS,    HOUSE,     TREES,  GRASS,  KEEP,   GRASS,  GRASS},
    {GRASS,    GRASS,    GRASS,     GRASS,  GRASS,  GRASS,  GRASS,  GRASS} };

int unitsMap1_1[8][8] = {
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0} };
    
    
    
        
void initialize(void);
int user_selecting(void);//return selection
int user_action(int selection);
int display_status(int selection); 
int user_movement(int selection);
int combat(person_t* attacker, person_t* defender);
int ai_movement(void);    
int state;
int cursor_x;
int cursor_y;
void kill_unit(person_t* dead_unit);
    
int main() {
    uLCD.media_init();
    pb5.mode(PullUp);
    pb6.mode(PullUp);
    pb7.mode(PullUp);
    pb8.mode(PullUp);
    initialize();
    int selection;
    int action;
    player_turn =1;
    cursor_x = 0;
    cursor_y = 0;
    state = 0;
    person_t* temp_persona;
    while(1) {
        if (state == 0){
            selection = user_selecting();}
        //else if (state ==1)
            //ret_val = display_status(selection); 
        else if (state == 2){
            action = user_movement(selection);}
        else if (state == 3){
            if (player_turn ==1){
                player_turn = 2;
                }
            else {
                player_turn =1;
                }
            for(int i=1; i<12;i++){
                temp_persona = person_array[i]; 
                temp_persona->remain_moves = temp_persona->job.movement; 
                }
            state = 0;
            }
        //else if (state == 4)
    }
}
//cleric - lord - ax
//noth - spear



void initialize(void){
    pc.printf("init function\n"); 
    init_jobs();
    keep_t.x = x_sector;
    house_t.x = x_sector;
    grass_t.x = x_sector;
    trees_t.x = x_sector;
    fortress_t.x = x_sector;
    fortress_t.y = 0x5042;
    trees_t.y = 0x5052;
    keep_t.y = 0x5054;
    grass_t.y = 0x5056;
    house_t.y = 0x5058;
    uLCD.set_sector_address(Mapx, Mapy);
    uLCD.display_image(0,0);
    Mc.job = Lord;
    Mc.v = 1;
    Mc.FoF = USER;
    Mc.xlast = 1;
    Mc.xloc = 1;
    Mc.ylast = 3;
    Mc.yloc = 3;
    Mc.remain_moves = Mc.job.movement;
    Mc.health = Mc.job.maxHealth;
    uLCD.set_sector_address(Mc.job.x, Mc.job.y);
    uLCD.display_image((Mc.xloc*16),(Mc.yloc*16));
    
    Ak.job = Armor;
    Ak.v = 2;
    Ak.FoF = USER;
    Ak.xlast = 1;
    Ak.xloc = 1;
    Ak.ylast = 4;
    Ak.yloc = 4;
    Ak.remain_moves = Ak.job.movement;
    Ak.health = Ak.job.maxHealth;
    
    uLCD.set_sector_address(Ak.job.x, Ak.job.y);
    uLCD.display_image((Ak.xloc*16),(Ak.yloc*16));
    
    Ap.job = Pirate;
    Ap.v = 3;
    Ap.FoF = USER;
    Ap.xlast = 2;
    Ap.xloc = 2;
    Ap.ylast = 3;
    Ap.yloc = 3;
    Ap.remain_moves = Ap.job.movement;
    Ap.health = Ap.job.maxHealth;
    
    uLCD.set_sector_address(Ap.job.x, Ap.job.y);
    uLCD.display_image((Ap.xloc*16),(Ap.yloc*16));
    
    Healer.job = Cleric;
    Healer.v = 4;
    Healer.FoF = USER;
    Healer.xlast = 0;
    Healer.xloc = 0;
    Healer.ylast = 3;
    Healer.yloc = 3;
    Healer.remain_moves = Healer.job.movement;
    Healer.health = Healer.job.maxHealth;
    
    uLCD.set_sector_address(Healer.job.x, Healer.job.y);
    uLCD.display_image((Healer.xloc*16),(Healer.yloc*16));
    
    Wolf.job = Beast;
    Wolf.v = 8;
    Wolf.FoF = COMP;
    Wolf.xlast = 7;
    Wolf.xloc = 7;
    Wolf.ylast = 4;
    Wolf.yloc = 4;
    Wolf.remain_moves = Wolf.job.movement;
    Wolf.health = Wolf.job.maxHealth;
    
    uLCD.set_sector_address(Wolf.job.x, Wolf.job.y);
    uLCD.display_image((Wolf.xloc*16),(Wolf.yloc*16));    
    unitsMap1_1[Wolf.yloc][Wolf.xloc] = Wolf.v;
    
    Wolfa.job = Beast;
    Wolfa.v = 9;
    Wolfa.FoF = COMP;
    Wolfa.xlast = 7;
    Wolfa.xloc = 7;
    Wolfa.ylast = 5;
    Wolfa.yloc = 5;
    Wolfa.remain_moves = Wolfa.job.movement;
    Wolfa.health = Wolfa.job.maxHealth;
    
    uLCD.set_sector_address(Wolfa.job.x, Wolfa.job.y);
    uLCD.display_image((Wolfa.xloc*16),(Wolfa.yloc*16));    
    unitsMap1_1[Wolfa.yloc][Wolfa.xloc] = Wolfa.v;
    
    Wolfb.job = Beast;
    Wolfb.v = 10;
    Wolfb.FoF = COMP;
    Wolfb.xlast = 6;
    Wolfb.xloc = 6;
    Wolfb.ylast = 4;
    Wolfb.yloc = 4;
    Wolfb.remain_moves = Wolfb.job.movement;
    Wolfb.health = Wolfb.job.maxHealth;
    
    uLCD.set_sector_address(Wolfb.job.x, Wolfb.job.y);
    uLCD.display_image((Wolfb.xloc*16),(Wolfb.yloc*16));    
    unitsMap1_1[Wolfb.yloc][Wolfb.xloc] = Wolfb.v;
    
    
    Wolfc.job = Beast;
    Wolfc.v = 11;
    Wolfc.FoF = COMP;
    Wolfc.xlast = 7;
    Wolfc.xloc = 7;
    Wolfc.ylast = 3;
    Wolfc.yloc = 3;
    Wolfc.remain_moves = Wolfc.job.movement;
    Wolfc.health = Wolfc.job.maxHealth;
    
    uLCD.set_sector_address(Wolfc.job.x, Wolfc.job.y);
    uLCD.display_image((Wolfc.xloc*16),(Wolfc.yloc*16));    
    unitsMap1_1[Wolfc.yloc][Wolfc.xloc] = Wolfc.v;
    
    unitsMap1_1[Mc.yloc][Mc.xloc] = Mc.v;
    unitsMap1_1[Ak.yloc][Ak.xloc] = Ak.v;
    unitsMap1_1[Ap.yloc][Ap.xloc] = Ap.v;
    unitsMap1_1[Healer.yloc][Healer.xloc] = Healer.v;
    
    return;
}
int user_selecting(void){    
    int xlast;
    int ylast;
    int action = 0;
    int person_index = 0;
    int tile_index = 0;
    int keypad = 5;
    int ret =0;
    person_t* temp_person;
    tiles* tile_erased;
    int j = pb5;
    int y = pb8;
    while(action == 0){
        keypad = 5;
        xlast = cursor_x;
        ylast = cursor_y;
        while((keypad == 5)&&(j ==1)){
        wait(1);
        j = pb5;
        y = pb8;
        keypad = analog2Keypad(&joysttick);
                if (y==0){
                    state = 3;
                    return 0;
                    }
        }
        switch (keypad)
    {
        case 1:
        {
            cursor_x = cursor_x -1;
            cursor_y = cursor_y +1;
        }
            break;
        case 2:
        {
            cursor_y = cursor_y +1;
        }
            break;
        case 3:
        {
            cursor_x = cursor_x +1;
            cursor_y = cursor_y +1;
        }
            break;
        case 4:
        {
            cursor_x = cursor_x -1;
        }
            break;
        case 5:
            break;
        case 6:
        {
            cursor_x = cursor_x +1;
        }
            break;
        case 7:
        {
            cursor_x = cursor_x -1;
            cursor_y = cursor_y -1;
        }
            break;
        case 8:
        {
            cursor_y = cursor_y -1;
        }
            break;
        case 9:
        {
            cursor_x = cursor_x + 1;
            cursor_y = cursor_y - 1;
        }
            break;
    }
        if (cursor_y <0)
            cursor_y = 0;
        if (cursor_x <0)
            cursor_x = 0;
        if (cursor_y >7)
            cursor_y = 7;
        if (cursor_x >7)
            cursor_x = 7;
        
        
        if((xlast != cursor_x) || (ylast != cursor_y)){
            person_index = unitsMap1_1[ylast][xlast];
            tile_index = Map1_1[ylast][xlast];
            if (person_index != 0){
                temp_person = person_array[person_index];
                uLCD.set_sector_address(temp_person->job.x, temp_person->job.y);
                uLCD.display_image((xlast*16), (ylast*16));
                }
            else{
                tile_erased = tile_array[tile_index];
                if (tile_index == 0){
                    uLCD.set_sector_address(tile_erased->x, tile_erased->y);
                    uLCD.display_image(0, 0);
                    }
                else{
                    uLCD.set_sector_address(tile_erased->x, tile_erased->y);
                    uLCD.display_image(xlast*16, ylast*16);
                    }
            }    
            uLCD.rectangle((cursor_x*16), (cursor_y*16), ((cursor_x*16)+15), ((cursor_y*16)+15), 0x000000);
        }
        int a = pb5;
        //int b = pb6;
        int c = pb7;
        int d = pb8;
        if (pb5 == 0){
        state = 2;
        action = 1;
        }
        //else if (pb6 == 0){
        //state = 3;
        //action = 2;
        //}
        else if (pb7 == 0){
        action = 3;
        }
        else if (pb8 == 0){
        action = 4;
        }
    }
    if (pb5 == 0){
        state = 2;
        action = 1;
    }
    return action;
}


int user_movement(int selection){
    int Index_j;
    Index_j = unitsMap1_1[cursor_y][cursor_x];
    person_t* User_person;
    if (Index_j == 0){
    state = 4;
    return 69;   
    }
    User_person = person_array[Index_j];
    if ((User_person->remain_moves) == 0)
    {
        state = 0;
        return 0;
    }
        if ((User_person->FoF) != player_turn)
    {
        state = 0;
        return 0;
    }
    int j = pb7;
    int xloc_u = 1;
    int yloc_u = 1;
    int xlast = 1;
    int ylast = 1;
while(j==1){
    j = pb7;
    xloc_u = (User_person->xloc);
    yloc_u = User_person->yloc;
    xlast = User_person->xlast;
    ylast = User_person->ylast;
    int keypad = 5;
        while((keypad == 5)&&(j==1)){
        wait(1);
        j = pb7;
        keypad = analog2Keypad(&joysttick);
        }
        switch (keypad)
        {
        case 1:
            xloc_u = xloc_u -1;
            yloc_u = yloc_u +1;
            break;
        case 2:
            yloc_u = yloc_u +1;
            break;
        case 3:
            xloc_u = xloc_u +1;
            yloc_u = yloc_u +1;
            break;
        case 4:
            xloc_u = xloc_u -1;
            break;
        case 5:
            break;
        case 6:
            xloc_u = xloc_u +1;
            break;
        case 7:
            xloc_u = xloc_u -1;
            yloc_u = yloc_u -1;
            break;
        case 8:
            yloc_u = yloc_u -1;
            break;
        case 9:
            xloc_u = xloc_u + 1;
            yloc_u = yloc_u - 1;
            break;
        }
        if (yloc_u <0)
            yloc_u = 0;
        if (xloc_u <0)
            xloc_u = 0;
        if (yloc_u >7)
            yloc_u = 7;
        if (xloc_u >7)
            xloc_u = 7;
        int x_change = 0;
        if (xloc_u != xlast)
            x_change = 1;
        int y_change = 0;
        if (yloc_u != ylast)
            y_change = 1;
        if (((User_person->remain_moves)-(y_change+x_change))<0){
            xloc_u = xlast;
            yloc_u = ylast;
            x_change = 0;
            y_change = 0;
            }
        
        
        int unit_index = unitsMap1_1[yloc_u][xloc_u];  
        if (unit_index != 0){
            person_t* target;
            target = person_array[unit_index];
            int alliance = target->FoF;
            if (alliance ==player_turn){
                m.speed(1.0);
                xloc_u = xlast;
                yloc_u = ylast;
                x_change = 0;
                y_change = 0;
                wait(1.0);
                m.speed(0.0);
                }
            else if(((xloc_u!=xlast)||(yloc_u!=ylast))&& (alliance != (User_person-> FoF)))
            {
                combat(User_person, target);
                User_person->remain_moves = 0;
                state = 0;
                return 0;
            }
        }  
        int tile_index = Map1_1[yloc_u][xloc_u];
        if (tile_index == 0){
            m.speed(1.0); 
            xloc_u = xlast;
            yloc_u = ylast;
            x_change = 0;
            y_change = 0;
            wait(1.0);
            m.speed(0.0);
        }      
        
        if((xlast != xloc_u) || (ylast != yloc_u)){
                tile_index = Map1_1[ylast][xlast];
                unitsMap1_1[ylast][xlast] = 0;
                unitsMap1_1[yloc_u][xloc_u] = User_person->v;
                tiles* tile_erased = tile_array[tile_index];
                if (tile_index == 0){
                    uLCD.set_sector_address(tile_erased->x, tile_erased->y);
                    uLCD.display_image(0, 0);
                    }
                else{
                    uLCD.set_sector_address(tile_erased->x, tile_erased->y);
                    uLCD.display_image(xlast*16, ylast*16);
                    }
                uLCD.set_sector_address(User_person->job.x,User_person->job.y);
                User_person->xloc = xloc_u;
                User_person->yloc = yloc_u;
                User_person->xlast = xloc_u;
                User_person->ylast = yloc_u;
                User_person->remain_moves = (User_person->remain_moves) - x_change - y_change;
                uLCD.display_image(((User_person->xloc)*16), ((User_person->yloc)*16));    
        }    
}    
    state = 0;
    return 0;
}

int analog2Keypad(SparkfunAnalogJoystick *joystick) {
    if (joystick->distance() > .1) { //not in deadzone, accept input
        if ((joystick->angle() > 0.0 && joystick->angle() < 22.5) ||(joystick->angle() > 337.5 && joystick->angle() < 360.0)) {
            return 6;
        } else if (joystick->angle() >= 22.5 && joystick->angle() < 67.5) {
            return 9;
        } else if (joystick->angle() >= 67.5 && joystick->angle() < 112.5) {
            return 8;    
        } else if (joystick->angle() >= 112.5 && joystick->angle() < 157.5) {
            return 7;
        } else if (joystick->angle() >= 157.5 && joystick->angle() < 202.5) {
            return 4;
        } else if (joystick->angle() >= 202.5 && joystick->angle() < 247.5) {
            return 1;
        } else if (joystick->angle() >= 247.5 && joystick->angle() < 292.5) {
            return 2;
        } else if (joystick->angle() >= 292.5 && joystick->angle() < 337.5) {
            return 3;
        }
    } else {
        return 5;
    }
}

int combat(person_t* attacker, person_t* defender){
    int d_health = (defender->health)-((attacker->job.damage)-(defender->job.defence));
    int a_health;
    if (d_health < (defender->health))
        defender->health = d_health;
    if ((defender->health)>0){
        a_health = (defender->health)-(((attacker->job.damage)-(defender->job.defence))/2);
        attacker->health = a_health;
        }
    pc.printf("attacker health %d \n",attacker->health);
    pc.printf("defender health %d \n",defender->health);
    if ((defender->health)<=0)
        kill_unit(defender);
    if ((attacker->health)<=0)
        kill_unit(attacker);
    
    
    return 0;
    }

void kill_unit(person_t* dead_unit){
    int xloc = dead_unit->xloc;
    int yloc = dead_unit->yloc;
    unitsMap1_1[yloc][xloc] = 0;
    int tile_index = Map1_1[yloc][xloc];
    tiles* tile_dead_spot;
    tile_dead_spot = tile_array[tile_index];
    uLCD.set_sector_address(tile_dead_spot->x,tile_dead_spot->y);
    uLCD.display_image(((dead_unit->xloc)*16), ((dead_unit->yloc)*16));    
    
    return;
    }

