

#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include "song1.h"
#include "SparkfunAnalogJoystick.h"
#define sample_freq 8000.0
//code change
Mutex lcd_mut;
//SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;
//AnalogOut DACout(p18);
//wave_player waver(&DACout);
AnalogOut speaker(p18);
SparkfunAnalogJoystick joy(p16, p17, p15);
PinDetect pb_1(p9, PullUp);
PinDetect pb_2(p10, PullUp);
PinDetect pb_3(p11, PullUp);
PinDetect pb_4(p12, PullUp);

#define Main_Menu 0  // the first screen being shown
#define Choose_Difficulty 1 // after hitting start, player chooses difficult
#define Choose_Song 2       // after choosing difficullyt, choose song
#define Start_Game 3      // the game has started
#define Game_Over 4       // the game is done


//colors
#define YELLOW 16709376

//speed based on difficulty
#define Easy 10   
#define Medium 15     
#define Hard 20     


DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

Ticker sampletick;

volatile int Game_State = Main_Menu;
volatile bool draw_enable = true;
volatile int Speed = Easy; 

volatile int y1;
volatile int y2;
volatile int y3;
volatile int y4;
volatile int score = 0;
volatile int highScore = 0;
volatile int easyHigh = 0;
volatile int medHigh = 0;
volatile int hardHigh = 0;
volatile int hit = 0;
volatile int miss = 0;
volatile int totalBubbles = 0;

volatile bool greenRelease = false;
volatile bool redRelease = false;
volatile bool yellowRelease = false;
volatile bool blueRelease = false;

volatile bool greenPress = false;
volatile bool redPress = false;
volatile bool yellowPress = false;
volatile bool bluePress = false;

int i=0;

void otherMode(int speed) {
    int scoreUp;
    if (speed == Medium) {
        y1 = 5;
        y2 = 5;
        y3 = 5;
        y4 = 5;
        scoreUp = 1000;
    } else {
        y1 = 10;
        y2 = 10;
        y3 = 10;
        y4 = 10;
        scoreUp = 1500;
    }
    int pattern = 1;
    score = 0;
    hit = 0;
    totalBubbles = 0;
    Speed = speed;
    //uLCD.cls();
    //uLCD.printf("GameStart");
    uLCD.baudrate(BAUD_3000000); //jack up baud rate to max for fast display
    uLCD.background_color(BLACK);
    Thread::wait(1000);
        uLCD.circle(10,110, 8, GREEN);
        uLCD.circle(45,110, 8, RED);
        uLCD.circle(80,110, 8, YELLOW);
        uLCD.circle(115,110, 8, BLUE);
    Thread::wait(750);
    switch (pattern) {
        case 1:
            totalBubbles += 4;
            greenPress = false;
            redPress = false;
            yellowPress = false;
            bluePress = false;
            redRelease = false;
            yellowRelease = false;
            greenRelease = false;
            blueRelease = false;
            if (speed == Medium) {
                y1 = 5;
                y2 = 5;
                y3 = 5;
                y4 = 5;
            } else {
                y1 = 30;
                y2 = 30;
                y3 = 30;
                y4 = 30;
            }
            while (y4 <= 130) {
                if(y1 <= 130) {
                    y1 += Speed;
                }
                if (redRelease) {
                    y2+= Speed;
                }
                if (yellowRelease) {
                    y3+= Speed;
                }
                if (blueRelease) {
                    y4 += Speed;
                }
                
                if(y1 <= 130 && !greenPress) {
                    uLCD.filled_circle(10,y1, 8 , GREEN);
                }
                if ((y1 >= 31 && y2 <= 130) && !redPress ) {
                    uLCD.filled_circle(45,y2, 8 , RED);
                    redRelease = true;
                }
                if ((y2 >= 31 && y3 <= 130) && !yellowPress) {
                    uLCD.filled_circle(80,y3, 8 , YELLOW);
                    yellowRelease = true;
                }
                if((y3 >= 31 && y4 <= 130) && !bluePress) {
                    uLCD.filled_circle(115,y4, 8 , BLUE);
                    blueRelease = true;
                }
                Thread::wait(250);
                uLCD.filled_circle(10, y1, 8 , BLACK);
                uLCD.filled_circle(45, y2, 8 , BLACK);
                uLCD.filled_circle(80, y3, 8 , BLACK);
                uLCD.filled_circle(115, y4, 8 , BLACK);
                
                if (y1 == 110 && greenPress) {
                    //uLCD.filled_circle(10, y1, 8 , WHITE);
                    uLCD.circle(10,110, 8, GREEN);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(10, y1, 8 , BLACK);
                    uLCD.circle(10,110, 8, GREEN);
                }
                if (y2 == 110 && redPress) {
                    //uLCD.filled_circle(45, y2, 8 , WHITE);
                    uLCD.circle(45,110, 8, RED);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(45, y2, 8 , BLACK);
                    uLCD.circle(45,110, 8, RED);
                }
                if(y3 == 110 && yellowPress) {
                    //uLCD.filled_circle(80, y3, 8 , WHITE);
                    uLCD.circle(80,110, 8, YELLOW);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(80, y3, 8 , BLACK);
                    uLCD.circle(80,110, 8, YELLOW);
                }
                if(y4 == 110 && bluePress) {
                    uLCD.circle(115,110, 8, BLUE);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(115, y4, 8 , BLACK);
                    uLCD.circle(115,110, 8, BLUE);
                }
            }
            
        case 2: //green and red then yellow and blue
            totalBubbles += 4;
            greenPress = false;
            redPress = false;
            yellowPress = false;
            bluePress = false;
            redRelease = false;
            yellowRelease = false;
            greenRelease = false;
            blueRelease = false;
            if (speed == Medium) {
                y1 = 5;
                y2 = 5;
                y3 = 5;
                y4 = 5;
            } else {
                y1 = 10;
                y2 = 10;
                y3 = 10;
                y4 = 10;
            }
            while (y4 <= 130) {
                if(y1 <= 130) {
                    y1 += Speed;
                }
                if (y2 <= 130) {
                    y2+= Speed;
                }
                if (yellowRelease) {
                    y3+= Speed;
                }
                if (blueRelease) {
                    y4 += Speed;
                }
                
                if(y1 <= 130 && !greenPress) {
                    uLCD.filled_circle(10,y1, 8 , GREEN);
                }
                if (y2 <= 130 && !redPress ) {
                    uLCD.filled_circle(45,y2, 8 , RED);
                    redRelease = true;
                }
                if ((y2 >= 60 && y3 <= 130) && !yellowPress) {
                    uLCD.filled_circle(80,y3, 8 , YELLOW);
                    yellowRelease = true;
                }
                if((y2 >= 60 && y4 <= 130) && !bluePress) {
                    uLCD.filled_circle(115,y4, 8 , BLUE);
                    blueRelease = true;
                }
                Thread::wait(250);
                uLCD.filled_circle(10, y1, 8 , BLACK);
                uLCD.filled_circle(45, y2, 8 , BLACK);
                uLCD.filled_circle(80, y3, 8 , BLACK);
                uLCD.filled_circle(115, y4, 8 , BLACK);
                
                if (y1 == 110 && greenPress) {
                    //uLCD.filled_circle(10, y1, 8 , WHITE);
                    uLCD.circle(10,110, 8, GREEN);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(10, y1, 8 , BLACK);
                    uLCD.circle(10,110, 8, GREEN);
                }
                if (y2 == 110 && redPress) {
                    //uLCD.filled_circle(45, y2, 8 , WHITE);
                    uLCD.circle(45,110, 8, RED);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(45, y2, 8 , BLACK);
                    uLCD.circle(45,110, 8, RED);
                }
                if(y3 == 110 && yellowPress) {
                    uLCD.circle(80,110, 8, YELLOW);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(80, y3, 8 , BLACK);
                    uLCD.circle(80,110, 8, YELLOW);
                }
                if(y4 == 110 && bluePress) {
                    uLCD.circle(115,110, 8, BLUE);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(115, y4, 8 , BLACK);
                    uLCD.circle(115,110, 8, BLUE);
                }
            }
            
        case 3: //green and yellow then red and blue
            totalBubbles += 4;
            greenPress = false;
            redPress = false;
            yellowPress = false;
            bluePress = false;
            redRelease = false;
            yellowRelease = false;
            greenRelease = false;
            blueRelease = false;
            if (speed == Medium) {
                y1 = 5;
                y2 = 5;
                y3 = 5;
                y4 = 5;
            } else {
                y1 = 10;
                y2 = 10;
                y3 = 10;
                y4 = 10;
            }
            while (y4 <= 130) {
                if(y1 <= 130) {
                    y1 += Speed;
                }
                if (redRelease) {
                    y2+= Speed;
                }
                if (y3 <= 130) {
                    y3+= Speed;
                }
                if (blueRelease) {
                    y4 += Speed;
                }
                
                if(y1 <= 130 && !greenPress) {
                    uLCD.filled_circle(10,y1, 8 , GREEN);
                }
                if ((y1 >= 60 && y2 <= 130) && !redPress ) {
                    uLCD.filled_circle(45,y2, 8 , RED);
                    redRelease = true;
                }
                if (y3 <= 130 && !yellowPress) {
                    uLCD.filled_circle(80,y3, 8 , YELLOW);
                    yellowRelease = true;
                }
                if((y1 >= 60 && y4 <= 130) && !bluePress) {
                    uLCD.filled_circle(115,y4, 8 , BLUE);
                    blueRelease = true;
                }
                Thread::wait(250);
                uLCD.filled_circle(10, y1, 8 , BLACK);
                uLCD.filled_circle(45, y2, 8 , BLACK);
                uLCD.filled_circle(80, y3, 8 , BLACK);
                uLCD.filled_circle(115, y4, 8 , BLACK);
                
                if (y1 == 110 && greenPress) {
                    //uLCD.filled_circle(10, y1, 8 , WHITE);
                    uLCD.circle(10,110, 8, GREEN);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(10, y1, 8 , BLACK);
                    uLCD.circle(10,110, 8, GREEN);
                }
                if (y2 == 110 && redPress) {
                    //uLCD.filled_circle(45, y2, 8 , WHITE);
                    uLCD.circle(45,110, 8, RED);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(45, y2, 8 , BLACK);
                    uLCD.circle(45,110, 8, RED);
                }
                if(y3 == 110 && yellowPress) {
                    //uLCD.filled_circle(80, y3, 8 , WHITE);
                    uLCD.circle(80,110, 8, YELLOW);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(80, y3, 8 , BLACK);
                    uLCD.circle(80,110, 8, YELLOW);
                }
                if(y4 == 110 && bluePress) {
                    uLCD.circle(115,110, 8, BLUE);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(115, y4, 8 , BLACK);
                    uLCD.circle(115,110, 8, BLUE);
                }
            }
            
        case 4:
            totalBubbles += 4;
            greenPress = false;
            redPress = false;
            yellowPress = false;
            bluePress = false;
            redRelease = false;
            yellowRelease = false;
            greenRelease = false;
            blueRelease = false;
            if (speed == Medium) {
                y1 = 5;
                y2 = 5;
                y3 = 5;
                y4 = 5;
                scoreUp = 1000;
            } else {
                y1 = 10;
                y2 = 10;
                y3 = 10;
                y4 = 10;
                scoreUp = 1500;
            }
            while (y1 <= 130) {
                if(y4 <= 130) {
                    y4 += Speed;
                }
                if (yellowRelease) {
                    y3+= Speed;
                }
                if (redRelease) {
                    y2+= Speed;
                }
                if (greenRelease) {
                    y1 += Speed;
                }
                if(y4 <= 130 && !bluePress) {
                    uLCD.filled_circle(115,y4, 8 , BLUE);
                }
                if ((y4 >= 30 && y3 <= 130) && !yellowPress ) {
                    uLCD.filled_circle(80,y3, 8 , YELLOW);
                    yellowRelease = true;
                }
                if ((y3 >= 30 && y2 <= 130) && !redPress) {
                    uLCD.filled_circle(45,y2, 8 , RED);
                    redRelease = true;
                }
                if((y2 >= 30 && y1 <= 130) && !greenPress) {
                    uLCD.filled_circle(10,y1, 8 , GREEN);
                    greenRelease = true;
                }
                Thread::wait(250);
                uLCD.filled_circle(10, y1, 8 , BLACK);
                uLCD.filled_circle(45, y2, 8 , BLACK);
                uLCD.filled_circle(80, y3, 8 , BLACK);
                uLCD.filled_circle(115, y4, 8 , BLACK);
                
                if (y1 == 110 && greenPress) {
                    uLCD.circle(10,110, 8, GREEN);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(10, y1, 8 , BLACK);
                    uLCD.circle(10,110, 8, GREEN);
                }
                if (y2 == 110 && redPress) {
                    uLCD.circle(45,110, 8, RED);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(45, y2, 8 , BLACK);
                    uLCD.circle(45,110, 8, RED);
                }
                if(y3 == 110 && yellowPress) {
                    uLCD.circle(80,110, 8, YELLOW);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(80, y3, 8 , BLACK);
                    uLCD.circle(80,110, 8, YELLOW);
                }
                if(y4 == 110 && bluePress) {
                    uLCD.circle(115,110, 8, BLUE);
                    score += scoreUp;
                    hit++;
                } else {
                    uLCD.filled_circle(115, y4, 8 , BLACK);
                    uLCD.circle(115,110, 8, BLUE);
                }
            }
            sampletick.detach();
            i = 0;
            if (score> highScore) {
                highScore = score;
            }
            miss = totalBubbles - hit;
            Game_State = Game_Over;
            break;
    }
}


void easyMode()
{
    int pattern = 1;
    score = 0;
    hit = 0;
    totalBubbles = 0;
    uLCD.baudrate(BAUD_3000000); //jack up baud rate to max for fast display
    uLCD.background_color(BLACK);
    Thread::wait(1000);
        uLCD.circle(10,110, 8, GREEN);
        uLCD.circle(45,110, 8, RED);
        uLCD.circle(80,110, 8, YELLOW);
        uLCD.circle(115,110, 8, BLUE);
    switch (pattern) {
        case 1:
            totalBubbles += 3;
            greenPress = false;
            redPress = false;
            yellowPress = false;
            redRelease = false;
            yellowRelease = false;
            greenRelease = false;
            y1 = 10;
            y2 = 10;
            y3 = 10;
            while(y3 <= 130) {
                if(y1 <= 130) {
                    y1 += Speed;
                }
                if (redRelease) {
                    y2+= Speed;
                }
                if (yellowRelease) {
                    y3+= Speed;
                }
                
                if(y1 <= 130 && !greenPress) {
                    uLCD.filled_circle(10,y1, 8 , GREEN);
                }
                if ((y1 >= 40 && y2 <= 130) && !redPress ) {
                    uLCD.filled_circle(45,y2, 8 , RED);
                    redRelease = true;
                }
                if ((y2 >= 40 && y3 <= 130) && !yellowPress) {
                    uLCD.filled_circle(80,y3, 8 , YELLOW);
                    yellowRelease = true;
                }
                Thread::wait(250);
                uLCD.filled_circle(10, y1, 8 , BLACK);
                uLCD.filled_circle(45, y2, 8 , BLACK);
                uLCD.filled_circle(80, y3, 8 , BLACK);
                
                if (y1 == 110 && greenPress) {
                    uLCD.circle(10,110, 8, GREEN);
                    score += 500;
                    hit++;
                } else {
                    uLCD.filled_circle(10, y1, 8 , BLACK);
                    uLCD.circle(10,110, 8, GREEN);
                }
                if (y2 == 110 && redPress) {
                    uLCD.circle(45,110, 8, RED);
                    score += 500;
                    hit++;
                } else {
                    uLCD.filled_circle(45, y2, 8 , BLACK);
                    uLCD.circle(45,110, 8, RED);
                }
                if(y3 == 110 && yellowPress) {
                    uLCD.circle(80,110, 8, YELLOW);
                    score += 500;
                    hit++;
                } else {
                    uLCD.filled_circle(80, y3, 8 , BLACK);
                    uLCD.circle(80,110, 8, YELLOW);
                }
                
            }
            pattern = 4;
            
        case 4:
            totalBubbles += 3;
            greenPress = false;
            redPress = false;
            yellowPress = false;
            redRelease = false;
            yellowRelease = false;
            greenRelease = false;
            y1 = 10;
            y2 = 10;
            y3 = 10;
            while(y1 <= 130) {
                if(y3 <= 130) {
                    y3 += Speed;
                }
                if (redRelease) {
                    y2+= Speed;
                }
                if (greenRelease) {
                    y1+= Speed;
                }
                if (y3 <= 130 && !yellowPress) {
                    uLCD.filled_circle(80,y3, 8 , YELLOW);
                }
                if ((y3 >= 40 && y2 <= 130) && !redPress ) {
                    uLCD.filled_circle(45,y2, 8 , RED);
                    redRelease = true;
                }
                if ((y2 >= 40 && y1 <= 130) && !greenPress) {
                    uLCD.filled_circle(10,y1, 8 , GREEN);
                    greenRelease = true;
                }
                Thread::wait(250);
                uLCD.filled_circle(10, y1, 8 , BLACK);
                uLCD.filled_circle(45, y2, 8 , BLACK);
                uLCD.filled_circle(80, y3, 8 , BLACK);
                
                if (y3 == 110 && yellowPress) {
                    //uLCD.filled_circle(80, y1, 8 , BLACK);
                    uLCD.circle(80,110, 8, YELLOW);
                    score+=500;
                    hit++;
                } else {
                    uLCD.filled_circle(80, y3, 8 , BLACK);
                    uLCD.circle(80,110, 8, YELLOW);
                }
                if (y2 == 110 && redPress) {
                    uLCD.circle(45,110, 8, RED);
                    score += 500;
                    hit++;
                } else {
                    uLCD.filled_circle(45, y2, 8 , BLACK);
                    uLCD.circle(45,110, 8, RED);
                }
                if(y1 == 110 && greenPress) {
                    uLCD.circle(10,110, 8, GREEN);
                    score += 500;
                    hit++;
                } else {
                    uLCD.circle(10,110,8, GREEN);
                }
                
            }
            if (score > highScore) {
                highScore = score;
            }
            sampletick.detach();
            i = 0;
            miss = totalBubbles - hit;
            Game_State = Game_Over;
            break;
    }
}

void audio_sample ()
{
    speaker.write_u16(sound_data[i]);
    i++;
    if (i>= NUM_ELEMENTS) {
        i = 0;
        //sampletick.detach();
        //Game_State = Game_Over;
    }
}

void LCD(void const *args) {

    while(1) {
         switch (Game_State) {
            case Start_Game :
               if (draw_enable) {
                    lcd_mut.lock();
                        uLCD.cls();
                        //uLCD.printf("Start_Game");
                        if(Speed == Easy) {
                            easyMode();
                        } else {
                            otherMode(Speed);
                        }
                    lcd_mut.unlock();
                }
                break;
            case Game_Over :
               if (draw_enable) {
                    draw_enable = false;
                    lcd_mut.lock();
                        uLCD.cls();
                        uLCD.line(0, 0, 127, 0, RED);
                        uLCD.line(127, 0, 127, 127, BLUE);
                        uLCD.line(127, 127, 0, 127, GREEN);
                        uLCD.line(0, 127, 0, 0, YELLOW);
                        uLCD.text_width(1);
                        uLCD.text_height(2);
                        uLCD.text_string("Game Over",4,0,FONT_8X8, BLUE);
                      
                        uLCD.text_width(1);
                        uLCD.text_height(1);
                        uLCD.color(YELLOW);
                        uLCD.locate(2,3);
                        uLCD.printf("Score:%d", score);

                        uLCD.color(GREEN);
                        uLCD.locate(2,5);
                        uLCD.printf("Hits:%d", hit);

                        uLCD.color(RED);
                        uLCD.locate(2,7);
                        uLCD.printf("Misses:%d", miss);
                        uLCD.text_height(2);

                        uLCD.color(WHITE);
                        uLCD.text_underline(ON);
                       uLCD.text_string("High Score",4,5,FONT_8X8, WHITE);
                        uLCD.text_underline(OFF);
                        uLCD.text_height(1);
                        uLCD.locate(4,13);
                        uLCD.text_height(2);
                        uLCD.printf("%d", highScore);
                        uLCD.text_height(1);
                        
                    lcd_mut.unlock();
                }
                break;
            case Choose_Song :
               if (draw_enable) {
                    draw_enable = false;
                    lcd_mut.lock();
                        uLCD.cls();
                        uLCD.text_width(1);
                        uLCD.text_height(1);
                        uLCD.locate(1,1);
                        uLCD.color(BLUE);
                        uLCD.text_underline(ON);
                        uLCD.text_string("Choose Song",4,1,FONT_8X8, BLUE);
                        uLCD.text_underline(OFF);
                        uLCD.set_font(FONT_7X8);
                        uLCD.triangle(64, 32,58, 40, 70, 40,  WHITE);
                        uLCD.triangle(64, 92 ,58, 84, 70, 84,  WHITE);
                        uLCD.color(GREEN);
                        uLCD.rectangle(10,44,118, 80, LGREY);
                        uLCD.text_width(2);
                        uLCD.text_height(2);
                        uLCD.text_string("Schools\nOut",1,3,FONT_8X8, GREEN);
                        uLCD.text_width(1);
                        uLCD.text_height(1);
                    lcd_mut.unlock();
                }
                break;
            case Choose_Difficulty :
               if (draw_enable) {
                    draw_enable = false;
                    lcd_mut.lock();
                        uLCD.cls();
                        uLCD.text_width(1.5);
                        uLCD.text_height(1.5);
                        uLCD.locate(1,1);
                        uLCD.color(BLUE);
                        uLCD.text_underline(ON);
                        uLCD.text_string("Choose Difficulty",1,1,FONT_8X8, BLUE);
                        uLCD.text_underline(OFF);
                        uLCD.set_font(FONT_7X8);
                        uLCD.text_width(2);
                        uLCD.text_height(2);
                        uLCD.color(GREEN);
                        uLCD.locate(1,2);
                        uLCD.printf("1|EASY");
                        uLCD.locate(1,4);
                        uLCD.color(YELLOW);
                        
                        uLCD.printf("2|MEDIUM");
                        uLCD.locate(1,6);
                        uLCD.color(RED);
                        uLCD.printf("3|HARD");
                        uLCD.text_width(1);
                        uLCD.text_height(1);
                    lcd_mut.unlock();
                }
                break;
            case Main_Menu :
               if (draw_enable) {
                    draw_enable = false;
                    lcd_mut.lock();
                        uLCD.cls();
                        uLCD.line(0, 0, 127, 0, RED);
                        uLCD.line(127, 0, 127, 127, BLUE);
                        uLCD.line(127, 127, 0, 127, GREEN);
                        uLCD.line(0, 127, 0, 0, YELLOW);
                        uLCD.text_width(2);
                        uLCD.text_height(2);
                        uLCD.locate(2,2);
                        uLCD.color(RED);
                        uLCD.printf("Guitar");
                        uLCD.color(BLUE);
                        uLCD.locate(3,4);
                        uLCD.printf("Hero");
                        
                        uLCD.text_width(1);
                        uLCD.text_height(1);
                        uLCD.locate(3,12);
                        uLCD.color(GREEN);
                        uLCD.printf("Press to start");
                        
                    lcd_mut.unlock();
                }
                break;
            default:
                break;
        } 
        Thread::wait(10);   
    }  
}
void lights(void const *args) {
    while(1) {
        switch (Game_State) {
            case Start_Game :
                myled1 = 0;
                myled2 = 0;
                myled3 = 0;
                myled4 = 1;
                break;
            case Game_Over :
               myled1 = 1;
                myled2 = 1;
                myled3 = 1;
                myled4 = 1;
                break;
            case Choose_Song :
                myled1 = 0;
                myled2 = 0;
                myled3 = 1;
                myled4 = 0;
                break;
            case Choose_Difficulty :
               
                myled1 = 0;
                myled2 = 1;
                myled3 = 0;
                myled4 = 0;
                    
                
                break;
            case Main_Menu :
               
                myled1 = 1;
                myled2 = 0;
                myled3 = 0;
                myled4 = 0;
                
                break;
            default:
                break;
        } 
        Thread::wait(500);
    }    
}

void startGame() {
    Game_State = Start_Game;
    sampletick.attach(&audio_sample, 1.0 / sample_freq);
}

void pb_1_pressed(void) {
    switch (Game_State) {
            case Start_Game :
                draw_enable = true;
                if(y1 == 110) {
                    if (joy.yAxis() > 0.05 || joy.yAxis() < -0.05) {
                        greenPress = true;
                    }
                }
                break;
            case Game_Over :
               draw_enable = true;
                Game_State = Main_Menu;
                break;
            case Choose_Song :
                draw_enable = true;
                startGame();
                break;
            case Choose_Difficulty :
               
                draw_enable = true;
                Game_State = Choose_Song;
                Speed = Easy;    
                
                break;
            case Main_Menu :
               
                draw_enable = true;
                Game_State = Choose_Difficulty;
                
                break;
            default:
                break;
        } 
}
void pb_2_pressed(void) {
        switch (Game_State) {
            case Start_Game :
                draw_enable = true;
                if(y2 == 110) {
                    if (joy.yAxis() > 0.05 || joy.yAxis() < -0.05) {
                        redPress = true;
                    }
                }
                break;
            case Game_Over :
               draw_enable = true;
                Game_State = Main_Menu;
                break;
            case Choose_Song :
                draw_enable = true;
                startGame();
                break;
            case Choose_Difficulty :
               
                draw_enable = true;
                Game_State = Choose_Song;
                Speed = Medium;
                break;
            case Main_Menu :
               
                draw_enable = true;
                Game_State = Choose_Difficulty;
                
                break;
            default:
                break;
        } 
        
}
void pb_3_pressed(void) {
        switch (Game_State) {
            case Start_Game :
                draw_enable = true;
                if(y3 == 110) {
                    if (joy.yAxis() > 0.05 || joy.yAxis() < -0.05) {
                        yellowPress = true;
                    }
                }
                break;
            case Game_Over :
               draw_enable = true;
                Game_State = Main_Menu;
                break;
            case Choose_Song :
                draw_enable = true;
                startGame();
                break;
            case Choose_Difficulty :
               
                draw_enable = true;
                Game_State = Choose_Song;
                Speed = Hard;
                
                break;
            case Main_Menu :
               
                draw_enable = true;
                Game_State = Choose_Difficulty;
                
                break;
            default:
                break;
        } 
}
void pb_4_pressed(void) {
        switch (Game_State) {
            case Start_Game :
                draw_enable = true;
                if(y4 == 110) {
                    if (joy.yAxis() > 0.05 || joy.yAxis() < -0.05) {
                        bluePress = true;
                    }
                }
                break;
            case Game_Over :
               draw_enable = true;
                Game_State = Main_Menu;
                break;
            case Choose_Song :
                draw_enable = true;
                startGame();
                break;
            case Choose_Difficulty :
                //not used
                break;
            case Main_Menu :
               
                draw_enable = true;
                Game_State = Choose_Difficulty;
                
                break;
            default:
                break;
        } 
}
        
int main()
{
    speaker.write_u16(0);
    pb_1.attach_deasserted( &pb_1_pressed );
    pb_2.attach_deasserted( &pb_2_pressed );
    pb_3.attach_deasserted( &pb_3_pressed );
    pb_4.attach_deasserted( &pb_4_pressed );
    pb_1.setSampleFrequency();
    pb_2.setSampleFrequency();
    pb_3.setSampleFrequency();
    pb_4.setSampleFrequency();
    lcd_mut.lock();
    uLCD.cls();
    uLCD.printf("starting...");
    uLCD.background_color(BLACK);
    uLCD.baudrate(3000000);
    lcd_mut.unlock();
    Thread::wait(1000);
    Thread Thread1(LCD);
    Thread Thread2(lights);

    
    while(1) {
        Thread::wait(1000);
    }
    
}
