#include "mbed.h"
#include "BLEDevice.h"
#include "DeviceInformationService.h"

#define TINYBLE true
#define SEEEDARCH false

#if TINYBLE
int ledOn = 0;
int ledOff = 1;

InterruptIn button1(P0_17);
DigitalOut ledRed(P0_22);
DigitalOut ledGreen(P0_21);
DigitalOut ledBlue(P0_23);
#endif

#if SEEEDARCH
int ledOn = 1;
int ledOff = 0;

InterruptIn button1(P0_17);
InterruptIn mysw1(P0_18);
DigitalOut ledRed(P0_12);
DigitalOut ledGreen(P0_15);
DigitalOut ledBlue(P0_16);
#endif

Serial pc(USBTX,USBRX);
int flag = false;

void handle_button1() {
    printf("button!\r\n");
    flag = !flag;
    }


void ledflasher() {
        ledGreen = ledOn;
        wait(0.3);
        ledGreen = ledOff;
        ledRed = ledOn;
        wait(0.3);
        ledRed = ledOff;
        ledBlue = ledOn;
        wait(0.4);   
        ledBlue = ledOff; 
    }

int main() {
    // Initialize button1 and pull up
    // set interrupt callback for button1    
    button1.fall(&handle_button1);
    button1.mode(PullUp);
    ledGreen = ledOff;
    ledRed = ledOff;
    ledBlue = ledOff;

    while(1) {
        if (flag) {
            ledflasher();
        }
        wait(0.2);
    }
    
    
    
}