#ifndef SEQUENCER_H
#define SEQUENCER_H

#define NUMBER_OF_PANELS (CHANNELS_PER_IC*NUMBER_OF_ICS)
#define CLOCK_GRANULARITY 25

#define EYES 14
#define BEAK 47
#define INTERNAL1 12
#define INTERNAL2 46

#define ROWS 5
#define COLUMNS 6

typedef enum UserModes {
    TEST=0,
    DEFAULT,
    SUN,
    USER_MOVEMENT,
    USER_BASE,
    USER_MOVEMENT_AND_BASE
} UserModes;


typedef enum MovementModes {
    VERTICAL_UP,
    VERTICAL_DOWN,
    HORIZONTAL_FORWARD,
    HORIZONTAL_BACKWARDS,
    RADIAL_CLOCKWISE,
    RADIAL_COUNTERCLOCKWISE,
    BARREL_CLOCKWISE,
    BARREL_COUNTERCLOCKWISE,
    ALL,
    OFF
} MovementModes;

typedef enum DitherMode {
    FADE_IN,
    FADE_OUT_AND_IN,
    FADE_IN_AND_OUT,
    FIXED,
    CROSSFADE,
    PULSED_INTENSITY,
    OVERSHOOT
} DitherMode;

typedef enum MovementFills {
    LINE,
    BAND,
    FILL
} MovementFills;

typedef enum EffectTypes {
    CONSTANT,
    RANDOM,  // parameter is longest time between updates
    SEQUENCE, // parameter is time step between updates
    FIXED_RANDOM, // no parameter
    RANDOM_STROBE // parameter is longest time between strobes
} EffectTypes;

void setOverlayEffect( int movementMode, int ditherMode, int movementFill, int effectType, const int* colorList, int timeConstant, int moveTimeConstant );
void setBaseEffect( int ditherMode, int effectType, const int* colorList, int timeConstant );

int movementToEnum(char* input);
int ditherToEnum(char* input);
int fillToEnum(char* input);
int effectToEnum(char* input);
const int* colorListToPointer(char* input);


#endif // SEQUENCER_H