#include "mbed.h"
#include <qrsdet.h>
// Use a ticker (interrupt routine) to sample the ADC at a fast rate (is 200Khz the max?), and generate an average value
// Use another ticker to grab the average value at 1Khz, which is the maximum useful sampling rate for HRV data collection


// These need to divide evenly into each other

// 3 means sample at 8x read-out rate - SAMPLE_RATE is defined in qrsdet.h
#define SHIFT_FOR_READ_OUT 1
#define ADC_RATE (SAMPLE_RATE<<SHIFT_FOR_READ_OUT)  
#define READ_OUT_RATE_HZ SAMPLE_RATE 

#define SAMPLES_PER_READOUT (1<<SHIFT_FOR_READ_OUT)

AnalogIn ECG(P0_1);  
Ticker sampling_rate;
int NumReadings=0;
int32_t ReadingTotal=0;
void (*SamplingFunction)(uint32_t);


void ADC_read()
{    
    NumReadings++;
    ReadingTotal += ECG.read_u16();    
    if (NumReadings == SAMPLES_PER_READOUT) 
    {
        SamplingFunction(ReadingTotal>>SHIFT_FOR_READ_OUT); 
        ReadingTotal = 0;
        NumReadings = 0;
    }                                                                                                 
}

void setup_sampler(void (*function)(uint32_t)) 
{
    SamplingFunction = function;
    sampling_rate.attach(&ADC_read, 1.0/ADC_RATE);
}
