/******************************************************************************
 * Haptics.c
 *
 * Created on: Dec 16, 2011
 * Board: DRV2603EVM-CT RevD
 * Author: a0866685
 *
 * Description: This file contains the functions for sending haptics waveforms.
 * 		Edit this file when changing actuators.
 *
 * @TODO - Update this file when changing between actuators types
 * 			(ERM, LRA, Piezo)
 *
 ******************************************************************************/

#ifndef HAPTICS_H_
#define HAPTICS_H_

#include "mbed.h"

//#include "msp430.h"
//#include "CTS/structure.h"
//#include "timer.h"

#define LRA_MODE_OFF 0
#define LRA_MODE_WAVEFORM 1
#define LRA_MODE_DELAYED_WAVEFORM 2
#define LRA_MODE_RAMP_TO_TARGET 3

#define DELAY 		250
#define DUMBTICK  	LRAFREQ_185	// Select the LRA resonant frequency for "dumb" (auto-resonance off) mode

// LRA Resonant Frequencies (see DUMBTICK above)
#define LRAFREQ_220	18182	// 220Hz
#define LRAFREQ_215	18605	// 215Hz
#define LRAFREQ_210	19048 	// 210Hz
#define LRAFREQ_205	19512 	// 205Hz
#define LRAFREQ_200 20000	// 200Hz
#define LRAFREQ_195 20513   // 195Hz
#define LRAFREQ_190 21052	// 190Hz
#define LRAFREQ_185	21621	// 185Hz
#define LRAFREQ_180	22222 	// 180Hz
#define LRAFREQ_175	22857	// 175Hz
#define LRAFREQ_170	23529	// 170Hz
#define LRAFREQ_165 24242	// 165Hz
#define LRAFREQ_160 25000	// 160Hz
#define LRAFREQ_155 15806	// 155Hz
#define LRAFREQ_150	26667	// 150Hz
#define LRAFREQ_145	27586	// 145Hz

// PWM output modes
#define LRA_AUTOON 		0		// LRA Auto-resonance on
#define LRA_AUTOOFF		1		// LRA Auto-resonance off
#define ERM 			2		// ERM Output Mode

extern uint16_t Haptics_dumbModeTick;		// Sets the LRA Auto-resonance off frequency (use DUMBTICK above to set frequency)
extern uint16_t Haptics_resonantModeTick;

// Waveform Structure Type Definition
typedef struct Haptics_Waveform {
	const unsigned char 	outputMode; 		// ERM, LRA_AUTOON, or LRA_AUTOOFF (see output modes above)
	const unsigned char		length;				// size of array in bytes
	const unsigned char* volatile data;				// pointer to waveform array data (waveform array is in (amplitude, time) pairs
} Waveform;

/**
 * Haptics_Init - initialize haptics variables and settings
 */
void Haptics_Init(void);

/**
 * Haptics_OutputWaveform - control the PWM output pattern
 * @param struct Waveform - the waveform output type, length in bytes, and data
 * @TODO - Modify this function to change actuator types (ERM, LRA, Piezo)
 */

void Haptics_OutputWaveform(const Waveform* waveform);
void Haptics_OverrideOutputWaveform(const Waveform* newWaveform);
void Haptics_OutputCount(uint16_t count);
void Haptics_SetHeartbeatWaveform (int waveformNum);
void Haptics_OutputDelayedHeartbeat(uint16_t delay);
void Haptics_OutputDelayedWaveform(const Waveform* newWaveform, uint16_t delay);
void Haptics_SetRampTarget(float amplitude);
void Haptics_Off();
bool isHapticsOff();

void LeavingOffModeHapticResponse(int ledFinalState);
void EnteringOffModeHapticResponse();

#endif /* HAPTICS_H_ */
