/* Example file of using SD/MMC Block device Library for MBED-OS
 * Copyright 2017 Roy Krikke
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include "mbed.h"
#include "SDBlockDeviceDISCOF746NG.h"

DigitalOut led (LED1);

// Instantiate the Block Device for sd card on DISCO-F746NG
SDBlockDeviceDISCOF746NG bd;
uint8_t block[512] = "Hello World!\n";

int
main ()
{
    Serial pc (SERIAL_TX, SERIAL_RX);
    pc.baud(115200);
    printf("Start\n");

    // Call the SDBlockDeviceDISCOF746NG instance initialisation method.
    printf("sd card init...\n");
    if (0 != bd.init()) {
        printf("Init failed \n");
        return -1;
    }

    printf("sd size: %llu\n", bd.size());
    printf("sd read size: %llu\n", bd.get_read_size());
    printf("sd program size: %llu\n", bd.get_program_size());
    printf("sd erase size: %llu\n\n", bd.get_erase_size());

    printf("sd erase...\n");
    if (0 != bd.erase (0, bd.get_erase_size())) {
        printf("Error Erasing block \n");
    }

    // Write some the data block to the device
    printf("sd write: %s\n", block);
    if (0 == bd.program(block, 0, 512)) {
        // read the data block from the device
        printf("sd read: ");
        if (0 == bd.read(block, 0, 512)) {
            // print the contents of the block
            printf("%s", block);
        }
    }

////////////////////////////////////////////////////////////////////////////////

    for(int i; i < 10; i++) {
        memset(block, i, sizeof(block));
        if(bd.program(block, (i*512), sizeof(block)) != 0) {
            printf("Error at: %i\r\n",i);
        }
    }

    if(bd.erase((1*512), sizeof(block)) != 0) {
        printf("Error Erasing block\n");
    }

    memset(block, 'x', sizeof(block));
    if(bd.program(block, (1*512), sizeof(block)) != 0) {
        printf("Error\r\n");
    }

////////////////////////////////////////////////////////////////////////////////

    // Call the BD_SD_DISCO_F746NG instance de-initialisation method.
    printf("sd card deinit...\n");
    if (0 != bd.deinit()) {
        printf ("Deinit failed \n");
        return -1;
    }

    // Blink led with 2 Hz
    while(true) {
        led = !led;
        wait (0.5);
    }
}
