//------------------------------------CP/M on MBED-----------------------------------
// Emulate an 8080 and run CP/M v2.0 from a disk image saved on local storage.
//
// Inspired by excellent CP/M-on-AVR by Sprite_tm : http://spritesmods.com/?art=avrcpm
// and by 
//
// Basically a C reworking of Sprite's AVR machinecode.

#include "mbed.h"

void do_op_00(); void do_op_01(); void do_op_02(); void do_op_03(); void do_op_04(); void do_op_05(); void do_op_06(); void do_op_07(); 
void do_op_08(); void do_op_09(); void do_op_0A(); void do_op_0B(); void do_op_0C(); void do_op_0D(); void do_op_0E(); void do_op_0F(); 
void do_op_10(); void do_op_11(); void do_op_12(); void do_op_13(); void do_op_14(); void do_op_15(); void do_op_16(); void do_op_17(); 
void do_op_18(); void do_op_19(); void do_op_1A(); void do_op_1B(); void do_op_1C(); void do_op_1D(); void do_op_1E(); void do_op_1F(); 
void do_op_20(); void do_op_21(); void do_op_22(); void do_op_23(); void do_op_24(); void do_op_25(); void do_op_26(); void do_op_27(); 
void do_op_28(); void do_op_29(); void do_op_2A(); void do_op_2B(); void do_op_2C(); void do_op_2D(); void do_op_2E(); void do_op_2F(); 
void do_op_30(); void do_op_31(); void do_op_32(); void do_op_33(); void do_op_34(); void do_op_35(); void do_op_36(); void do_op_37(); 
void do_op_38(); void do_op_39(); void do_op_3A(); void do_op_3B(); void do_op_3C(); void do_op_3D(); void do_op_3E(); void do_op_3F(); 
void do_op_40(); void do_op_41(); void do_op_42(); void do_op_43(); void do_op_44(); void do_op_45(); void do_op_46(); void do_op_47(); 
void do_op_48(); void do_op_49(); void do_op_4A(); void do_op_4B(); void do_op_4C(); void do_op_4D(); void do_op_4E(); void do_op_4F(); 
void do_op_50(); void do_op_51(); void do_op_52(); void do_op_53(); void do_op_54(); void do_op_55(); void do_op_56(); void do_op_57(); 
void do_op_58(); void do_op_59(); void do_op_5A(); void do_op_5B(); void do_op_5C(); void do_op_5D(); void do_op_5E(); void do_op_5F(); 
void do_op_60(); void do_op_61(); void do_op_62(); void do_op_63(); void do_op_64(); void do_op_65(); void do_op_66(); void do_op_67(); 
void do_op_68(); void do_op_69(); void do_op_6A(); void do_op_6B(); void do_op_6C(); void do_op_6D(); void do_op_6E(); void do_op_6F(); 
void do_op_70(); void do_op_71(); void do_op_72(); void do_op_73(); void do_op_74(); void do_op_75(); void do_op_76(); void do_op_77(); 
void do_op_78(); void do_op_79(); void do_op_7A(); void do_op_7B(); void do_op_7C(); void do_op_7D(); void do_op_7E(); void do_op_7F(); 
void do_op_80(); void do_op_81(); void do_op_82(); void do_op_83(); void do_op_84(); void do_op_85(); void do_op_86(); void do_op_87(); 
void do_op_88(); void do_op_89(); void do_op_8A(); void do_op_8B(); void do_op_8C(); void do_op_8D(); void do_op_8E(); void do_op_8F(); 
void do_op_90(); void do_op_91(); void do_op_92(); void do_op_93(); void do_op_94(); void do_op_95(); void do_op_96(); void do_op_97(); 
void do_op_98(); void do_op_99(); void do_op_9A(); void do_op_9B(); void do_op_9C(); void do_op_9D(); void do_op_9E(); void do_op_9F(); 
void do_op_A0(); void do_op_A1(); void do_op_A2(); void do_op_A3(); void do_op_A4(); void do_op_A5(); void do_op_A6(); void do_op_A7(); 
void do_op_A8(); void do_op_A9(); void do_op_AA(); void do_op_AB(); void do_op_AC(); void do_op_AD(); void do_op_AE(); void do_op_AF(); 
void do_op_B0(); void do_op_B1(); void do_op_B2(); void do_op_B3(); void do_op_B4(); void do_op_B5(); void do_op_B6(); void do_op_B7(); 
void do_op_B8(); void do_op_B9(); void do_op_BA(); void do_op_BB(); void do_op_BC(); void do_op_BD(); void do_op_BE(); void do_op_BF(); 
void do_op_C0(); void do_op_C1(); void do_op_C2(); void do_op_C3(); void do_op_C4(); void do_op_C5(); void do_op_C6(); void do_op_C7(); 
void do_op_C8(); void do_op_C9(); void do_op_CA(); void do_op_CB(); void do_op_CC(); void do_op_CD(); void do_op_CE(); void do_op_CF(); 
void do_op_D0(); void do_op_D1(); void do_op_D2(); void do_op_D3(); void do_op_D4(); void do_op_D5(); void do_op_D6(); void do_op_D7(); 
void do_op_D8(); void do_op_D9(); void do_op_DA(); void do_op_DB(); void do_op_DC(); void do_op_DD(); void do_op_DE(); void do_op_DF(); 
void do_op_E0(); void do_op_E1(); void do_op_E2(); void do_op_E3(); void do_op_E4(); void do_op_E5(); void do_op_E6(); void do_op_E7(); 
void do_op_E8(); void do_op_E9(); void do_op_EA(); void do_op_EB(); void do_op_EC(); void do_op_ED(); void do_op_EE(); void do_op_EF(); 
void do_op_F0(); void do_op_F1(); void do_op_F2(); void do_op_F3(); void do_op_F4(); void do_op_F5(); void do_op_F6(); void do_op_F7(); 
void do_op_F8(); void do_op_F9(); void do_op_FA(); void do_op_FB(); void do_op_FC(); void do_op_FD(); void do_op_FE(); void do_op_FF();    

typedef void (*ptr2function)(void);

const ptr2function function[] = { 
&do_op_00,&do_op_01,&do_op_02,&do_op_03,&do_op_04,&do_op_05,&do_op_06,&do_op_07,
&do_op_08,&do_op_09,&do_op_0A,&do_op_0B,&do_op_0C,&do_op_0D,&do_op_0E,&do_op_0F,
&do_op_10,&do_op_11,&do_op_12,&do_op_13,&do_op_14,&do_op_15,&do_op_16,&do_op_17,
&do_op_18,&do_op_19,&do_op_1A,&do_op_1B,&do_op_1C,&do_op_1D,&do_op_1E,&do_op_1F,
&do_op_20,&do_op_21,&do_op_22,&do_op_23,&do_op_24,&do_op_25,&do_op_26,&do_op_27,
&do_op_28,&do_op_29,&do_op_2A,&do_op_2B,&do_op_2C,&do_op_2D,&do_op_2E,&do_op_2F,
&do_op_30,&do_op_31,&do_op_32,&do_op_33,&do_op_34,&do_op_35,&do_op_36,&do_op_37,
&do_op_38,&do_op_39,&do_op_3A,&do_op_3B,&do_op_3C,&do_op_3D,&do_op_3E,&do_op_3F,
&do_op_40,&do_op_41,&do_op_42,&do_op_43,&do_op_44,&do_op_45,&do_op_46,&do_op_47,
&do_op_48,&do_op_49,&do_op_4A,&do_op_4B,&do_op_4C,&do_op_4D,&do_op_4E,&do_op_4F,
&do_op_50,&do_op_51,&do_op_52,&do_op_53,&do_op_54,&do_op_55,&do_op_56,&do_op_57,
&do_op_58,&do_op_59,&do_op_5A,&do_op_5B,&do_op_5C,&do_op_5D,&do_op_5E,&do_op_5F,
&do_op_60,&do_op_61,&do_op_62,&do_op_63,&do_op_64,&do_op_65,&do_op_66,&do_op_67,
&do_op_68,&do_op_69,&do_op_6A,&do_op_6B,&do_op_6C,&do_op_6D,&do_op_6E,&do_op_6F,
&do_op_70,&do_op_71,&do_op_72,&do_op_73,&do_op_74,&do_op_75,&do_op_76,&do_op_77,
&do_op_78,&do_op_79,&do_op_7A,&do_op_7B,&do_op_7C,&do_op_7D,&do_op_7E,&do_op_7F,
&do_op_80,&do_op_81,&do_op_82,&do_op_83,&do_op_84,&do_op_85,&do_op_86,&do_op_87,
&do_op_88,&do_op_89,&do_op_8A,&do_op_8B,&do_op_8C,&do_op_8D,&do_op_8E,&do_op_8F,
&do_op_90,&do_op_91,&do_op_92,&do_op_93,&do_op_94,&do_op_95,&do_op_96,&do_op_97,
&do_op_98,&do_op_99,&do_op_9A,&do_op_9B,&do_op_9C,&do_op_9D,&do_op_9E,&do_op_9F,
&do_op_A0,&do_op_A1,&do_op_A2,&do_op_A3,&do_op_A4,&do_op_A5,&do_op_A6,&do_op_A7,
&do_op_A8,&do_op_A9,&do_op_AA,&do_op_AB,&do_op_AC,&do_op_AD,&do_op_AE,&do_op_AF,
&do_op_B0,&do_op_B1,&do_op_B2,&do_op_B3,&do_op_B4,&do_op_B5,&do_op_B6,&do_op_B7,
&do_op_B8,&do_op_B9,&do_op_BA,&do_op_BB,&do_op_BC,&do_op_BD,&do_op_BE,&do_op_BF,
&do_op_C0,&do_op_C1,&do_op_C2,&do_op_C3,&do_op_C4,&do_op_C5,&do_op_C6,&do_op_C7,
&do_op_C8,&do_op_C9,&do_op_CA,&do_op_CB,&do_op_CC,&do_op_CD,&do_op_CE,&do_op_CF,
&do_op_D0,&do_op_D1,&do_op_D2,&do_op_D3,&do_op_D4,&do_op_D5,&do_op_D6,&do_op_D7,
&do_op_D8,&do_op_D9,&do_op_DA,&do_op_DB,&do_op_DC,&do_op_DD,&do_op_DE,&do_op_DF,
&do_op_E0,&do_op_E1,&do_op_E2,&do_op_E3,&do_op_E4,&do_op_E5,&do_op_E6,&do_op_E7,
&do_op_E8,&do_op_E9,&do_op_EA,&do_op_EB,&do_op_EC,&do_op_ED,&do_op_EE,&do_op_EF,
&do_op_F0,&do_op_F1,&do_op_F2,&do_op_F3,&do_op_F4,&do_op_F5,&do_op_F6,&do_op_F7,
&do_op_F8,&do_op_F9,&do_op_FA,&do_op_FB,&do_op_FC,&do_op_FD,&do_op_FE,&do_op_FF } ;

char rA;                        // 8080 registers
char rB;
char rC;
char rD;
char rE;
char rH;
char rL;
char rSPH;                      // stack pointer (stack grows down in memory)
char rSPL;
char rPCH;                      // Program counter
char rPCL;

int pc;                         // 16 bit versions of pc/sp for convienience.
int sp;

//Flag bits in rF
#define FL_S 7
#define FL_Z 6
#define FL_H 4
#define FL_P 2
#define FL_N 1
#define FL_C 0
char rF;                        // Status flags

char oph;                       // operating registers when decoding instruction
char opl;
int op;                         // 16 bit version used for 16 bit arithmetic and setting status bits.

char temp;

bool nostore;                   // true if we need to skip the store phase (for conditional instructions).

char RAM[20*1024];

int track;
int sector;
int dma;                        // DMA address for disk read/write

Serial      serial(USBTX, USBRX);   // tx, rx
LocalFileSystem local("local");     // access to local file system.

void clear(char bit) {
    rF=rF&((0xFEF<<bit)>>8);
    }
    
void set(char bit) {
    rF = rF|(0x01<<bit);
    }
    
void set_flags(int result, char bits) {
    int mask = 0xff;
    char b = 1;
    if (bits==16) mask = 0xffff;
    rF = 0x00;
    if ((result>>bits)&0x01) set(FL_C);     // Carry flag = bit 8 or bit 16, depending.
    if ((result>>3)&0x01)    set(FL_H);     // half-carry = bit 3
    if ((result&mask)==0)    set(FL_Z);     // Zero flag
    for(int i=0; i<bits; i++) if ((result>>i)&0x01) b++; if (b&0x01) set(FL_P);  // Set Parity if num of ones is EVEN
    if ((result>>(bits-1))&0x01) set(FL_S); // Sign flag = bit 7 or 15
    }
    
void sync_rpc() {               // make rPCL and rPCH match PC
    rPCL = (char)(pc&0xff);
    rPCH = (char)((pc>>8)&0xff);
    }

void sync_rsp() {               // make rSPL and rSPH match SP
    rSPL = (char)(sp&0xff);
    rSPH = (char)((sp>>8)&0xff);
    }
    
void sync_op() {
    opl = (char)(op&0xff);
    oph = (char)((op>>8)&0xff);
    }
        
void push(char h, char l) {     // push 16 bits
    RAM[--sp] = h;
    RAM[--sp] = l;
    sync_rsp();
    }
    
int pop() {                   // pop 16 bits.
    int r;
    r = RAM[sp++];
    r = r + RAM[sp++]<<8;
    sync_rsp();
    return r;
    }
    
void read_sector(char *buffer, int t, int s) { // read 128 bytes from track/sector to buffer. 26 sectors to a track.
    FILE *fp = fopen("/local/cpm_disk", "r");
    fseek( fp, (26*t+s)*128, SEEK_SET );
    fread( buffer, sizeof(char), 128, fp );
    fclose(fp);
    }

void write_sector(char *buffer, int t, int s) { // write 128 bytes from buffer to sector.
    FILE *fp = fopen("/local/cpm_disk", "w");
    fseek( fp, (26*t+s)*128, SEEK_SET );
    fwrite( buffer, sizeof(int), 128, fp );
    fclose(fp);
    }

//=================================================================================        
// BIOS routines.
// HW accessed via IN / OUT instructions.
//   
// The hw is modelled to make writing a CPM BIOS easier.
// Ports:
// 0 - Con status. Returns 0xFF if the UART has a byte, 0 otherwise.
// 1 - Console input, aka UDR.
// 2 - Console output
// 16 - Track select
// 18 - Sector select (26 sectors to a track)
// 20 - Write addr l
// 21 - Write addr h
// 22 - Trigger - write 1 to read, 2 to write a sector using the above info.
// 	This will automatically move track, sector and dma addr to the next sector.    

void out_command(char p) {
    switch(p) {
        case (2)  : 
            serial.putc(rA);
            break;
        case (16) : 
            track = rA;
            break;
        case (18) : 
            sector = rA;
            break;
        case (20) : 
            dma = (dma&0xff00)|rA;
            break;
        case (21) : 
            dma = (dma&0x00ff)|(rA<<8); 
            break;
        case (22) : 
            switch(rA) {
                case(1) :  
                    read_sector(&RAM[dma],track, sector); 
                    break;
                case(2) : 
                    write_sector(&RAM[dma],track, sector); 
                    break;
                }
            sector = (sector+1)%26; 
            if (sector==0) track++;         
            dma = dma+128;
            break;
            } 
    }

//=================================================================================        
// BIOS routines.
// HW accessed via IN / OUT instructions.
//   
// The hw is modelled to make writing a CPM BIOS easier.
// Ports:
// 0 - Con status. Returns 0xFF if the UART has a byte, 0 otherwise.
// 1 - Console input, aka UDR.
// 2 - Console output
// 16 - Track select
// 18 - Sector select (26 sectors to a track)
// 20 - Write addr l
// 21 - Write addr h
// 22 - Trigger - write 1 to read, 2 to write a sector using the above info.
// 	This will automatically move track, sector and dma addr to the next sector.    

char in_command(char p) {
    char r = 0;
    switch(p) {
        case(0) :
            if (serial.readable()) r = 0xff; else r = 0x00;
            break;
        case(1) :
            r = serial.getc();
            break;
        }       
    return r;
    }
    
//=================================================================================        
// MAIN.
// load IPL from sector 0 (128 bytes) to 0x2000 and execute.
//   
 
int main() {
    read_sector(&RAM[0x2000], 0, 0);   // read in first sector, contains IPL.
    pc = 0x2000;
    sync_rpc();
    while(1) {
        function[RAM[pc]]();   
        }
    }
    
//=================================================================================        
//  FETCH operations.
// fetch registers or memory contents into op registers ahead of an operation.    
    
void FETCH_NOP() {}

void FETCH_A() { opl = rA; }
void FETCH_B() { opl = rB; }
void FETCH_C() { opl = rC; }
void FETCH_D() { opl = rD; }
void FETCH_E() { opl = rE; }
void FETCH_H() { opl = rH; }
void FETCH_L() { opl = rL; }

void FETCH_AF() { opl = rF;   oph = rA; }  // Assumes flags are correct!!
void FETCH_BC() { opl = rC;   oph = rB; }
void FETCH_DE() { opl = rE;   oph = rD; }
void FETCH_HL() { opl = rL;   oph = rH; }
void FETCH_SP() { opl = rSPL; oph = rSPH; }

void FETCH_DIR8()  { opl = RAM[pc++];                     sync_rpc(); }
void FETCH_DIR16() { opl = RAM[pc++];    oph = RAM[pc++]; sync_rpc(); }
void FETCH_RST()   { opl = RAM[pc]&0x38; oph = 0;                     }

void FETCH_MBC() { opl = RAM[rB<<8+rC]; }
void FETCH_MDE() { opl = RAM[rD<<8+rE]; }
void FETCH_MHL() { opl = RAM[rH<<8+rL]; }
void FETCH_MSP() { opl = RAM[rSPH<<8+rSPL]; }

//=================================================================================        
// STORE operations.
// store op to registers or memory locations after operation.    
    
void STORE_NOP() {};

void STORE_A() { rA = opl; }
void STORE_B() { rB = opl; }
void STORE_C() { rC = opl; }
void STORE_D() { rD = opl; }
void STORE_E() { rE = opl; }
void STORE_H() { rH = opl; }
void STORE_L() { rL = opl; }

void STORE_AF() { rF = opl;     rA = oph; }  // Assumes flags are correct!!
void STORE_BC() { rC = opl;     rB = oph; }
void STORE_DE() { rE = opl;     rD = oph; }
void STORE_HL() { rL = opl;     rH = oph; }
void STORE_SP() { rSPL = opl;   rSPH = oph; }

void STORE_MBC() { RAM[rB<<8+rC] = opl; }
void STORE_MDE() { RAM[rD<<8+rE] = opl; }
void STORE_MHL() { RAM[rH<<8+rL] = opl; }

void STORE_AM()  { RAM[opl + oph<<8] = rA; }

void STORE_PC()  { rPCL = opl; rPCH = oph; pc = opl+(oph<<8); }
void STORE_CALL(){ sync_rpc(); push(rPCH, rPCL); rPCL = opl; rPCH = oph; pc = rPCH<<8 + rPCL; }
void STORE_RET() { pc = pop(); sync_rpc(); }
void STORE_MSP() { sp = (rSPH<<8)+rSPL; RAM[sp] = opl; RAM[sp+1] = oph; }

//=================================================================================        
// OPerations.
// store op to registers or memory locations after operation.    

void OP_NOP()   {}
void OP_INC()   { op = opl; op++; set_flags(op,8); sync_op(); }
void OP_DEC()   { op = opl; op--; set_flags(op,8); sync_op(); }
void OP_INC16() { op = opl + oph<<8; op++; sync_op(); }         // no flags
void OP_DEC16() { op = opl + oph<<8; op--; sync_op(); }         // no flags
void OP_RRC()   {            clear(FL_C); if (opl&0x01) set(FL_C); opl=(opl>>1); if ((rF>>FL_C)&0x01)   opl = opl|0x80; }
void OP_RLC()   {            clear(FL_C); if (opl&0x80) set(FL_C); opl=(opl<<1); if ((rF>>FL_C)&0x01)   opl = opl|0x01; }
void OP_RR()    { temp = rF; clear(FL_C); if (opl&0x01) set(FL_C); opl= opl>>1;  if ((temp>>FL_C)&0x01) opl = opl|0x80; }
void OP_RL()    { temp = rF; clear(FL_C); if (opl&0x80) set(FL_C); opl= opl<<1;  if ((temp>>FL_C)&0x01) opl = opl|0x01; }
void OP_ADDA()  { op = opl; op = op + rA;                   set_flags(op,8); sync_op(); }
void OP_ADCA()  { op = opl; op = op + rA + (rF>>FL_C)&0x01; set_flags(op,8); sync_op(); }
void OP_SUBFA() {           op = rA - opl;                  set_flags(op,8); sync_op(); }
void OP_SBCFA() {           op = rA - opl -(rF>>FL_C)&0x01; set_flags(op,8); sync_op(); }
void OP_ANDA()  { opl = opl&rA; set_flags(opl,8); }
void OP_ORA()   { opl = opl|rA; set_flags(opl,8); }
void OP_XORA()  { opl = opl^rA; set_flags(opl,8); }
void OP_ADDHL() { op = opl + oph<<8; op +=(rH<<8)+rL; set_flags(op, 16); }
void OP_STHL()  { op = opl + oph<<8; RAM[op] = rL; RAM[op+1] = rH; }
void OP_RMEM16(){ temp = (rH<<8)+rL; opl = RAM[temp]; oph = RAM[temp+1]; }
void OP_RMEM8() { temp = (rH<<8)+rL; opl = RAM[temp];                    }
void OP_SCF()   { set(FL_C);   }                                // set Carry
void OP_CCF()   { rF = rF^(1<<FL_C); }                          // compliement Carry
void OP_CPL()   { opl = !opl; rF = rF|(1<<FL_N|1<<FL_H); }
void OP_PUSH16(){ sp = (rSPH<<8)+rSPL; RAM[--sp] = oph; RAM[--sp] = opl; sync_rsp(); }
void OP_POP16() { sp = (rSPH<<8)+rSPL; opl = RAM[sp++]; oph = RAM[sp++]; sync_rsp(); }
void OP_EXHL()  { temp = rL; rL = opl; opl = temp; temp = rH; rH = oph; oph = temp; }
void OP_IFNZ()  { if   (rF&(1<<FL_Z))  nostore = true; }
void OP_IFZ()   { if (!(rF&(1<<FL_Z))) nostore = true; }
void OP_IFNC()  { if   (rF&(1<<FL_C))  nostore = true; }
void OP_IFC()   { if (!(rF&(1<<FL_C))) nostore = true; }
void OP_IFPO()  { if (!(rF&(1<<FL_P))) nostore = true; }
void OP_IFPE()  { if   (rF&(1<<FL_P))  nostore = true; }
void OP_IFP()   { if (!(rF&(1<<FL_S))) nostore = true; }
void OP_IFM()   { if   (rF&(1<<FL_S))  nostore = true; }
void OP_OUTA()  { out_command(opl); }
void OP_INA()   { rA = in_command(opl); }
void OP_INV()   { serial.printf("Invalid opcode at %04X : %02X.\n", pc, RAM[pc]); while(1); }
void OP_DI()    { OP_INV(); }
void OP_EI()    { OP_INV(); }
void OP_DA()    { OP_INV(); }                                              // to implement!!

//=================================================================================        
// Operations broken down into fetch/op/store phases.
//

void do_op_00() { FETCH_NOP();      OP_NOP();        STORE_NOP();      } //  00  NOP
void do_op_01() { FETCH_DIR16();    OP_NOP();        STORE_BC();       } //  01  nnnnLDBC,nn
void do_op_02() { FETCH_A();        OP_NOP();        STORE_MBC();      } //  02  LD(BC),A
void do_op_03() { FETCH_BC();       OP_INC16();      STORE_BC();       } //  03  INCBC
void do_op_04() { FETCH_B();        OP_INC();        STORE_B();        } //  04  INCB
void do_op_05() { FETCH_B();        OP_DEC();        STORE_B();        } //  05  DECB
void do_op_06() { FETCH_DIR8();     OP_NOP();        STORE_B();        } //  06  nnLDB,n
void do_op_07() { FETCH_A();        OP_RLC();        STORE_A();        } //  07  RLCA
void do_op_08() { FETCH_NOP();      OP_INV();        STORE_NOP();      } //  08  EXAF,AF'(Z80)
void do_op_09() { FETCH_BC();       OP_ADDHL();      STORE_HL();       } //  09  ADDHL,BC
void do_op_0A() { FETCH_MBC();      OP_NOP();        STORE_A();        } //  0A  LDA,(BC)
void do_op_0B() { FETCH_BC();       OP_DEC16();      STORE_BC();       } //  0B  DECBC
void do_op_0C() { FETCH_C();        OP_INC();        STORE_C();        } //  0C  INCC
void do_op_0D() { FETCH_C();        OP_DEC();        STORE_C();        } //  0D  DECC
void do_op_0E() { FETCH_DIR8();     OP_NOP();        STORE_C();        } //  0E  nnLDC,n
void do_op_0F() { FETCH_A();        OP_RRC();        STORE_A();        } //  0F  RRCA
void do_op_10() { FETCH_NOP();      OP_INV();        STORE_NOP();      } //  10  ooDJNZo(Z80)
void do_op_11() { FETCH_DIR16();    OP_NOP();        STORE_DE();       } //  11  nnnnLDDE,nn
void do_op_12() { FETCH_A();        OP_NOP();        STORE_MDE();      } //  12  LD(DE),A
void do_op_13() { FETCH_DE();       OP_INC16();      STORE_DE();       } //  13  INCDE
void do_op_14() { FETCH_D();        OP_INC();        STORE_D();        } //  14  INCD
void do_op_15() { FETCH_D();        OP_DEC();        STORE_D();        } //  15  DECD
void do_op_16() { FETCH_DIR8();     OP_NOP();        STORE_D();        } //  16  nnLDD,n
void do_op_17() { FETCH_A();        OP_RL();         STORE_A();        } //  17  RLA
void do_op_18() { FETCH_NOP();      OP_INV();        STORE_NOP();      } //  18  ooJRo(Z80)
void do_op_19() { FETCH_DE();       OP_ADDHL();      STORE_HL();       } //  19  ADDHL,DE
void do_op_1A() { FETCH_MDE();      OP_NOP();        STORE_A();        } //  1A  LDA,(DE)
void do_op_1B() { FETCH_DE();       OP_DEC16();      STORE_DE();       } //  1B  DECDE
void do_op_1C() { FETCH_E();        OP_INC();        STORE_E();        } //  1C  INCE
void do_op_1D() { FETCH_E();        OP_DEC();        STORE_E();        } //  1D  DECE
void do_op_1E() { FETCH_DIR8();     OP_NOP();        STORE_E();        } //  1E  nnLDE,n
void do_op_1F() { FETCH_A();        OP_RR();         STORE_A();        } //  1F  RRA
void do_op_20() { FETCH_NOP();      OP_INV();        STORE_NOP();      } //  20  ooJRNZ,o(Z80)
void do_op_21() { FETCH_DIR16();    OP_NOP();        STORE_HL();       } //  21  nnnnLDHL,nn
void do_op_22() { FETCH_DIR16();    OP_STHL();       STORE_NOP();      } //  22  nnnnLD(nn),HL
void do_op_23() { FETCH_HL();       OP_INC16();      STORE_HL();       } //  23  INCHL
void do_op_24() { FETCH_H();        OP_INC();        STORE_H();        } //  24  INCH
void do_op_25() { FETCH_H();        OP_DEC();        STORE_H();        } //  25  DECH
void do_op_26() { FETCH_DIR8();     OP_NOP();        STORE_H();        } //  26  nnLDH,n
void do_op_27() { FETCH_A();        OP_DA();         STORE_A();        } //  27  DAA
void do_op_28() { FETCH_NOP();      OP_INV();        STORE_NOP();      } //  28  ooJRZ,o(Z80)
void do_op_29() { FETCH_HL();       OP_ADDHL();      STORE_HL();       } //  29  ADDHL,HL
void do_op_2A() { FETCH_DIR16();    OP_RMEM16();     STORE_HL();       } //  2A  nnnnLDHL,(nn)
void do_op_2B() { FETCH_HL();       OP_DEC16();      STORE_HL();       } //  2B  DECHL
void do_op_2C() { FETCH_L();        OP_INC();        STORE_L();        } //  2C  INCL
void do_op_2D() { FETCH_L();        OP_DEC();        STORE_L();        } //  2D  DECL
void do_op_2E() { FETCH_DIR8();     OP_NOP();        STORE_L();        } //  2E  nnLDL,n
void do_op_2F() { FETCH_A();        OP_CPL();        STORE_A();        } //  2F  CPL
void do_op_30() { FETCH_NOP();      OP_INV();        STORE_NOP();      } //  30  ooJRNC,o(Z80)
void do_op_31() { FETCH_DIR16();    OP_NOP();        STORE_SP();       } //  31  nnnnLDSP,nn
void do_op_32() { FETCH_DIR16();    OP_NOP();        STORE_AM();       } //  32  nnnnLD(nn),A
void do_op_33() { FETCH_SP();       OP_INC16();      STORE_SP();       } //  33  INCSP
void do_op_34() { FETCH_MHL();      OP_INC();        STORE_MHL();      } //  34  INC(HL)
void do_op_35() { FETCH_MHL();      OP_DEC();        STORE_MHL();      } //  35  DEC(HL)
void do_op_36() { FETCH_DIR8();     OP_NOP();        STORE_MHL();      } //  36  nnLD(HL),n
void do_op_37() { FETCH_NOP();      OP_SCF();        STORE_NOP();      } //  37  SCF
void do_op_38() { FETCH_NOP();      OP_INV();        STORE_NOP();      } //  38  ooJRC,o(Z80)
void do_op_39() { FETCH_SP();       OP_ADDHL();      STORE_HL();       } //  39  ADDHL,SP
void do_op_3A() { FETCH_DIR16();    OP_RMEM8();      STORE_A();        } //  3A  nnnnLDA,(nn)
void do_op_3B() { FETCH_SP();       OP_DEC16();      STORE_SP();       } //  3B  DECSP
void do_op_3C() { FETCH_A();        OP_INC();        STORE_A();        } //  3C  INCA
void do_op_3D() { FETCH_A();        OP_DEC();        STORE_A();        } //  3D  DECA
void do_op_3E() { FETCH_DIR8();     OP_NOP();        STORE_A();        } //  3E  nnLDA,n
void do_op_3F() { FETCH_NOP();      OP_CCF();        STORE_NOP();      } //  3F  CCF(ComplementCarryFlag,gvd)
void do_op_40() { FETCH_B();        OP_NOP();        STORE_B();        } //  40  LDB,r
void do_op_41() { FETCH_C();        OP_NOP();        STORE_B();        } //  41  LDB,r
void do_op_42() { FETCH_D();        OP_NOP();        STORE_B();        } //  42  LDB,r
void do_op_43() { FETCH_E();        OP_NOP();        STORE_B();        } //  43  LDB,r
void do_op_44() { FETCH_H();        OP_NOP();        STORE_B();        } //  44  LDB,r
void do_op_45() { FETCH_L();        OP_NOP();        STORE_B();        } //  45  LDB,r
void do_op_46() { FETCH_MHL();      OP_NOP();        STORE_B();        } //  46  LDB,r
void do_op_47() { FETCH_A();        OP_NOP();        STORE_B();        } //  47  LDB,r
void do_op_48() { FETCH_B();        OP_NOP();        STORE_C();        } //  48  LDC,r
void do_op_49() { FETCH_C();        OP_NOP();        STORE_C();        } //  49  LDC,r
void do_op_4A() { FETCH_D();        OP_NOP();        STORE_C();        } //  4A  LDC,r
void do_op_4B() { FETCH_E();        OP_NOP();        STORE_C();        } //  4B  LDC,r
void do_op_4C() { FETCH_H();        OP_NOP();        STORE_C();        } //  4C  LDC,r
void do_op_4D() { FETCH_L();        OP_NOP();        STORE_C();        } //  4D  LDC,r
void do_op_4E() { FETCH_MHL();      OP_NOP();        STORE_C();        } //  4E  LDC,r
void do_op_4F() { FETCH_A();        OP_NOP();        STORE_C();        } //  4F  LDC,r
void do_op_50() { FETCH_B();        OP_NOP();        STORE_D();        } //  50  LDD,r
void do_op_51() { FETCH_C();        OP_NOP();        STORE_D();        } //  51  LDD,r
void do_op_52() { FETCH_D();        OP_NOP();        STORE_D();        } //  52  LDD,r
void do_op_53() { FETCH_E();        OP_NOP();        STORE_D();        } //  53  LDD,r
void do_op_54() { FETCH_H();        OP_NOP();        STORE_D();        } //  54  LDD,r
void do_op_55() { FETCH_L();        OP_NOP();        STORE_D();        } //  55  LDD,r
void do_op_56() { FETCH_MHL();      OP_NOP();        STORE_D();        } //  56  LDD,r
void do_op_57() { FETCH_A();        OP_NOP();        STORE_D();        } //  57  LDD,r
void do_op_58() { FETCH_B();        OP_NOP();        STORE_E();        } //  58  LDE,r
void do_op_59() { FETCH_C();        OP_NOP();        STORE_E();        } //  59  LDE,r
void do_op_5A() { FETCH_D();        OP_NOP();        STORE_E();        } //  5A  LDE,r
void do_op_5B() { FETCH_E();        OP_NOP();        STORE_E();        } //  5B  LDE,r
void do_op_5C() { FETCH_H();        OP_NOP();        STORE_E();        } //  5C  LDE,r
void do_op_5D() { FETCH_L();        OP_NOP();        STORE_E();        } //  5D  LDE,r
void do_op_5E() { FETCH_MHL();      OP_NOP();        STORE_E();        } //  5E  LDE,r
void do_op_5F() { FETCH_A();        OP_NOP();        STORE_E();        } //  5F  LDE,r
void do_op_60() { FETCH_B();        OP_NOP();        STORE_H();        } //  60  LDH,r
void do_op_61() { FETCH_C();        OP_NOP();        STORE_H();        } //  61  LDH,r
void do_op_62() { FETCH_D();        OP_NOP();        STORE_H();        } //  62  LDH,r
void do_op_63() { FETCH_E();        OP_NOP();        STORE_H();        } //  63  LDH,r
void do_op_64() { FETCH_H();        OP_NOP();        STORE_H();        } //  64  LDH,r
void do_op_65() { FETCH_L();        OP_NOP();        STORE_H();        } //  65  LDH,r
void do_op_66() { FETCH_MHL();      OP_NOP();        STORE_H();        } //  66  LDH,r
void do_op_67() { FETCH_A();        OP_NOP();        STORE_H();        } //  67  LDH,r
void do_op_68() { FETCH_B();        OP_NOP();        STORE_L();        } //  68  LDL,r
void do_op_69() { FETCH_C();        OP_NOP();        STORE_L();        } //  69  LDL,r
void do_op_6A() { FETCH_D();        OP_NOP();        STORE_L();        } //  6A  LDL,r
void do_op_6B() { FETCH_E();        OP_NOP();        STORE_L();        } //  6B  LDL,r
void do_op_6C() { FETCH_H();        OP_NOP();        STORE_L();        } //  6C  LDL,r
void do_op_6D() { FETCH_L();        OP_NOP();        STORE_L();        } //  6D  LDL,r
void do_op_6E() { FETCH_MHL();      OP_NOP();        STORE_L();        } //  6E  LDL,r
void do_op_6F() { FETCH_A();        OP_NOP();        STORE_L();        } //  6F  LDL,r
void do_op_70() { FETCH_B();        OP_NOP();        STORE_MHL();      } //  70  LD(HL),r
void do_op_71() { FETCH_C();        OP_NOP();        STORE_MHL();      } //  71  LD(HL),r
void do_op_72() { FETCH_D();        OP_NOP();        STORE_MHL();      } //  72  LD(HL),r
void do_op_73() { FETCH_E();        OP_NOP();        STORE_MHL();      } //  73  LD(HL),r
void do_op_74() { FETCH_H();        OP_NOP();        STORE_MHL();      } //  74  LD(HL),r
void do_op_75() { FETCH_L();        OP_NOP();        STORE_MHL();      } //  75  LD(HL),r
void do_op_76() { FETCH_NOP();      OP_NOP();        STORE_NOP();      } //  76  HALT
void do_op_77() { FETCH_A();        OP_NOP();        STORE_MHL();      } //  77  LD(HL),r
void do_op_78() { FETCH_B();        OP_NOP();        STORE_A();        } //  78  LDA,r
void do_op_79() { FETCH_C();        OP_NOP();        STORE_A();        } //  79  LDA,r
void do_op_7A() { FETCH_D();        OP_NOP();        STORE_A();        } //  7A  LDA,r
void do_op_7B() { FETCH_E();        OP_NOP();        STORE_A();        } //  7B  LDA,r
void do_op_7C() { FETCH_H();        OP_NOP();        STORE_A();        } //  7C  LDA,r
void do_op_7D() { FETCH_L();        OP_NOP();        STORE_A();        } //  7D  LDA,r
void do_op_7E() { FETCH_MHL();      OP_NOP();        STORE_A();        } //  7E  LDA,r
void do_op_7F() { FETCH_A();        OP_NOP();        STORE_A();        } //  7F  LDA,r
void do_op_80() { FETCH_B();        OP_ADDA();       STORE_A();        } //  80  ADDA,r
void do_op_81() { FETCH_C();        OP_ADDA();       STORE_A();        } //  81  ADDA,r
void do_op_82() { FETCH_D();        OP_ADDA();       STORE_A();        } //  82  ADDA,r
void do_op_83() { FETCH_E();        OP_ADDA();       STORE_A();        } //  83  ADDA,r
void do_op_84() { FETCH_H();        OP_ADDA();       STORE_A();        } //  84  ADDA,r
void do_op_85() { FETCH_L();        OP_ADDA();       STORE_A();        } //  85  ADDA,r
void do_op_86() { FETCH_MHL();      OP_ADDA();       STORE_A();        } //  86  ADDA,r
void do_op_87() { FETCH_A();        OP_ADDA();       STORE_A();        } //  87  ADDA,r
void do_op_88() { FETCH_B();        OP_ADCA();       STORE_A();        } //  88  ADCA,r
void do_op_89() { FETCH_C();        OP_ADCA();       STORE_A();        } //  89  ADCA,r
void do_op_8A() { FETCH_D();        OP_ADCA();       STORE_A();        } //  8A  ADCA,r
void do_op_8B() { FETCH_E();        OP_ADCA();       STORE_A();        } //  8B  ADCA,r
void do_op_8C() { FETCH_H();        OP_ADCA();       STORE_A();        } //  8C  ADCA,r
void do_op_8D() { FETCH_L();        OP_ADCA();       STORE_A();        } //  8D  ADCA,r
void do_op_8E() { FETCH_MHL();      OP_ADCA();       STORE_A();        } //  8E  ADCA,r
void do_op_8F() { FETCH_A();        OP_ADCA();       STORE_A();        } //  8F  ADCA,r
void do_op_90() { FETCH_B();        OP_SUBFA();      STORE_A();        } //  90  SUBA,r
void do_op_91() { FETCH_C();        OP_SUBFA();      STORE_A();        } //  91  SUBA,r
void do_op_92() { FETCH_D();        OP_SUBFA();      STORE_A();        } //  92  SUBA,r
void do_op_93() { FETCH_E();        OP_SUBFA();      STORE_A();        } //  93  SUBA,r
void do_op_94() { FETCH_H();        OP_SUBFA();      STORE_A();        } //  94  SUBA,r
void do_op_95() { FETCH_L();        OP_SUBFA();      STORE_A();        } //  95  SUBA,r
void do_op_96() { FETCH_MHL();      OP_SUBFA();      STORE_A();        } //  96  SUBA,r
void do_op_97() { FETCH_A();        OP_SUBFA();      STORE_A();        } //  97  SUBA,r
void do_op_98() { FETCH_B();        OP_SBCFA();      STORE_A();        } //  98  SBCA,r
void do_op_99() { FETCH_C();        OP_SBCFA();      STORE_A();        } //  99  SBCA,r
void do_op_9A() { FETCH_D();        OP_SBCFA();      STORE_A();        } //  9A  SBCA,r
void do_op_9B() { FETCH_E();        OP_SBCFA();      STORE_A();        } //  9B  SBCA,r
void do_op_9C() { FETCH_H();        OP_SBCFA();      STORE_A();        } //  9C  SBCA,r
void do_op_9D() { FETCH_L();        OP_SBCFA();      STORE_A();        } //  9D  SBCA,r
void do_op_9E() { FETCH_MHL();      OP_SBCFA();      STORE_A();        } //  9E  SBCA,r
void do_op_9F() { FETCH_A();        OP_SBCFA();      STORE_A();        } //  9F  SBCA,r
void do_op_A0() { FETCH_B();        OP_ANDA();       STORE_A();        } //  A0  ANDA,r
void do_op_A1() { FETCH_C();        OP_ANDA();       STORE_A();        } //  A1  ANDA,r
void do_op_A2() { FETCH_D();        OP_ANDA();       STORE_A();        } //  A2  ANDA,r
void do_op_A3() { FETCH_E();        OP_ANDA();       STORE_A();        } //  A3  ANDA,r
void do_op_A4() { FETCH_H();        OP_ANDA();       STORE_A();        } //  A4  ANDA,r
void do_op_A5() { FETCH_L();        OP_ANDA();       STORE_A();        } //  A5  ANDA,r
void do_op_A6() { FETCH_MHL();      OP_ANDA();       STORE_A();        } //  A6  ANDA,r
void do_op_A7() { FETCH_A();        OP_ANDA();       STORE_A();        } //  A7  ANDA,r
void do_op_A8() { FETCH_B();        OP_XORA();       STORE_A();        } //  A8  XORA,r
void do_op_A9() { FETCH_C();        OP_XORA();       STORE_A();        } //  A9  XORA,r
void do_op_AA() { FETCH_D();        OP_XORA();       STORE_A();        } //  AA  XORA,r
void do_op_AB() { FETCH_E();        OP_XORA();       STORE_A();        } //  AB  XORA,r
void do_op_AC() { FETCH_H();        OP_XORA();       STORE_A();        } //  AC  XORA,r
void do_op_AD() { FETCH_L();        OP_XORA();       STORE_A();        } //  AD  XORA,r
void do_op_AE() { FETCH_MHL();      OP_XORA();       STORE_A();        } //  AE  XORA,r
void do_op_AF() { FETCH_A();        OP_XORA();       STORE_A();        } //  AF  XORA,r
void do_op_B0() { FETCH_B();        OP_ORA();        STORE_A();        } //  B0  ORA,r
void do_op_B1() { FETCH_C();        OP_ORA();        STORE_A();        } //  B1  ORA,r
void do_op_B2() { FETCH_D();        OP_ORA();        STORE_A();        } //  B2  ORA,r
void do_op_B3() { FETCH_E();        OP_ORA();        STORE_A();        } //  B3  ORA,r
void do_op_B4() { FETCH_H();        OP_ORA();        STORE_A();        } //  B4  ORA,r
void do_op_B5() { FETCH_L();        OP_ORA();        STORE_A();        } //  B5  ORA,r
void do_op_B6() { FETCH_MHL();      OP_ORA();        STORE_A();        } //  B6  ORA,r
void do_op_B7() { FETCH_A();        OP_ORA();        STORE_A();        } //  B7  ORA,r
void do_op_B8() { FETCH_B();        OP_SUBFA();      STORE_NOP();      } //  B8  CPA,r
void do_op_B9() { FETCH_C();        OP_SUBFA();      STORE_NOP();      } //  B9  CPA,r
void do_op_BA() { FETCH_D();        OP_SUBFA();      STORE_NOP();      } //  BA  CPA,r
void do_op_BB() { FETCH_E();        OP_SUBFA();      STORE_NOP();      } //  BB  CPA,r
void do_op_BC() { FETCH_H();        OP_SUBFA();      STORE_NOP();      } //  BC  CPA,r
void do_op_BD() { FETCH_L();        OP_SUBFA();      STORE_NOP();      } //  BD  CPA,r
void do_op_BE() { FETCH_MHL();      OP_SUBFA();      STORE_NOP();      } //  BE  CPA,r
void do_op_BF() { FETCH_A();        OP_SUBFA();      STORE_NOP();      } //  BF  CPA,r
void do_op_C0() { FETCH_NOP();      OP_IFNZ();       STORE_RET();      } //  C0  RETNZ
void do_op_C1() { FETCH_NOP();      OP_POP16();      STORE_BC();       } //  C1  POPBC
void do_op_C2() { FETCH_DIR16();    OP_IFNZ();       STORE_PC();       } //  C2  nnnnJPNZ,nn
void do_op_C3() { FETCH_DIR16();    OP_NOP();        STORE_PC();       } //  C3  nnnnJPnn
void do_op_C4() { FETCH_DIR16();    OP_IFNZ();       STORE_CALL();     } //  C4  nnnnCALLNZ,nn
void do_op_C5() { FETCH_BC();       OP_PUSH16();     STORE_NOP();      } //  C5  PUSHBC
void do_op_C6() { FETCH_DIR8();     OP_ADDA();       STORE_A();        } //  C6  nnADDA,n
void do_op_C7() { FETCH_RST();      OP_NOP();        STORE_CALL();     } //  C7  RST0
void do_op_C8() { FETCH_NOP();      OP_IFZ();        STORE_RET();      } //  C8  RETZ
void do_op_C9() { FETCH_NOP();      OP_NOP();        STORE_RET();      } //  C9  RET
void do_op_CA() { FETCH_DIR16();    OP_IFZ();        STORE_PC();       } //  CA  nnnnJPZ,nn
void do_op_CB() { FETCH_NOP();      OP_INV();        STORE_NOP();      } //  CB  (Z80specific)
void do_op_CC() { FETCH_DIR16();    OP_IFZ();        STORE_CALL();     } //  CC  nnnnCALLZ,nn
void do_op_CD() { FETCH_DIR16();    OP_NOP();        STORE_CALL();     } //  CD  nnnnCALLnn
void do_op_CE() { FETCH_DIR8();     OP_ADCA();       STORE_A();        } //  CE  nnADCA,n
void do_op_CF() { FETCH_RST();      OP_NOP();        STORE_CALL();     } //  CF  RST8H
void do_op_D0() { FETCH_NOP();      OP_IFNC();       STORE_RET();      } //  D0  RETNC
void do_op_D1() { FETCH_NOP();      OP_POP16();      STORE_DE();       } //  D1  POPDE
void do_op_D2() { FETCH_DIR16();    OP_IFNC();       STORE_PC();       } //  D2  nnnnJPNC,nn
void do_op_D3() { FETCH_DIR8();     OP_OUTA();       STORE_NOP();      } //  D3  nnOUT(n),A
void do_op_D4() { FETCH_DIR16();    OP_IFNC();       STORE_CALL();     } //  D4  nnnnCALLNC,nn
void do_op_D5() { FETCH_DE();       OP_PUSH16();     STORE_NOP();      } //  D5  PUSHDE
void do_op_D6() { FETCH_DIR8();     OP_SUBFA();      STORE_A();        } //  D6  nnSUBn
void do_op_D7() { FETCH_RST();      OP_NOP();        STORE_CALL();     } //  D7  RST10H
void do_op_D8() { FETCH_NOP();      OP_IFC();        STORE_RET();      } //  D8  RETC
void do_op_D9() { FETCH_NOP();      OP_INV();        STORE_NOP();      } //  D9  EXX(Z80)
void do_op_DA() { FETCH_DIR16();    OP_IFC();        STORE_PC();       } //  DA  nnnnJPC,nn
void do_op_DB() { FETCH_DIR8();     OP_INA();        STORE_A();        } //  DB  nnINA,(n)
void do_op_DC() { FETCH_DIR16();    OP_IFC();        STORE_CALL();     } //  DC  nnnnCALLC,nn
void do_op_DD() { FETCH_NOP();      OP_INV();        STORE_NOP();      } //  DD  (Z80)
void do_op_DE() { FETCH_DIR8();     OP_SBCFA();      STORE_A();        } //  DE  nnSBCA,n
void do_op_DF() { FETCH_RST();      OP_NOP();        STORE_CALL();     } //  DF  RST18H
void do_op_E0() { FETCH_NOP();      OP_IFPO();       STORE_RET();      } //  E0  RETPO
void do_op_E1() { FETCH_NOP();      OP_POP16();      STORE_HL();       } //  E1  POPHL
void do_op_E2() { FETCH_DIR16();    OP_IFPO();       STORE_PC();       } //  E2  nnnnJPPO,nn
void do_op_E3() { FETCH_MSP();      OP_EXHL();       STORE_MSP();      } //  E3  EX(SP),HL
void do_op_E4() { FETCH_DIR16();    OP_IFPO();       STORE_CALL();     } //  E4  nnnnCALLPO,nn
void do_op_E5() { FETCH_HL();       OP_PUSH16();     STORE_NOP();      } //  E5  PUSHHL
void do_op_E6() { FETCH_DIR8();     OP_ANDA();       STORE_A();        } //  E6  nnANDn
void do_op_E7() { FETCH_RST();      OP_NOP();        STORE_CALL();     } //  E7  RST20H
void do_op_E8() { FETCH_NOP();      OP_IFPE();       STORE_RET();      } //  E8  RETPE
void do_op_E9() { FETCH_HL();       OP_NOP();        STORE_PC();       } //  E9  JP(HL)
void do_op_EA() { FETCH_DIR16();    OP_IFPE();       STORE_PC();       } //  EA  nnnnJPPE,nn
void do_op_EB() { FETCH_DE();       OP_EXHL();       STORE_DE();       } //  EB  EXDE,HL
void do_op_EC() { FETCH_DIR16();    OP_IFPE();       STORE_CALL();     } //  EC  nnnnCALLPE,nn
void do_op_ED() { FETCH_NOP();      OP_INV();        STORE_NOP();      } //  ED  (Z80specific)
void do_op_EE() { FETCH_DIR8();     OP_XORA();       STORE_A();        } //  EE  nnXORn
void do_op_EF() { FETCH_RST();      OP_NOP();        STORE_CALL();     } //  EF  RST28H
void do_op_F0() { FETCH_NOP();      OP_IFP();        STORE_RET();      } //  F0  RETP
void do_op_F1() { FETCH_NOP();      OP_POP16();      STORE_AF();       } //  F1  POPAF
void do_op_F2() { FETCH_DIR16();    OP_IFP();        STORE_PC();       } //  F2  nnnnJPP,nn
void do_op_F3() { FETCH_NOP();      OP_DI();         STORE_NOP();      } //  F3  DI
void do_op_F4() { FETCH_DIR16();    OP_IFP();        STORE_CALL();     } //  F4  nnnnCALLP,nn
void do_op_F5() { FETCH_AF();       OP_PUSH16();     STORE_NOP();      } //  F5  PUSHAF
void do_op_F6() { FETCH_DIR8();     OP_ORA();        STORE_A();        } //  F6  nnORn
void do_op_F7() { FETCH_RST();      OP_NOP();        STORE_CALL();     } //  F7  RST30H
void do_op_F8() { FETCH_NOP();      OP_IFM();        STORE_RET();      } //  F8  RETM
void do_op_F9() { FETCH_HL();       OP_NOP();        STORE_SP();       } //  F9  LDSP,HL
void do_op_FA() { FETCH_DIR16();    OP_IFM();        STORE_PC();       } //  FA  nnnnJPM,nn
void do_op_FB() { FETCH_NOP();      OP_EI();         STORE_NOP();      } //  FB  EI
void do_op_FC() { FETCH_DIR16();    OP_IFM();        STORE_CALL();     } //  FC  nnnnCALLM,nn
void do_op_FD() { FETCH_NOP();      OP_INV();        STORE_NOP();      } //  FD  (Z80specific)
void do_op_FE() { FETCH_DIR8();     OP_SUBFA();      STORE_NOP();      } //  FE  nnCPn
void do_op_FF() { FETCH_RST();      OP_NOP();        STORE_CALL();     } //  FF  RST38H
