#ifndef WDPLAYER_H
#define WDPLAYER_H

/** WDplayer Class
 * A PWM Audio Player for .Wav runs for 8-bit Mono Audio samples
 * 
 * Example:
 *@code
 *#include "mbed.h"
 *#include "SDFileSystem.h"
 *#include "WDplayer.h"
 *
 *SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");
 *
 *int main() {
 *    //Defining a File Path
 *   const char *mp3p; 
 *   mp3p = "/sd/Game-Files/AudBin/play1.wav";
 *
 *   //Creating an Object
 *   WDplayer mp3;
 *
 *   //Intialize with File Path
 *   mp3.intWD(mp3p);
 *
 *   //Play the File
 *   mp3.WDplay();
 *  
 *  //Changing Path
 *   mp3p = "/sd/Game-Files/AudBin/play2.wav";
 *
 *   //Using the One Tick One Sample Playing
 *   while(1) {
 *       mp3.WDtck();
 *   }
 *  
 *}
 *@endcode
 */


//Best Audio
//.wav sampled at 16000hz
// mono channel only

#include <iostream>
#include "mbed.h"

class WDplayer{
    
    public:
    /** Intialize WDplayer with a File Path
     *
     *@param path File Path Pointer
     */
    void intWD(const char *path);
    /** Plays the Wav File (mbed waits till File has finished playing)
     *
     */
    void WDplay(PwmOut &dac);
    /** Plays the Wav File one Sample at a time
     *
     */
    void WDtck(PwmOut &dac);
    /** Returns the created PWM period.
     *
     *@returns A unsigned long of the Period the PWM is working on
     */
    float get_pwmfreq();
    
    
    private:
    unsigned int _length;
    float _pwmfreq;
    const char *_path;
    FILE *_fptr;
    unsigned int _tck;
};
#endif