#include "WDplayer.h"

unsigned char *buffer = (unsigned char *)malloc(1);

void WDplayer::intWD(const char *path) {
    //open File
    _fptr = fopen(path,"r");
    if (_fptr == NULL) {
    std::cerr << "Error File not Found" << std::endl;
    }
    //get info
    unsigned int samplerate;
    fseek(_fptr,24,SEEK_SET);
    fread(&samplerate,4,1,_fptr);
    fseek(_fptr,0,SEEK_END);
    unsigned int len = ftell(_fptr);
    _pwmfreq = (1.0f / samplerate);
    _path = path;
    _length = len - 44;
    _fptr = NULL;
    _tck = 0;
};

void WDplayer::WDplay(PwmOut &dac) {
    _fptr = fopen(_path,"r");
    fseek(_fptr,44,SEEK_SET);
    //sampling loop _ source of main performance issues
    for (_tck = _length; _tck > 1; _tck--) {
        fread(buffer,1,1,_fptr);
        dac.write((float)buffer[0] / 255.00f);
        wait(_pwmfreq / 2.0f); //I dont like this & Playback present here        
    }
    _fptr = NULL;
    _tck = 0;
};

void WDplayer::WDtck(PwmOut &dac) {
    if (_fptr == NULL) {
    _fptr = fopen(_path,"r");
    fseek(_fptr,44,SEEK_SET);
    }
    //sampling loop
    if (_tck == _length) {
        _fptr = NULL;
        _tck = 0;
    } else {
        fread(buffer,1,1,_fptr);
        dac.write( (int)buffer[0] / 255.00 );
        //wait(_pwmfreq / 2.0f); //I dont like this remove to tick mode
        _tck++;
    }
};

float WDplayer::get_pwmfreq() {
    return _pwmfreq;
};