#include "Bitmap.h"

void Bitmap::renderBMP(const char *path, N5110 &lcd, unsigned int const x, unsigned int const y) {
    FILE *bmp = fopen(path,"r");
    if (bmp == NULL) {
        std::cerr << "File Not Found" << std::endl;
    }
    unsigned char *buffer = (unsigned char*)std::malloc(4 * sizeof(unsigned char));
    unsigned long offbits;
    unsigned long height;
    unsigned long width;
    std::fseek(bmp,10,SEEK_SET);
    std::fread(&offbits,4,1,bmp);
    std::fseek(bmp,18,SEEK_SET);
    std::fread(&width,4,1,bmp);
    std::fseek(bmp,22,SEEK_SET);
    std::fread(&height,4,1,bmp);
    unsigned short int dcount = (width / 32) + 1;
    fseek(bmp,offbits,SEEK_SET);
    std::bitset<32> bits;
    int row = 0;
    offbits = 0;
    int colomn = 0;
    bool state;
    //NEW ENGINENE CORE
    for (unsigned int dwcount = 1; dwcount < ((dcount*height) + 1); dwcount++) {
        std::fread(buffer,1,4,bmp);
        //endian swap
        bits = buffer[0];
        bits = (bits << 8) | (std::bitset<32>)buffer[1];
        bits = (bits << 8) | (std::bitset<32>)buffer[2];
        bits = (bits << 8) | (std::bitset<32>)buffer[3];
        //bit loop adaptive
        if (dwcount % dcount == 0) {
            for (offbits = 0; offbits < (width % 32); offbits++){
                if (bits[31 - offbits] == 1) {
                    state = false;
                } else {
                    state = true;
                }
                lcd.setPixel((colomn + x) ,(row + y),state);
                colomn++;
            }
            row++;
            colomn = 0;
        } else {
            for (offbits = 0; offbits < 32; offbits++) {
                if (bits[31 - offbits] == 1) {
                    state = false;
                } else {
                    state = true;
                }
                lcd.setPixel((colomn + x) ,(row + y),state);
                colomn++;
            }
        }
    }
    std::fclose(bmp);
}
