#include "mbed.h"
#include "EthernetInterface.h"
#include "C12832_lcd.h"
#include "PubSubClient.h"
#include "MMA7660.h"

#define  _2LEMETRY_USERID       "<2lemetry user id>"
#define  _2LEMETRY_TOKEN        "<2lemetry token>"
#define  _2LEMETRY_DOMAIN       "<2lemetry domain - usually same as user id>"
#define  _2LEMETRY_STUFF        "<2lemetry stuff - a grouping of devices - recommend 'mbed' to get started>"
#define  _2LEMETRY_DEVICE_ID    "<2lemetry device id - unique device id - mac / serial # - recommend 'nxp01' to get started>"

C12832_LCD lcd;
Serial pc(USBTX, USBRX);

char* serverIpAddr = "q.mq.tt";
int port = 1883; /*Sever Port*/
void callback(char* topic, char* payload, unsigned int len); /*Callback function prototype*/
PubSubClient mqtt(serverIpAddr, port, callback);
EthernetInterface  eth;

MMA7660 MMA(p28, p27);

void callback(char* topic, char* payload, unsigned int len)
{
    // for now just print the payload
    lcd.printf("Payload: %s\r\n\r\n", payload);
    wait(2);
    lcd.cls();
}

int main() {
    char clientID[30];
    char topicString[50];

    eth.init(); //Use DHCP
    eth.connect();
    lcd.cls();
    lcd.locate(0,3);
    pc.printf("IP Address is %s\n", eth.getIPAddress());

    pc.printf("mbed example on 2lemetry");
    
    // create MQTT client ID    
    sprintf(clientID, _2LEMETRY_DEVICE_ID);
    
    if(!mqtt.connect(clientID, _2LEMETRY_USERID, _2LEMETRY_TOKEN)){
        pc.printf("\r\nConnect to server failed ..\r\n");
        return -1;
    }
    
    pc.printf("\r\nConnect to server successful ..\r\n");
    
    int i = 0;
    char pubString[50];
    
    // temporarily use pubTopic string to create subscription topic
    sprintf(topicString, "%s/%s/%s/cmd", _2LEMETRY_DOMAIN, _2LEMETRY_STUFF, _2LEMETRY_DEVICE_ID);
      
    mqtt.subscribe(topicString);
    
    // now overwrite with publish string
    sprintf(topicString, "%s/%s/%s", _2LEMETRY_DOMAIN, _2LEMETRY_STUFF, _2LEMETRY_DEVICE_ID);
    
    while(1) {
        int x_val, y_val, z_val;
        x_val = (int)(MMA.x() * 1000);
        y_val = (int)(MMA.y() * 1000);
        z_val = (int)(MMA.z() * 1000);
        sprintf(pubString, "{\"x\":%d,\"y\":%d,\"z\":%d}", x_val, y_val, z_val);
        mqtt.publish(topicString, pubString);
        wait(1);
        mqtt.loop();
    }
}
