#include "DeviceIO.h"

#define DEF "\033[39m"
#define GRE "\033[32m"
#define CYA "\033[36m"

DeviceIO::DeviceIO(GPSI2C& gps) :
    _userButton(PC_13),
    _analog1(A0),
    _analog2(A1),
    _led1(PA_5),
    _gpsTracker(gps),
    _deviceFeedback(_led1)
{
}

bool DeviceIO::userButtonPressed()
{
    return _userButton;
}

GPSTracker& DeviceIO::gpsTracker()
{
    return _gpsTracker;
}

DeviceFeedback& DeviceIO::deviceFeedback()
{
    return _deviceFeedback;
}

AnalogIn& DeviceIO::analog1()
{
    return _analog1;
}

AnalogIn& DeviceIO::analog2()
{
    return _analog2;
}

void DeviceIO::debugPrint(const char *line)
{
    _debug.printf(GRE "io::debugPrint" DEF "\r\n");
    _debug.printf(GRE "> " CYA "%s\r\n" DEF, line);
}
