#include "LocationUpdate.h"

LocationUpdate::LocationUpdate(GPSTracker& gpsTracker) :
    _gpsTracker(gpsTracker)
{
    _init = false;
}

bool LocationUpdate::init()
{
    if (_init)
        return false;
    
    _init = true;
    return true;
}

bool LocationUpdate::run()
{
    GPSTracker::Position position;
    
    if (!_gpsTracker.position(&position)) {
        puts("No GPS data available.");
        return true;
    }
        
    puts("Starting measurement sending.");

    float altitude = position.altitude;
    float latitude = position.latitude;
    float longitude = position.longitude;
    
    printf("Lat: %9.7f Long: %9.7f Altitude %.2f", latitude, longitude, altitude);
    
    return true;
}
