#include "DeviceMemory.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define CONFIGURATION_FILE "001_CONFIGURATION"

DeviceMemory::DeviceMemory(MDMSerial& mdm) :
    _mdm(mdm)
{
}

bool DeviceMemory::loadConfiguration(char *cfg, size_t len)
{
    int res;

    if ((res = _mdm.readFile(CONFIGURATION_FILE, cfg, len)) < 0)
        return false;
    
    cfg[(size_t)res] = '\0';
    return true;
}

bool DeviceMemory::saveConfiguration(char *cfg)
{
    size_t len;
    
    len = strlen(cfg);
    
    resetConfiguration();
    return (_mdm.writeFile(CONFIGURATION_FILE, cfg, len) == len);
}

bool DeviceMemory::resetConfiguration()
{
    return _mdm.delFile(CONFIGURATION_FILE);
}
