#include "SignalQualityMeasurement.h"

SignalQualityMeasurement::SignalQualityMeasurement(DeviceInfo& deviceInfo) :
    _deviceInfo(deviceInfo)
{
    _init = false;
}

bool SignalQualityMeasurement::init()
{
    if (_init)
        return false;
    
    _init = true;
    return true;
}

bool SignalQualityMeasurement::run()
{
    DeviceInfo::SignalQuality *signalQuality;
    
    if ((signalQuality = _deviceInfo.signalQuality()) == NULL)
        return false;
        
    int rssi = signalQuality->rssi;
    int ber = signalQuality->ber;
    
    printf("RSSI: %d dBm BER: %d %", rssi, ber);
    
    return true;
}
