#pragma once

#include "mbed.h"
#include "GPS.h"
#include "GPSTracker.h"
#include "DeviceFeedback.h"
#include "SWO.h"

class DeviceIO
{
public:
    DeviceIO(GPSI2C&);

    bool userButtonPressed();
    GPSTracker& gpsTracker();
    DeviceFeedback& deviceFeedback();
    AnalogIn& analog1();
    AnalogIn& analog2();
    void debugPrint(const char*);

private:
    DigitalIn _userButton;
    AnalogIn _analog1;
    AnalogIn _analog2;
    PwmOut _led1;
    GPSTracker _gpsTracker;
    DeviceFeedback _deviceFeedback;
    SWO_Channel _debug;
};
