#pragma once

#include <stddef.h>
#include "mbed.h"
#include "rtos.h"

/**
 * Device Feedback handler
 */
class DeviceFeedback
{
public:
    DeviceFeedback(PwmOut led);
    
    void showSuccess();
    void showFailure();
    
protected:
    void sendMessage(uint8_t);
    void thread();
    static void thread_func(void const*);

private:
    PwmOut _led;
    Thread _thread;
    Mail<uint8_t, 16> _mail;
};
