#include "DeviceFeedback.h"
#include <stdlib.h>
#include <string.h>

#define MSG_SHOW_SUCCESS 1
#define MSG_SHOW_FAILURE 2

DeviceFeedback::DeviceFeedback(PwmOut led) :
    _led(led),
    _thread(DeviceFeedback::thread_func, this)
{
}

void DeviceFeedback::showSuccess()
{
    sendMessage(MSG_SHOW_SUCCESS);
}

void DeviceFeedback::showFailure()
{
    sendMessage(MSG_SHOW_FAILURE);
}

void DeviceFeedback::sendMessage(uint8_t msg)
{
    uint8_t *msgPtr;
    
    msgPtr = _mail.alloc();
    *msgPtr = msg;
    _mail.put(msgPtr);
}

void DeviceFeedback::thread()
{
    osEvent evt; 
    uint8_t *msg;
    
    while (true) {
        if ((evt = _mail.get(1000)).status == osEventMail) {
            msg = (uint8_t*)evt.value.p;
            switch (*msg) {
            case MSG_SHOW_SUCCESS:
                for (float i=2000.0; i<10000.0; i+=2000.0) {
                    _led.period(1.0/i);
                    _led = 0.5;
                    Thread::wait(200);
                    _led = 0.0;
                    Thread::wait(50);
                }
                break;
            case MSG_SHOW_FAILURE:
                for (float i=10000.0; i>2000.0; i-=2000.0) {
                    _led.period(1.0/i);
                    _led = 0.5;
                    Thread::wait(200);
                    _led = 0.0;
                    Thread::wait(50);
                }
                break;
            }
            _mail.free(msg);
        }
    }
}

void DeviceFeedback::thread_func(void const *arg)
{
    DeviceFeedback *that;
    that = (DeviceFeedback*)arg;
    that->thread();
}
