#pragma once

#include <stddef.h>
#include "MDM.h"
#include "DeviceIO.h"
#include "DeviceInfo.h"
#include "DeviceMemory.h"
#include "DeviceConfiguration.h"
#include "ConfigurationProperties.h"
#include "SignalQualityMeasurement.h"
#include "AnalogMeasurement.h"
#include "LocationUpdate.h"

class MbedAgent
{
public:
    MbedAgent(DeviceIO&, MDMSerial&, DeviceInfo&, DeviceMemory&);
    
    bool init();
    bool run();

protected:
    void loop();
    
private:
    DeviceIO& _io;
    MDMSerial& _mdm;
    DeviceInfo& _deviceInfo;
    DeviceMemory& _deviceMemory;
    DeviceConfiguration _deviceConfiguration;
    ConfigurationProperties _configurationProperties;
    SignalQualityMeasurement _signalQualityMeasurement;
    AnalogMeasurement _analogMeasurement;
    LocationUpdate _locationUpdate;
};
