#include "MbedAgent.h"
#include "rtos.h"

MbedAgent::MbedAgent(DeviceIO& io, MDMSerial& mdm, DeviceInfo& deviceInfo, DeviceMemory& deviceMemory) :
    _io(io),
    _mdm(mdm),
    _deviceInfo(deviceInfo),
    _deviceMemory(deviceMemory),
    _configurationProperties(_deviceConfiguration),
    _signalQualityMeasurement(_deviceInfo),
    _analogMeasurement(_io.analog1(), _io.analog2()),
    _locationUpdate(_io.gpsTracker())
{
}

bool MbedAgent::init()
{
    if ((!_signalQualityMeasurement.init()) ||
        (!_analogMeasurement.init()) ||
        (!_locationUpdate.init())) {
        puts("Initialization failed.");
        return false;
    }
    return true;
}

bool MbedAgent::run()
{
    // add some config setup if needed
    
    loop();

    return true;
}

void MbedAgent::loop()
{
    Timer timer; int interval;
    
    timer.start();
    while (true) {
        timer.reset();
        
        _signalQualityMeasurement.run();
        _analogMeasurement.run();
        _locationUpdate.run();
        
        if ((interval = _configurationProperties.readInterval()) == 0)
            break;

        while (timer.read() < interval) {
            Thread::yield();
        }
    }
}