//heater control using LM75B Temp sensor and Pot1 as inputs and LED1 and 2 as too hot and too cold tempreture indicators. 
//LED 4 is used to indicate heater on/off

#include "mbed.h"
#include "C12832_lcd.h"
#include "LM75B.h"

DigitalOut toohot(LED1);
DigitalOut toocold(LED2);
DigitalOut heater(LED4);

C12832_LCD disp;
LM75B temp(p28,p27);
AnalogIn therm(p19);

float room_temp;
float therm_set;

int main()
{
    toocold=0;
    toohot=0;
    
    while(1) 
    {

    therm_set=therm.read() *45.0f;// Reading and caliberating the thermostat setting 
    room_temp=temp.read();
    disp.cls(); // clear the screen
    disp.locate(0,0);
    disp.printf("Thermostat setting: %.2fc", therm_set);
    disp.locate(0,10);
    disp.printf("Room Temperature: %.2fc", room_temp);
    
    if (room_temp>24.0f)
    {   
        toocold=0;
        toohot=1;
    }
    else 
    {
        toocold=1;
        toohot=0;
    }
    
    if(room_temp<therm_set)
        heater=1;
    else
        heater=0;
    
     wait(0.1);  
    }
}
