#include "mbed.h"
#include "SerialDriver.h"
#include "NeoStrip.h"
#include "gt.h"
 
#define NUM_INDIVIDUALS 7
#define NUM_RING 16
#define NUM_GRID 40
#define NUM_ROWS 5
#define NUM_COLUMNS 8

SerialDriver rpi(p9, p10);
SerialDriver pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
NeoStrip strip(p18, NUM_INDIVIDUALS + NUM_RING + NUM_GRID);
Ticker t;

enum Mode { spin, flat };
Mode mode = spin;

int ring_position = 0;
int grid_col = 0;

void set_leds(int to);
void set_pattern(NeoStrip strip, uint8_t r, uint8_t g, uint8_t b);
void spin_update();
void flat_update();
void set_mode(Mode m);

int main() {
    pc.baud(115200);
    rpi.baud(115200);
    pc.printf("MBED: startup\r\n");
    
    //set_pattern(strip, 255, 255, 255);

    set_mode(flat);
    
    //char* line_buffer = (char*) malloc(100*sizeof(char));
    
    while (1) {
        char c = rpi.getc();
        
        while (c != '\x02') {
            c = rpi.getc();
        }
        
        c = rpi.getc(); // get actual mode message
        
        wait(0.1);
        rpi.putc('\x3A');
        pc.printf("MBED: sent ack after receiving %c\r\n", c);
        
        
        switch (c) {
            case 'a':
                pc.printf("MBED: switching to spin mode\r\n");
                set_mode(spin);
                break;
            case 'b':
                pc.printf("MBED: switching to flat mode\r\n");
                set_mode(flat);
                break;
        }
    }
}

void set_mode(Mode m) {
    mode = m;
    
    switch (mode) {
        case spin:
            t.detach();
            t.attach(&spin_update, 0.05);
            break;
        case flat:
            t.detach();
            t.attach(&flat_update, 0.05);
            break;
    }
}

void set_leds(int to) {
    led1 = led2 = led3 = led4 = to;
}

void set_pattern(NeoStrip strip, uint8_t r, uint8_t g, uint8_t b) {
    strip.setBrightness(0.05);
    //strip.setPixels(0, N, gt_img);
    for (int p = 0; p < 64; p++) {
        strip.setPixel(p, r, g, b);
    }
    strip.write();
}

void spin_update() {
    strip.setBrightness(0.05);
    // update ring
    strip.setPixel(NUM_INDIVIDUALS + ring_position, 255, 255, 255);
    ring_position = (ring_position + 1) % NUM_RING;
    strip.setPixel(NUM_INDIVIDUALS + ring_position, 255, 0, 0);
    
    // update grid
    for (int i = grid_col; i < NUM_GRID; i += NUM_COLUMNS) {   
        strip.setPixel(NUM_INDIVIDUALS + NUM_RING + i, 255, 255, 255);
    }
    grid_col = (grid_col + 1) % NUM_COLUMNS;
    
    for (int i = grid_col; i < NUM_GRID; i += NUM_COLUMNS) {   
        strip.setPixel(NUM_INDIVIDUALS + NUM_RING + i, 255, 0, 0);
    }
    
    strip.write();    
}

void flat_update() {
    strip.setBrightness(0.05);
    
    for (int i = 0; i < NUM_INDIVIDUALS + NUM_RING + NUM_GRID; i++) {
        strip.setPixel(i, 255, 0, 0);
    }
    
    strip.write();
}