#include "mbed.h"
#include "SLCD.h"
#include "Servo.h"
#include "DMX.h"

// The Switch Resources
DigitalOut S1o(PTB19);
DigitalOut S2o(PTC7);

DigitalOut LD1(LED1);
DigitalOut LD2(LED2);


DigitalIn  S1i0(PTD3,PullDown);
DigitalIn  S1i1(PTB18,PullDown);

DigitalIn  S2i0(PTC8,PullDown);
DigitalIn  S2i1(PTC6,PullDown);


// The LCD display

SLCD slcd;

// The Servo
   Servo Shutter(PTC1);  // put this on a PWM pin

// The DMX protocol
   DMX dmx(PTE22, PTE23);  // put it on a serial port DMX (PinName p_tx, PinName p_rx); 

int main()
{
    
    int          DMX_ADDR=0;            // DMX_ADDR set from the config file
    unsigned int DMX_VALUE=0;           // This value is set from the DMX stream
  //  unsigned int DMX_LAST_VALUE=0;
    int          DMX_MSG_COUNT=0;       // A counter for diagnostic purposes
    int          DMX_STATUS;
    
    int          position1 =0;
    int          position2 =0;
    float        pos=0.0;
    
    
    S1o=1;
    S2o=1;
    
    Shutter.calibrate(0.0008,180);  // Calibrate the servo
    
  /*  while (true) {
       position1 = S1i0 + (S1i1<<1);
       position2 = S2i0 + (S2i1<<1);
       
       slcd.Home();
       slcd.printf("%2d",position1*4+position2);
       
       pos = pos + 0.01;
       pos=(pos>1.0)?0.0:pos;
       
       Shutter = pos;
       wait(0.1);
    } */
    
    DMX_MSG_COUNT=0;        // set the number of (unique) messages so far to zero
    while(true) {              // until power off.....
    
        position1 = S1i0 + (S1i1<<1);
        position2 = S2i0 + (S2i1<<1);
    
        DMX_ADDR = 200+position1*4+position2;  // 1 to MaxDMX
    
        DMX_STATUS=dmx.get_mode_rx();
        if(DMX_STATUS==DMX_MODE_BEGIN) {LD1= 0; LD2 = 1;}
        if(DMX_STATUS==DMX_MODE_BREAK) {LD1= 1; LD2 = 0;}
        if(DMX_STATUS==DMX_MODE_DATA)  {LD1= 1; LD2 = 1;}
        if(DMX_STATUS==DMX_MODE_ERROR) {LD1= 0; LD2 = 0;}
        
        
        DMX_VALUE= dmx.get(DMX_ADDR-1);      // get the data from the stream 
     //   if(DMX_VALUE == DMX_LAST_VALUE) continue;  // ignore if it is the same as the last one
                                                   // best as I can tell, the libary routine has a 
                                                   // bug, (is_recived = 1; in break time should be a zero
                                                   // ignoring repeated values has the same result.  
                                                   
     //   DMX_LAST_VALUE = DMX_VALUE;
        DMX_MSG_COUNT++;                   // update the count
        pos = (1.0*DMX_VALUE)/(1.0*255);   // calculate the shutter position 
        Shutter.write(pos);                // position the servo
                                           // Print the message
        slcd.Home();                                   
        slcd.printf("%3d        ",DMX_ADDR);                                   
       //slcd.printf("%d-->%4.2f",DMX_VALUE,pos);
        
    }
    
 
}