#include "APA102a.h"
#include "mbed.h"

APA102a::APA102a(PinName mosi,PinName miso,PinName sclk,int rate)
        : _spi(mosi, miso, sclk)
      
        {
            // Setup the spi for 8 bit data, low steady state clock,
            // second edge capture, with clock rate, clock active low, rising edge
            _spi.format(8,0);
            _spi.frequency(rate);
        } 
        
void APA102a::SetBuffer(unsigned int Buffer[],int Rows,int Cols, int Stride,int Offset, bool ZigZag,bool Wrap)
{
    Buf = Buffer;
    NR = Rows;
    NC = Cols;
    NS = Stride;
    off = Offset;
    ZF = ZigZag;
    WF = Wrap;
    }
    
void APA102a::Repaint()
{   
    int index;
    unsigned int val;
    
    _spi.write(0X00);  // Start
    _spi.write(0X00);
    _spi.write(0X00);
    _spi.write(0X00);
    
    for(int r = 0;r<NR;r++)
    {
        for(int c = off;c<(NC+off);c++)
        {
            int cc = (WF)?(c%NS):((c<NS)?c:NS);
         //   if (ZF) 
         //     { if((r&0x01)>0)
                    index = r*NS + NC+off-cc;
         //      else
         //           index = r*NS + cc;}
         //   else 
                index = r*NS + c;
                
            val = Buf[index];
            _spi.write((val>>24)&0xFF);  
            _spi.write((val>>16)&0xFF);  
            _spi.write((val>>8)&0xFF);  
            _spi.write(val&0xFF);  
        }
    }
    _spi.write(0XFF); // Stop
    _spi.write(0XFF);
    _spi.write(0XFF);
    _spi.write(0XFF);
    
}