#ifndef MBED_APA102_H

#define MBED_PING_H
 
#include "mbed.h"



/** Create an APA102 Object 
    */ 
 class APA102{
  public:
/** Create an APA102 object connected to the specified mosi,miso,sclk pins
    *
    * @param mosi : SPI Master Out Slave In pin
    * @param miso : SPI Master In Slave Out pin (ignored)
    * @param sclk : SPI Clock
    * @param rate : SPI Rate
    */
     APA102(PinName mosi,PinName miso,PinName sclk,int rate);
       
/** Set the Buffer
     *
     * @param buffer[] : a buffer of unsigned integers (4 bytes) *Rows*Stride in size
     * @param Rows     : Number of Rows
     * @param Cols     : Number of Columns
     * @param Stride   : The actual number of columns (useful for data alignment)
     * @param Offset   : The offset into a row
     * @param ZigZag   : A boolean, do we alternate count up/ count down per row?
     * @param Wrap     : A boolean, do we wrap if (Offset+Cols) > Stride? (handy for scrolling messages)
     */
     void SetBuffer(unsigned int Buffer[],int Rows,int Cols, int Stride,int Offset, bool ZigZag,bool Wrap); 
     
/** Repaint the Strip
     *
     * @param none
     */
     void Repaint();
     
/** Create an IRGB helper function to construct a 4 byte LED Frame
    *
    * @param I : 5 bits of intensity (0,1,2,...,31)
    * @param R : 8 bits of Red   (0,1,...,255)
    * @param G : 8 bits of Green (0,1,...,255)
    * @param B : 8 bits of Blue  (0,1,...,255)
    */
 
int IRGB(unsigned char I,unsigned char R,unsigned char G,unsigned char B) {
     return ((0xE0 + 0x1F&I)<<24)|((0xFF&R)<<16)|((0xFF&G)<<8)|(0xFF&B);}
     
  protected:
  
    SPI _spi;
  private: 
    int NR;
    int NC;
    int NS;
    int off;
    bool ZF;
    bool WF;
    unsigned int * Buf;
 };
 
#endif