/*
*
*/

////////////////////////////////////////////////////////////////////
// Test code to read temperature from a Maxim DS18B20 or DS18S20
// 1-wire device
////////////////////////////////////////////////////////////////////

#include <mbed.h>
#include "DebugTrace.h"
#include "DS18B20.h"
#include "OneWireDefs.h"
#include "SDFileSystem.h"

DebugTrace trace(ON, TO_SERIAL);
SDFileSystem *poSD;
bool bSDfs_active=false;
DigitalIn oSDCardPresent(p15);

const int NUM_THERMS=5; // set of themometers
const int SAMPLE_SIZE=5; // how many readings to average over
#define ReturnAir 0
#define WasteAir 1
#define FreshAir 2
#define MixedAir 3
#define HeatedAir 4
DS18B20 oThermos[NUM_THERMS]={DS18B20(true, false, false, p16),DS18B20(true, false, false, p17),DS18B20(true, false, false, p18),DS18B20(true, false, false, p19),DS18B20(true, false, false, p20)};
float fTemps[NUM_THERMS][SAMPLE_SIZE+1]; //average and the last SAMPLE_SIZE readings
int iCurrentSample;

DigitalOut oPump(p23);
typedef enum {Cooling,Neutral,Heating} tState;
tState eState=Neutral; //main system state
int iSubState=0;
int iHeatingStates,iCoolingStates,iCoolingStep,iCoolingValue;
float fHeatingStep,fHeatingValue;

DigitalOut oLedPump(LED1);
DigitalOut oLedRecirc(LED2);
DigitalOut oLedByp(LED3);
DigitalOut oLedFileOpen(LED4);

const int NUM_SERVOS=2;
#define HeatExBypass 0
#define FreshAirBypass 1
typedef struct {
    int iBase,iRange,iCurrent;
    PwmOut oOut;
} tServo ;
tServo oServos[NUM_SERVOS]={{0,0,0,PwmOut(p21)},{0,0,0,PwmOut(p22)}};
int BypassState;

float MaxHeat,SetPoint;
int TempFreq,LogFreq,ControlFreq;

void read_temps();
void do_controls();
void adjust_pump(float current,float required);
void log_values(time_t now);
void set_servo(tServo *poServo,float fTarget);

int main() {
    int x;
    time_t start,nexttemp,nextcontrol,nextlog,now;
    printf("Roselea Air conditioning control system\n");
    FILE *fp;

    do { // wait for SD to be inserted hten attempt to open  setting file

        if (oSDCardPresent==1) {
            printf("Waiting for SD Card\n");
            while (oSDCardPresent) { //flash led while waitinf for the card
                oLedFileOpen=!oLedFileOpen;
                wait (0.5);
            }
            oLedFileOpen=0;
            wait (0.5); //allow poSD time to stabilse
        }
        poSD=new SDFileSystem(p11, p12, p13, p14, "poSD");
        bSDfs_active=true;
        fp = fopen("/poSD/Settings.txt", "r");
        if (fp == NULL) {
            printf("Could not open file for read\nPlease insert card with Settings.txt on it\n");
            while (oSDCardPresent==0) { // wait for card to be removed then try again
                oLedFileOpen=!oLedFileOpen;
                wait (0.1);
            }
            delete poSD;
            bSDfs_active=false;
        }
    } while (fp==NULL);
    oLedFileOpen=1;

    struct tm t;
    fscanf(fp, "%d %d %d %d:%d:%d",&t.tm_year,&t.tm_mon,&t.tm_mday,&t.tm_hour,&t.tm_min,&t.tm_sec); //read the real time
    // convert to timestamp
    t.tm_mon--;
    t.tm_year=t.tm_year-1900;
    set_time(mktime(&t));
    printf("Time has been set to %s\n",asctime(&t));

    for (x=0; x<NUM_SERVOS; x++) { //initialise servos from file values
        int l,h;
        fscanf(fp,"%d %d",&l,&h); //read low and high values
        oServos[x].iBase=20000-l;
        oServos[x].iRange=(20000-h)-oServos[x].iBase; // calculate operation range
        oServos[x].oOut.period_us(20000);
        oServos[x].oOut.pulsewidth_us(oServos[x].iBase);
        printf("Servo %d has base of %d and range of %d\n",x+1,oServos[x].iBase,oServos[x].iRange);
    }
    fscanf(fp,"%d %d %d",&TempFreq,&LogFreq,&ControlFreq);
    printf("temp read time %d, log time %d and control time %d\n",TempFreq,LogFreq,ControlFreq);
    fscanf(fp,"%f",&SetPoint);
    printf("Temperature setpoint is %.1f \n",SetPoint);
    fscanf(fp,"%d %f",&iHeatingStates,&fHeatingStep);
    printf("There are %d heating states @ rate of %.1f\n",iHeatingStates,fHeatingStep);
    fscanf(fp,"%d %d",&iCoolingStates,&iCoolingStep);
    printf("There are %d cooling states @ rate of %d\n",iCoolingStates,iCoolingStep);

    fclose(fp);
    oLedFileOpen=0;

    // Initilize hardware
    for (x=0; x<NUM_THERMS; x++) //set up thermometers
        if (!oThermos[x].initialize())
            printf("Thermometer %d failed to initialse\n",x);
        else {
            fTemps[x][0]=oThermos[x].readTemperature();
            for (int y=1; y<=SAMPLE_SIZE; y++)
                fTemps[x][y]=fTemps[x][0]; //load into all entries
        }
    iCurrentSample=1;

    oPump=0; // Turn off the pump
    oLedPump=0;

    //Set_servo(FreshAirBypass,0);
    //Set_servo(HeatExBypass,0);

    start = time(NULL);
    nexttemp=start-10; //cause all actions at the start
    nextcontrol=start-10;
    nextlog=start-10;

    // infinite control loop ...
    while (1) {
        now=time(NULL);
        printf("%d\n",now);
        if (now>=nexttemp) {
            nexttemp+=TempFreq;
            read_temps();
        }
        if (now>=nextcontrol) {
            nextcontrol+=ControlFreq;
            do_controls();
        }
        if (eState>0 && fTemps[HeatedAir][0]!=fHeatingValue) adjust_pump(fTemps[HeatedAir][0],fHeatingValue);

        if (oSDCardPresent==1 && bSDfs_active) { //SD Card removed and SD file system is instansiated
            delete poSD; //deconstruct the SD File System
            bSDfs_active=false;
            printf("SD Card removed\n");
        }
        if (oSDCardPresent==0 && !bSDfs_active) { //SD Card inserted and SD file system is void
            poSD=new SDFileSystem(p11, p12, p13, p14, "poSD"); //construct the SD File System
            bSDfs_active=true;
            printf("SD Card inserted\n");
        }
        if (now>=nextlog) {
            nextlog+=LogFreq;
            log_values(now);
        }
        wait (1); //waste some time
    }
}

void read_temps() {
    int x;
    printf("conversion start\n");
    for (x=0; x<NUM_THERMS; x++)
        fTemps[x][0]=oThermos[x].readTemperature();
    printf("conversion finished\n");
}

void do_controls() {
}

void adjust_pump(float current,float required) {
    if (current>required)
        oPump=0;
    else
        oPump=1;
}

 void set_servo(tServo *poServo,float fTarget)
 {
 }
void log_values(time_t now) {
    FILE *fp;
    int x;
    char sTime[25];
    strftime (sTime,25,"%x %X",localtime(&now));
    if (bSDfs_active) {
        fp=fopen("/poSD/log.csv","a");
        if (fp) {
            oLedFileOpen=1;
            fprintf(fp,"%s,",sTime); //time
            for (x=0; x<NUM_THERMS; x++) fprintf(fp,"%.1f,",fTemps[x]); //fTemps
            //fprintf(fp,"%d,%.1f,",HeatingOn,HeatingSetPoint); // heating data
            for (x=0; x<NUM_SERVOS; x++) fprintf(fp,"%d,",oServos[x].iCurrent); //servo positions
            fprintf(fp,",0\r\n");
            fclose(fp);
            oLedFileOpen=0;
            printf("Written - ");
        } else printf("Failed - ");
    } else printf("SD removed - ");
    fp=stdout;
    fprintf(fp,"%s,",sTime); //time
    for (x=0; x<NUM_THERMS; x++) fprintf(fp,"%.1f,",fTemps[x]); //fTemps
    //fprintf(fp,"%d,%.1f,",HeatingOn,HeatingSetPoint); // heating data
    for (x=0; x<NUM_SERVOS; x++) fprintf(fp,"%d,",oServos[x].iCurrent); //servo positions
    fprintf(fp,"0\n");


}
