#ifndef WOLFSON_config
#define WOLFSON_config
// WM8731 Drivers - from MIKROE LIBSTOCK: https://libstock.mikroe.com/projects/view/304/wm8731-example
/**************************************************************************************************
* WM8731 sound chip register addresses
**************************************************************************************************/
const int WM8731_ADDRESS = 0x34;       // WM8731 chip address on I2C bus
/**************************************************************************************************
* WM8731 sound chip register addresses
**************************************************************************************************/
const int WM8731_REG_LLINE_IN        = 0x00;       // Left Channel Line Input Volume Control
const int WM8731_REG_RLINE_IN        = 0x01;       // Right Channel Line Input Volume Control
const int WM8731_REG_LHPHONE_OUT     = 0x02;       // Left Channel Headphone Output Volume Control
const int WM8731_REG_RHPHONE_OUT     = 0x03;       // Right Channel Headphone Output Volume Control
const int WM8731_REG_ANALOG_PATH     = 0x04;       // Analog Audio Path Control
const int WM8731_REG_DIGITAL_PATH    = 0x05;       // Digital Audio Path Control
const int WM8731_REG_PDOWN_CTRL      = 0x06;       // Power Down Control Register
const int WM8731_REG_DIGITAL_IF      = 0x07;       // Digital Audio Interface Format
const int WM8731_REG_SAMPLING_CTRL   = 0x08;       // Sampling Control Register
const int WM8731_REG_ACTIVE_CTRL     = 0x09;       // Active Control
const int WM8731_REG_RESET           = 0x0F;       // Reset register

/**************************************************************************************************
* WM8731 sound chip constants (for default set up)
**************************************************************************************************/
const int _WM8731_LEFT_LINEIN        = 0X0180;     // MIC SETTINGS: ENABLE MUTE, ENABLE SIMULTANEOUS LOAD TO LEFT AND RIGHT CHANNELS
const int _WM8731_RIGHT_LINEIN       = 0X0180;     // MIC SETTINGS: ENABLE MUTE, ENABLE SIMULTANEOUS LOAD TO LEFT AND RIGHT CHANNELS
const int _WM8731_LEFT_HP            = 0X00F9;     // HEADPHONE SETTINGS : 0DB
const int _WM8731_RIGHT_HP           = 0X00F9;     // HEADPHONE SETTINGS : 0DB
//const int _WM8731_LEFT_HP            = 0X00E1;     // HEADPHONE SETTINGS : -6?DB
//const int _WM8731_RIGHT_HP           = 0X00E1;     // HEADPHONE SETTINGS : -6?DB
const int _WM8731_ANALOGAUDIO        = 0XD0;       // DAC SELECT
const int _WM8731_DIGITALAUDIO       = 0X00;        //11011
const int _WM8731_POWER              = 0X00;       // DISABLE POWER DOWN
const int _WM8731_DAIF               = 0X02;       // ENABLE SLAVE MODE, 16BIT DATA AND I2S DATA
//const int _WM8731_SAMPLING           = 0X00;       // 48000HZ,12.288MHz oscillator.
//const int _WM8731_SAMPLING           = 0X2E;       // 8000HZ,12.288MHz oscillator.
const int _WM8731_SAMPLING           = 0X18;       // 8000HZ,12.288MHz oscillator.
const int _WM8731_ACTIVATE           = 0X01;       // MODULE IS ON
const int _WM8731_DEACTIVATE         = 0X00;       // MODULE IS OFF
const int _WM8731_RESET              = 0X00;       // RESET VALUE

//do I need to delete these highlighted ones? (ie unused ones?) I think maybe theyre duplicates
/**************************************************************************************************/


#endif