#include "mbed.h"
#include <iostream>
#include <string>
#include <math.h>

DigitalOut gpo(D0);
DigitalOut led(LED_RED);

float bereken_hoeken(float x, float y) {
    float langste_zijde = sqrt(pow(x*4,2) + pow(y*4,2));
    float alpha = acos((langste_zijde/2)/30);
    float beta = 0.5*M_PI - alpha;
    float hoek_arm2 = 2*beta;
    float hoek_arm1 = atan((4*y)/(4*x)) + alpha;
    return hoek_arm2;
}

int main()
{   
    printf("%.2f\n",bereken_hoeken(4,4));
    printf("%.4f\n",bereken_hoeken(3,7));
    printf("%.4f\n",bereken_hoeken(5,9));
    
    return 0;
}