#include "mbed.h"

DigitalIn button(PTA4);
DigitalOut blue(LED3);
Timer timer;
int nBlinky = 1;
int buttonState = 1;

void blinkRed(int nblinks) {
    for (int i=0; i < nblinks; i++) {
        blue.write(0);
        wait(0.2);
        blue.write(1);
        wait(0.2);
    }
}

bool buttonPressed(){

    if (button.read() == 0 && buttonState == 1){
        buttonState = 0;
        return true;
    }
    if (button.read() == 1 && buttonState == 0){
        buttonState = 1;
    }
    return false;
}

void count() {
    if (buttonPressed()) {
        nBlinky++;
    }
}

int main()
{
    blue = 1;

    while (true) {
        if (buttonPressed()) {
            timer.reset();
            timer.start();
            nBlinky = 1;
            while (timer.read_ms() <= 2000) {
                count();
            }
            blinkRed(nBlinky);
        }

    }
}