/* Power electronics usalle*/

#include "mbed.h"


#ifndef M_PI 
#define M_PI 3.14159265358979323846 
#endif 

// Number of samples to generate sine pattern
#define SINE_STEPS        100
// Pwm period in us
#define PWM_PERIOD        20  


DigitalOut myled(LED1); 
PwmOut CH1(PWM_OUT); 



// dc : duty cycle
// n:   a sample 
// T:   Time in microsecond the sine_dc function is evaluated
// 1/PWM_PERIOD defines the conmutation frequency (default 50kHz)
// T divided by  PWM_PERIOD defines the number of pwm cycles for each sine term sample (default 8.3)
// T times SINE_STEPS defines sine modulation period
 
 /* This program calculates values of a sine 
 function and splits them up in 100 points, these points are then written
  to the duty cycle of the pwm signals.
*/
Ticker interrupt;
InterruptIn button(USER_BUTTON);
int n;
double dc_min = 0.0, dc_max = 1.0;
void sine_dc() { 
    double dc, sine_term; 
    n = n + 1;
    if(n == SINE_STEPS) n = 0;
    sine_term = sin(2*M_PI*n/SINE_STEPS);
    // Convert sine term to duty cycle: if sine_term == 0, then dc = 0.5
    if (sine_term > 0) dc = 0.5 + (sine_term * (dc_max - 0.5));
    if (sine_term < 0) dc = 0.5 + (sine_term * (0.5 - dc_min));
    if (sine_term == 0) dc = 0.5;
    CH1.write(dc);
}

int main() {
    int T = 166;
    n = 0;
    CH1.period_us(PWM_PERIOD);
    CH1.write(0.5);


    
    //
    interrupt.attach_us(&sine_dc, T);
    
    while(1) {
         myled = !myled;
         wait(1);
    }
}

