#include "mbed.h"
#include "TextLCD.h"

RawSerial pc(PA_2,PA_3);
DigitalOut  led1(PD_12);      // (PTB18)
DigitalOut  led2(PD_13);    // (PTB19)
DigitalOut  led4(PD_14);     // (PTD1)
DigitalOut  led5(PD_15);
I2C i2c_lcd(PB_7, PB_8); // SDA, SCL
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD20x4);
AnalogOut SALIDA(PA_4);//conectar PA_4 con PB_1 se puede utilizar como control PWM
AnalogIn AIN(PB_1);
AnalogIn ain(PA_7);
PwmOut led(PA_6);
DigitalIn pulsador(PA_0);
DigitalIn pulsador1(PA_5);
bool vP1=0;
bool vP2=0;
int i;
int b=0;
float c=0;
float q=0;
float w=0;
float k=0.0;
float brightness=0.0;


void pc_recv()
{
    char c = pc.getc();
    {
        if (c == 'm') {//control manual

            led2 = !led2;
            led4 = 0;
            led1 = 0;

        }


        if (c == 's') {// regreso a menu

            led4 = !led4;
            led2 = 0;
            led1 = 0;
        }


        if (c == 'a') {// control automatico


            led1 = !led1;
            led2 = 0;
            led4 = 0;

        }
    }

}
int main()
{
    pc.baud(115200);



    pc.attach(&pc_recv, Serial::RxIrq);
    lcd.setCursor(TextLCD::CurOff_BlkOn);
    const char udc_Bat_Hi[] = {0x80, 0x84, 0x8e, 0x9f, 0x95, 0x8e, 0x84, 0x8a};  // Battery Full 128,132,142,159,149,142,132,138

    lcd.setUDC(1, (char *) udc_Bat_Hi);  // Define Bat High pattern for UDC index number 0
    lcd.putc(1);

    pc.printf("Bye now in original example \r\n");

    wait(1);

    lcd.cls();

    lcd.setBacklight(TextLCD::LightOn);

    int col = 0;
    int row = 0;
    lcd.locate(col,row);
    lcd.printf("Iniciando...");
    wait(1);

    lcd.setCursor(TextLCD::CurOff_BlkOff);

    int c = 1;
    lcd.cls();
    lcd.locate(0,0);
    for (int row=0; row<4; row++) {
        lcd.putc(c);
        wait(0.01);

        for (col=0; col<19; col++) {
            lcd.putc(c);
            wait(0.01);
        }
    }
    wait(3);

    const char* text2 = "PROYECTO FINAL";
    lcd.cls();
    lcd.locate(3,0);
    lcd.printf(text2);
    lcd.locate(8,1);
    lcd.printf("UPS");
    lcd.locate(6,2);
    lcd.printf("SISTEMAS");
    lcd.locate(3,3);
    lcd.printf("MICROPROCESADOS");
    wait(2);

    lcd.getAddress(col,row);
    pc.printf("column %d\trow %d\r\n",col,row);
    wait(2);

    // Write a raw string to the LCD
    const char* text = "CONTROL PWM AUTO(a)";
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf(text);

    lcd.locate(0,2);
    lcd.printf("CONTROL PWM MAN(m)");
    wait(1);

    lcd.getAddress(col,row);
    pc.printf("column %d\trow %d\r\n",col,row);
    


    while(1) {
        
            //inicio automatico
            if(led1==1) {
                b++;
                if (b>1) b=0;
                wait(0.5);

                for(w=0; w<1; w=w+0.1) {

                    SALIDA=w;
                    wait(0.1);

                    pc.printf("salida= %f%\n", AIN.read());
                    const char* text = "CONTROL PWM AUTO";
                    
                    lcd.locate(1,0);
                    lcd.printf(text);
                    q= AIN*10;

                    // Write a raw string to the LCD -> pointer

                    lcd.locate(2,2);
                    lcd.printf("salida= %f%\n", q);
                    wait(0.5);
                    if (ain>= 0.9f) {// ALARMA

                        lcd.locate(0,3);

                        pc.printf("ALARMA  %2.2f \n",ain.read());
                        led5= 0;
                        wait(0.1);
                    }

                    else {

                        lcd.locate(3,3);
                        lcd.printf("ALARMA TEMP");
                        pc.printf("ALARMA %2.2f \n",ain.read());
                        led5 = 1;
                        wait(0.1);
                    }
                }
            }


            if(led2==1)
            
              
             { //inicio manual

               
                const char* text41 = "CONTROL MAN AUTO";
                //lcd.cls();
                lcd.locate(1,0);
                lcd.printf(text41);
               

                // vP1=pulsador.read();
                //vP2=pulsador1.read();
                if((pulsador.read()==1 && brightness < 0.1)) {
                    brightness += 0.01;
                    led = brightness;
                    k=brightness*100;
                    wait(0.5);
                }
                if((pulsador1.read()==1 && brightness > 0.0)) {
                    brightness -= 0.01;
                    led = brightness;
                    k=brightness*100;
                    wait(0.5);
                }
                lcd.locate(2,2);
                lcd.printf("salida= %f%\n",k);
                pc.printf("%c %1.3f \n \r",c,k);
                wait(0.5);
            }


            if(led4==1) { // MENU
                lcd.cls();
                const char* text3 = "CONTROL PWM AUTO(a)";
               // lcd.cls();
                lcd.locate(0,0);
                lcd.printf(text3);

                lcd.locate(0,2);
                lcd.printf("CONTROL PWM MAN(m)");//programa manual
                wait(1);



                if (ain>= 0.9f) {//ALARMA

                    lcd.locate(0,3);

                    pc.printf("ALARMA  %2.2f \n",ain.read());
                    led5= 0;
                    wait(0.1);
                }

                else {

                    lcd.locate(3,3);
                    lcd.printf("ALARMA TEMP");
                    pc.printf("ALARMA %2.2f \n",ain.read());
                    led5 = 1;
                    wait(0.1);
                }
            




            sleep();

        }
    }
}