/* 
    Copyright (c) 2014 Romain Berrada
    
    Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
    and associated documentation files (the "Software"), to deal in the Software without restriction, 
    including without limitation the rights to use, copy, modify, merge, publish, distribute, 
    sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in all copies or 
    substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
    BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
    DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef INCLUDE_MENUEXAMPLE_H
#define INCLUDE_MENUEXAMPLE_H

#include "RGBLed.h"
#include "Menu.h"

#define MENUEXAMPLE_BLINK_NUMBER 3
#define MENUEXAMPLE_BLINK_DELAY 0.15

class MenuExample : public Menu {
protected:
    virtual void startMenu();
    virtual bool isSelectionChanging();
    virtual bool isValidating();
    virtual void displaySelectedProgram(void* output_argument);
};

void MenuExample::startMenu() {
    RGBLed led(LED_RED, LED_GREEN, LED_BLUE);
    unsigned int i;
    for (i=0; i<MENUEXAMPLE_BLINK_NUMBER; i++) {
        led.setColor(RGBLed::WHITE);
        wait(MENUEXAMPLE_BLINK_DELAY);
        led.setColor(RGBLed::BLACK);
        wait(MENUEXAMPLE_BLINK_DELAY);   
    }
}

bool MenuExample::isSelectionChanging() {
    DigitalIn bootstrap_k64f_sel_sw(SW2);
    static int last_state=1;
    bool test = false;
    if (!bootstrap_k64f_sel_sw && last_state) test=true;
    last_state = bootstrap_k64f_sel_sw.read();
    return test;
}

bool MenuExample::isValidating() {
    DigitalIn bootstrap_k64f_val_sw(SW3);
    static int last_state=1;
    bool test = false;
    if (!bootstrap_k64f_val_sw && last_state) test=true;
    last_state = bootstrap_k64f_val_sw.read();
    return test;
}

void MenuExample::displaySelectedProgram(void* output_argument) {
    RGBLed led(LED_RED, LED_GREEN, LED_BLUE);
    RGBLed::Color color = RGBLed::BLACK;
    if (output_argument!=NULL) color=*(RGBLed::Color*) output_argument;
    led.setColor(color);
}

#endif