/* 
    Copyright (c) 2014 Romain Berrada
    
    Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
    and associated documentation files (the "Software"), to deal in the Software without restriction, 
    including without limitation the rights to use, copy, modify, merge, publish, distribute, 
    sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in all copies or 
    substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
    BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
    DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "Menu.h"

Menu::Program::Program(void* output_argument, int(*program)()) : _output_interface_argument(output_argument), _program(program), _next(NULL) {
}

Menu::Menu() : _first(NULL) {
}

void Menu::addProgram(void* output_argument, int(*program)()) {
    Program* prog = new Program(output_argument, program);
    if (_first==NULL) { // if first program added
        _first = prog;
        return;   
    } else {
        Program* temp = _first;
        while (temp->_next!=NULL) temp=temp->_next;
        temp->_next = prog;   
    }    
}

void Menu::clean() {
    Program* prg = _first;
    Program* next;
    while (prg!=NULL) {
        next = prg->_next;
        delete prg;
        prg = next;
    }
}

int Menu::launch() {   
    Program* choice = _first;
    bool done = false;
        
    if (choice==NULL) return -1; // if no program
    
    startMenu();
    displaySelectedProgram(choice->_output_interface_argument);
           
    while(!done) {
        if (isSelectionChanging()) {
            // change the current choice
            choice = choice->_next;
            if (choice==NULL) choice = _first;
            displaySelectedProgram(choice->_output_interface_argument);
        }
        
        if (isValidating()) {
            // validate the choice
            done = true;
        }

        wait(0.1);
    }
        
    displaySelectedProgram(NULL);
    return choice->_program(); // call the program function and return the result
}