/* 
    Copyright (c) 2014 Romain Berrada
    
    Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
    and associated documentation files (the "Software"), to deal in the Software without restriction, 
    including without limitation the rights to use, copy, modify, merge, publish, distribute, 
    sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all copies or 
    substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
    BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
    DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "CommandDispatcher.h"

CommandDispatcher::CommandDispatcher() : _first_command(NULL) {
}

void CommandDispatcher::addCommand(char* commandName, void(*command_function)(unsigned int argc, char* argv[], char* result)) {
    CommandDispatcher::Command* com = new CommandDispatcher::Command();
    com->_name = new char[strlen(commandName)+1]; // +1 for the \0
    strcpy(com->_name, commandName);
    com->_function = command_function;
    com->_next = _first_command;
    _first_command = com;
}

void CommandDispatcher::cleanCommands() {
    CommandDispatcher::Command* com = _first_command;
    while (com!=NULL) {
        _first_command = com->_next;
        delete[] com->_name;
        delete com;
    }
}

bool CommandDispatcher::executeCommand(char* command, char* result) {
    CommandDispatcher::Command* command_ptr;
    bool function_return = false;
    unsigned int argc;
    char** argv;
    char* buffer;
    
    buffer = new char[strlen(command)+1]; // + 1 for the \0
    strcpy(buffer, command);
    
    argc = parse_buffer(buffer, &argv);
    toLowerCase(argv[0]);

    for (command_ptr=_first_command; command_ptr!=NULL; command_ptr = command_ptr->_next) {
        if (strcmp(argv[0], command_ptr->_name)==0) {
            command_ptr->_function(argc, argv, result);
            function_return = true;
            break;
        }    
    }
    
    delete[] argv;
    delete[] buffer;
    return function_return;
}

int CommandDispatcher::parse_buffer(char* buffer, char*** argv) {
    unsigned int i;
    unsigned int word_count;
    bool letter_found;
    unsigned int buffer_size = strlen(buffer);
    unsigned int argc;
    char** argv_tab;
    
    // 1st cycle, counting the number of words
    letter_found = false;
    word_count = 0;
    for (i=0; i<buffer_size; i++) {
        if (buffer[i]==' ' && letter_found) {
            word_count++;
            letter_found=false;
        } else letter_found=true;
    }
    if (letter_found) word_count++; // to get last word

    // create the array of words
    argv_tab = new char*[word_count];
    argc = word_count;
    
    // 2nd cycle, putting words into the array
    letter_found = false;
    word_count = 0;
    for (i=0; i<buffer_size; i++) {
        if (buffer[i]==' ') {
            buffer[i] = '\0';
            letter_found = false;  
        } else if (!letter_found) {
             argv_tab[word_count++]=&buffer[i];
             letter_found=true;
        }
    }
    
    *argv = argv_tab;
    return argc;
}

void CommandDispatcher::toLowerCase(char* word) {
    int i;
    for (i=0; i<strlen(word); i++) {
        if (word[i]>=65 && word[i]<=90) { // if between A-Z
            word[i] += 32;
        }    
    }   
}