#include "mbed.h"

DigitalOut ncs(p14);

SPI spi(p5,p6,p7);

void on() {
    ncs = 0;
}

void off() {
    ncs = 1;
}

void write(int address, char byte) {
    on();
    spi.write(0x02); // write data
    spi.write(address >> 8);
    spi.write(address & 0xFF);
    spi.write(byte);
    off();
}


void write(int address, char * buffer, int count) {
    on();
    spi.write(0x01); // write status
    spi.write(0x40); // sequential mode
    off();
    on();
    spi.write(0x02);
    spi.write(address >> 8);
    spi.write(address & 0xFF);
    for (int i = 0; i < count; i++) {
        spi.write(buffer[i]);
    }
    off();
    on();
    spi.write(0x01); // write status
    spi.write(0x0); //  byte mode
    off();
}


char read(int address) {
    on();
    spi.write(0x03);
    spi.write(address >> 8);
    spi.write(address & 0xFF);
    int result = spi.write(0);
    off();
    return (char) result;
}

int main() {
    off();
    char buff[50];
    write(0, 'h');
    write(1, 'i');
    write(2, '!');
    write(3, '\0');
    for (int address = 0; address < 4; address++) {
        buff[address] = read(address);
    }
    printf("mem = %s\r\n", buff);
    write(0, "Hello world!",12);
    for (int address = 0; address < 12; address++) {
        buff[address] = read(address);
    }
    buff[12]='\0';
    printf("now = %s\r\n", buff);
}