#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

#define SAMPLE_COUNT 1000

LocalFileSystem local("local");

DigitalOut led1(LED1);
DigitalIn sda(p9);
DigitalIn scl(p10);

char sdamem[SAMPLE_COUNT];
char sclmem[SAMPLE_COUNT];

EthernetNetIf eth;
HTTPServer svr;

void capture() {
    scl.mode(PullUp);
     while (scl) {
        wait_us(2);
    }
    for (int i = 0; i < SAMPLE_COUNT; i++) {
        sdamem[i] = sda;
        sclmem[i] = scl; 
        wait_us(1);
    }
}

void plot(FILE* fp, char * name, char * mem, int offset) {
    fprintf(fp, "<g transform='translate(100,%i)'>", offset);
    fprintf(fp, "<text x='10' y='40' style='fill:black;stroke:none;font-size:16pt;font-family:arial'>%s</text>", name);
    fprintf(fp, "<path d='M 50 50 ");
    for (int i = 0; i < SAMPLE_COUNT; i++) {
       fprintf(fp, "L %i %i %i %i ", 50+ 5*i, 50*mem[i], 55+5*i, 50*mem[i]);
    }
    fprintf(fp, "' />\n");
    fprintf(fp, "</g>");
}

void writeSVG() {
    FILE *fp = fopen("/local/out.svg", "w");  // Open "out.txt" on the local file system for writing
    fprintf(fp, "<svg xmlns='http://www.w3.org/2000/svg' width='1200' height='500'>\n");
    fprintf(fp, "<text x='500' y='50' style='fill:black;stroke:none;font-size:20pt;font-family:arial'>I2C bus activity</text>");
    fprintf(fp, "<g style='fill:none;stroke:black'>");
   
    plot(fp, "SDA", sdamem, 110);
    plot(fp, "SCL", sclmem, 210);
  
    fprintf(fp, "</g>");
    fprintf(fp, "</svg>");
    fclose(fp);
}

void startServer() {
EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return;
    }
    printf("Server setup OK\n");

    FSHandler::mount("/local", "/"); //Mount /webfs path on web root path
    svr.addHandler<FSHandler>("/"); //Default handler

    svr.bind(80);

    printf("Listening...\n");

    Timer tm;
    tm.start();
    //Listen indefinitely
    while (true) {
        Net::poll();
        if (tm.read()>.5) {
            led1=!led1; //Show that we are alive
            tm.start();
        }
    }
}


int main() {
    led1 = 0;
    capture();
    writeSVG();
    startServer();
}



